import org.openide.actions.*;
import org.openide.nodes.*;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/** A node with some children.
 *
 * @author root
 */
public class ContainerNode extends AbstractNode {
    
    public ContainerNode() {
        super(new ContainerChildren());
        setIconBase("/ContainerNodeIcon");
        // Whatever is most relevant to a user:
        setDefaultAction(SystemAction.get(PropertiesAction.class));
        // Set FeatureDescriptor stuff:
        setName("preferablyUniqueNameForThisNodeAmongSiblings"); // or, super.setName if needed
        setDisplayName(NbBundle.getMessage(ContainerNode.class, "LBL_node"));
        setShortDescription(NbBundle.getMessage(ContainerNode.class, "HINT_node"));
        // Add cookies, e.g.:
        /*
        getCookieSet ().add (new OpenCookie () {
                public void open () {
                    // Open something useful...
                }
            });
         */
        // Make reorderable:
        // getCookieSet ().add (new ReorderMe ());
    }
    
    // Create the popup menu:
    protected SystemAction[] createActions() {
        return new SystemAction[] {
            SystemAction.get(OpenLocalExplorerAction.class),
            null,
            // SystemAction.get (MyFavoriteAction.class),
            // null,                     // separator
            /* according to what it can do:
                   SystemAction.get (ReorderAction.class),
                   null,
                   SystemAction.get (CutAction.class),
                   SystemAction.get (CopyAction.class),
                   SystemAction.get (PasteAction.class),
                   null,
                   SystemAction.get (DeleteAction.class),
                   SystemAction.get (RenameAction.class),
                   null,
                   SystemAction.get (NewAction.class),
                   null,
             */
            SystemAction.get(ToolsAction.class),
            null,
            SystemAction.get(PropertiesAction.class),
        };
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
        // When you have help, change to:
        // return new HelpCtx (ContainerNode.class);
    }
    
    protected ContainerChildren getContainerChildren() {
        return (ContainerChildren) getChildren();
    }
    
    // RECOMMENDED - handle cloning specially (so as not to invoke the overhead of FilterNode):
    /*
    public Node cloneNode () {
        // Try to pass in similar constructor params to what you originally got:
        return new ContainerNode ();
    }
     */
    
    // Create a property sheet:
    /*
    protected Sheet createSheet () {
        Sheet sheet = super.createSheet ();
        // Make sure there is a "Properties" set:
        Sheet.Set props = sheet.get (Sheet.PROPERTIES); // get by name, not display name
        if (props == null) {
            props = Sheet.createPropertiesSet ();
            sheet.put (props);
        }
        props.put (new MyProp (someParams));
    }
     */
    
    // Permit new subnodes to be created:
    /*
    public NewType[] getNewTypes () {
        return new NewType[] { new NewType () {
                public String getName () {
                    return NbBundle.getMessage (ContainerNode.class, "LBL_NewType");
                }
                // If you have help:
                // public HelpCtx getHelpCtx () {
                //     return ContainerNode.class.getName () + ".newType";
                // }
                public void create () throws IOException {
                    // do whatever you need, e.g.:
                    getContainerChildren ().addKey (someNewKey);
                    // Throw an IOException if you are creating an underlying
                    // object and this fails.
                }
            }
        };
    }
     */
    
    // Permit things to be pasted into this node:
    /*
    protected void createPasteTypes (final Transferable t, List l) {
        // Make sure to pick up super impl, which adds intelligent node paste type:
        super.createPasteTypes (t, l);
        if (t.isDataFlavorSupported (DataFlavor.stringFlavor)) {
            l.add (new PasteType () {
                    public String getName () {
                        return NbBundle.getMessage (ContainerNode.class, "LBL_PasteType");
                    }
                    // If you have help:
                    // public HelpCtx getHelpCtx () {
                    //     return ContainerNode.class.getName () + ".pasteType";
                    // }
                    public Transferable paste () throws IOException {
                        try {
                            String data = (String) t.getTransferData (DataFlavor.stringFlavor);
                            // Or, you can look for nodes and related things in the transferable, using e.g.:
                            // Node n = NodeTransfer.node (t, NodeTransfer.COPY);
                            // Node[] ns = NodeTransfer.nodes (t, NodeTransfer.MOVE);
                            // MyCookie cookie = (MyCookie) NodeTransfer.cookie (t, NodeTransfer.COPY, MyCookie.class);
                            // do something, e.g.:
                            getContainerChildren ().addKey (data);
                            // Throw an IOException if you are creating an underlying
                            // object and this fails.
                            // To leave the clipboard as is:
                            return null;
                            // To clear the clipboard:
                            // return ExTransferable.EMPTY;
                        } catch (UnsupportedFlavorException ufe) {
                            // Should not happen, since t said it supported this flavor, but:
                            throw new IOException (ufe.getMessage ());
                        }
                    }
                });
        }
    }
     */
    
    // Handle renaming:
    /*
    public boolean canRename () {
        return true;
    }
    public void setName (String nue) {
        // Update visible name, fire property changes:
        super.setName (nue);
        // perform additional actions, i.e. rename underlying object
    }
     */
    
    // Handle deleting:
    /*
    public boolean canDestroy () {
        return true;
    }
    public void destroy () throws IOException {
        // Actually remove the node itself and fire property changes:
        super.destroy ();
        // perform additional actions, i.e. delete underlying object
        // (and don't forget about objects represented by your children!)
    }
     */
    
    // Handle copying and cutting specially:
    /*
    public boolean canCopy () {
        return true;
    }
    public boolean canCut () {
        return true;
    }
    public Transferable clipboardCopy () {
        // Add to, do not replace, the default node copy flavor:
        ExTransferable et = ExTransferable.create (super.clipboardCopy ());
        et.put (new ExTransferable.Single (DataFlavor.stringFlavor) {
                protected Object getData () {
                    return ContainerNode.this.getDisplayName ();
                }
            });
        return et;
    }
    public Transferable clipboardCut () {
        // Add to, do not replace, the default node cut flavor:
        ExTransferable et = ExTransferable.create (super.clipboardCut ());
        // This is not so useful because this node will not be destroyed afterwards
        // (it is up to the paste type to decide whether to remove the "original",
        // and it is not safe to assume that getData will only be called once):
        et.put (new ExTransferable.Single (DataFlavor.stringFlavor) {
                protected Object getData () {
                    return ContainerNode.this.getDisplayName ();
                }
            });
        return et;
    }
     */
    
    // Permit user to customize whole node at once (instead of per-property):
    /*
    public boolean hasCustomizer () {
        return true;
    }
    public Component getCustomizer () {
        return new MyCustomizingPanel (this);
    }
     */
    
    // Permit node to be reordered (you may also want to put
    // MoveUpAction and MoveDownAction on the subnodes, if you can,
    // but ReorderAction on the parent is enough):
    /*
    private class ReorderMe extends Index.Support {
     
        public Node[] getNodes () {
            return ContainerNode.this.getChildren ().getNodes ();
        }
     
        public int getNodesCount () {
            return getNodes ().length;
        }
     
        // This assumes that there is exactly one child node per key.
        // If you are using e.g. Children.Array, you can use shortcut implementations
        // of the Index cookie.
        public void reorder (int[] perm) {
            // Remember: {2, 0, 1} cycles three items forwards.
            List old = ContainerNode.this.getContainerChildren ().myKeys;
            if (list.size () != perm.length) throw new IllegalArgumentException ();
            List nue = new ArrayList (perm.length);
            for (int i = 0; i < perm.length; i++)
                nue.set (i, old.get (perm[i]));
            ContainerNode.this.getContainerChildren ().setKeys (nue);
        }
     
    }
     */
    
}
