import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;

class StatusBar extends JPanel implements Constants
{
    private StatusPane colorPane = new StatusPane("BLUE");
    private StatusPane typePane = new StatusPane("LINE");
    
    public StatusBar()
    {
        setLayout(new FlowLayout(FlowLayout.LEFT, 10, 3));
        setBackground(Color.lightGray);
        setBorder(BorderFactory.createLineBorder(Color.darkGray));
        setColorPane(DEFAULT_ELEMENT_COLOR);
        setTypePane(DEFAULT_ELEMENT_TYPE);
        add(colorPane);
        add(typePane);
    } // public StatusBar()
    
    public void setColorPane(Color color)
    {
        String text;
        if(color.equals(Color.red))
            text = "RED";
        else if(color.equals(Color.yellow))
            text = "YELLOW";
        else if(color.equals(Color.green))
            text = "GREEN";
        else if(color.equals(Color.blue))
            text = "BLUE";
        else
            text = "CUSTOM COLOR";
        colorPane.setForeground(color);
        colorPane.setText(text);
    } // public void setColorPane(Color color)
    
    public void setTypePane(int elementType)
    {
        String text;
        switch(elementType)
        {
            case LINE:
                text = "LINE";
                break;
            case RECTANGLE:
                text = "RECTANGLE";
                break;
            case CIRCLE:
                text = "CIRCLE";
                break;
            case CURVE:
                text = "CURVE";
                break;
            case TEXT:
                text = "TEXT";
                break;
            default:
                text = "ERROR";
                break;
        } // switch(elementType)
        typePane.setText(text);
    } // public void setTypePane(int elementType)
    
    class StatusPane extends JLabel
    {
        private Font paneFont = new Font("Serif", Font.PLAIN, 10);
        
        public StatusPane(String text)
        {
            setBackground(Color.lightGray);
            setForeground(Color.black);
            setFont(paneFont);
            setHorizontalAlignment(CENTER);
            setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            setPreferredSize(new Dimension(100, 20));
            setText(text);
        } // public StatusPane(String text)
    } // class StatusPane extends JLabel
} // class Status extends JPanel implements Constants
