import java.awt.geom.*;
import java.awt.*;

class Star
{
    private Point2D.Float start;
    private GeneralPath p;
    
    public Star(float x, float y)
    {
        start = new Point2D.Float(x, y);
        createStar();
    } // public Star(float x, float y)
    
    void createStar()
    {
        Point2D.Float point = start;
        p = new GeneralPath(GeneralPath.WIND_NON_ZERO);
        p.moveTo(point.x, point.y);
        p.lineTo(point.x + 20.0f, point.y - 5.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x + 5.0f, point.y - 20.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x + 5.0f, point.y + 20.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x + 20.0f, point.y + 5.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x - 20.0f, point.y + 5.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x - 5.0f, point.y + 20.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.lineTo(point.x - 5.0f, point.y - 20.0f);
        point = (Point2D.Float)p.getCurrentPoint();
        p.closePath();        
    } // void createStar()
    
    Shape atLocation(float x, float y)
    {
        start.setLocation(x, y);
        p.reset();
        createStar();
        return p;
    } // Shape atLocation(float x, float y)
    
    Shape getShape()
    {
        return p;
    } // Shape getShape()
    
} // class Star
