import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class SketchFrame2 extends JFrame implements Constants, ActionListener, Observer
{
    private String p_path = "/root/java/sketcher/";
    
    private JMenuBar menuBar = new JMenuBar();
    private Color elementColor = DEFAULT_ELEMENT_COLOR;
    private int elementType = DEFAULT_ELEMENT_TYPE;
    private Font font = DEFAULT_FONT;
    
    private FileAction newAction, openAction, closeAction, saveAction, saveAsAction, printAction;
    private TypeAction lineAction, rectangleAction, circleAction, curveAction, textAction;
    private ColorAction redAction, yellowAction, greenAction, blueAction;
    
    private JToolBar toolBar = new JToolBar();
    
    private Sketcher theApp;
    
    private StatusBar statusBar = new StatusBar();
    
    private JMenuItem aboutItem, fontItem;
    
    private FontDialog fontDlg;
    
    private JPopupMenu popup = new JPopupMenu("General");
    
    private JMenuItem customColorItem;
    
    private String frameTitle;
    private String filename = DEFAULT_FILENAME;
    private File modelFile;
    
    private boolean sketchChanged = false;
    
    private JFileChooser files;
        
    public SketchFrame2(String title, Sketcher theApp)
    {
        //setTitle(title);
        
        this.theApp = theApp;
        
        setJMenuBar(menuBar);
        
        JMenu fileMenu = new JMenu("File");
        JMenu elementMenu = new JMenu("Elements");
        JMenu optionsMenu = new JMenu("Options");
        JMenu helpMenu = new JMenu("Help");
        
        fileMenu.setMnemonic('F');
        elementMenu.setMnemonic('E');
        optionsMenu.setMnemonic('O');
        helpMenu.setMnemonic('H');
        
        fontDlg = new FontDialog(this);
        
        /*
        JMenuItem item;
        item = fileMenu.add(newAction = new FileAction("New"));
        item.setAccelerator(KeyStroke.getKeyStroke('N', Event.CTRL_MASK));
        
        item = fileMenu.add(openAction = new FileAction("Open"));
        item.setAccelerator(KeyStroke.getKeyStroke('O', Event.CTRL_MASK));
        
        item = fileMenu.add(closeAction = new FileAction("Close"));
        fileMenu.addSeparator();
        
        item = fileMenu.add(saveAction = new FileAction("Save"));
        item.setAccelerator(KeyStroke.getKeyStroke('S', Event.CTRL_MASK));
        
        item = fileMenu.add(saveAsAction = new FileAction("Save As..."));
        fileMenu.addSeparator();
         
        
        item = fileMenu.add(printAction = new FileAction("Print"));
        item.setAccelerator(KeyStroke.getKeyStroke('P', Event.CTRL_MASK));
         */
        
        addMenuItem(fileMenu, newAction = new FileAction("New", "Create new sketch"), KeyStroke.getKeyStroke('N', Event.CTRL_MASK));
        addMenuItem(fileMenu, openAction = new FileAction("Open", "Open existing sketch"), KeyStroke.getKeyStroke('O', Event.CTRL_MASK));
        addMenuItem(fileMenu, closeAction = new FileAction("Close", "Close sketch"));
        fileMenu.addSeparator();                    // add separator
        addMenuItem(fileMenu, saveAction = new FileAction("Save", "Save sketch"), KeyStroke.getKeyStroke('S', Event.CTRL_MASK));
        addMenuItem(fileMenu, saveAsAction = new FileAction("Save As...", "Save as new file"));
        fileMenu.addSeparator();                    // add separator
        addMenuItem(fileMenu, printAction = new FileAction("Print", "Print sketch"), KeyStroke.getKeyStroke('P', Event.CTRL_MASK));
        fileMenu.addSeparator();                    // add separator
        addMenuItem(fileMenu, closeAction = new FileAction("Exit", "Exit Sketcher"), KeyStroke.getKeyStroke('X', Event.CTRL_MASK));
                
        /*
        elementMenu.add(lineAction = new TypeAction("Line", LINE));
        elementMenu.add(rectangleAction = new TypeAction("Rectangle", RECTANGLE));
        elementMenu.add(circleAction = new TypeAction("Circle", CIRCLE));
        elementMenu.add(curveAction = new TypeAction("Curve", CURVE));
         */
        
        addMenuItem(elementMenu, lineAction = new TypeAction("Line", LINE, "Draw lines"));
        addMenuItem(elementMenu, rectangleAction = new TypeAction("Rectangle", RECTANGLE, "Draw rectangle"));
        addMenuItem(elementMenu, circleAction = new TypeAction("Circle", CIRCLE, "Draw circle"));
        addMenuItem(elementMenu, curveAction = new TypeAction("Curve", CURVE, "Draw curves"));
        addMenuItem(elementMenu, textAction = new TypeAction("Text", TEXT, "Draw text"), null);
        
        elementMenu.addSeparator();
        
        JMenu colorMenu = new JMenu("Color");
        elementMenu.add(colorMenu);
        
        /*
        colorMenu.add(redAction = new ColorAction("Red", Color.red));
        colorMenu.add(yellowAction = new ColorAction("Yellow", Color.yellow));
        colorMenu.add(greenAction = new ColorAction("Green", Color.green));
        colorMenu.add(blueAction = new ColorAction("Blue", Color.blue));
         */
        
        addMenuItem(colorMenu, redAction = new ColorAction("Red", Color.red, "Draw in red"));
        addMenuItem(colorMenu, yellowAction = new ColorAction("Yellow", Color.yellow, "Draw in yellow"));
        addMenuItem(colorMenu, greenAction = new ColorAction("Green", Color.green, "Draw in green"));
        addMenuItem(colorMenu, blueAction = new ColorAction("Blue", Color.blue, "Draw in blue"));
                
        menuBar.add(fileMenu);
        menuBar.add(elementMenu);
        
        //openAction.putValue(Action.SMALL_ICON, new ImageIcon(p_path + "images/gem.gif"));
        //openAction.putValue(Action.NAME, "Open");
        //JButton button = toolBar.add(openAction);
        //button.setText(null);
        //button.setBorder(BorderFactory.createRaisedBevelBorder());
        
        toolBar.addSeparator();
        addToolBarButton(newAction);
        addToolBarButton(openAction);
        addToolBarButton(saveAction);
        addToolBarButton(printAction);
        
        toolBar.addSeparator();
        addToolBarButton(lineAction);
        addToolBarButton(rectangleAction);
        addToolBarButton(circleAction);
        addToolBarButton(curveAction);
        
        addToolBarButton(textAction);
        
        toolBar.addSeparator();
        addToolBarButton(redAction);
        addToolBarButton(yellowAction);
        addToolBarButton(greenAction);
        addToolBarButton(blueAction);
        toolBar.addSeparator();
                
        toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(2, 2, 4, 4)));
        
        toolBar.setFloatable(false);
        getContentPane().add(toolBar, BorderLayout.NORTH);
                        
        //saveAction.setEnabled(false);
        //closeAction.setEnabled(false);
        //printAction.setEnabled(false);
        
        fontItem = new JMenuItem("Choose font...");
        fontItem.addActionListener(this);
        optionsMenu.add(fontItem);
        menuBar.add(optionsMenu);
        
        aboutItem = new JMenuItem("About");
        aboutItem.addActionListener(this);
        helpMenu.add(aboutItem);
        menuBar.add(helpMenu);
        
        popup.add(lineAction);
        popup.add(rectangleAction);
        popup.add(circleAction);
        popup.add(curveAction);
        popup.add(textAction);
        
        popup.addSeparator();
        popup.add(redAction);
        popup.add(yellowAction);
        popup.add(greenAction);
        popup.add(blueAction);
        
        customColorItem = popup.add("Custom Color...");
        customColorItem.addActionListener(this);
        
        getContentPane().add(statusBar, BorderLayout.SOUTH);
        
        frameTitle = title + ": ";
        setTitle(frameTitle + filename);
        if(!DEFAULT_DIRECTORY.exists())
            if(!DEFAULT_DIRECTORY.mkdirs())
                JOptionPane.showMessageDialog(this, "Error creating default directory", "Directory Creation Error", JOptionPane.ERROR_MESSAGE);
        
        files = new JFileChooser(DEFAULT_DIRECTORY);
    } // public SketchFrame(String title)
    
    private JButton addToolBarButton(Action action)
    {
        JButton button = toolBar.add(action);
        button.setToolTipText((String) action.getValue(action.SHORT_DESCRIPTION));
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.setText(null);
        return button;
    } // private JButton addToolBarButton(Action action)
    
    private JMenuItem addMenuItem(JMenu menu, Action action)
    {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    } // private JMenuItem addMenuItem(JMenu menu, Action action)
    
    private JMenuItem addMenuItem(JMenu menu, Action action, KeyStroke keystroke)
    {
        JMenuItem item = addMenuItem(menu, action);
        item.setAccelerator(keystroke);
        return item;
    } // private JMenuItem addMenuItem(JMenu menu, Action action, KeyStroke keystroke)
    
    public Color getElementColor()
    {
        return elementColor;
    } // public Color getElementColor()
    
    public int getElementType()
    {
        return elementType;
    }
    
    public Font getCurrentFont()
    {
        return font;
    } // public Font getCurrentFont()
    
    
    public void setCurrentFont(Font font)
    {
        this.font = font;
    } // public void setCurrentFont(Font font)
    
    public JPopupMenu getPopup()
    {
        return popup;
    } // public JPopupMenu getPopup()
    
    private File showDialog (String dialogTitle, String approveButtonText, String approveButtonTooltip, char approveButtonMnemonic, File file)
    {
        files.setDialogTitle(dialogTitle);
        files.setApproveButtonText(approveButtonText);
        files.setApproveButtonToolTipText(approveButtonTooltip);
        files.setApproveButtonMnemonic(approveButtonMnemonic);
        files.setFileSelectionMode(files.FILES_ONLY);
        files.rescanCurrentDirectory();
        files.setSelectedFile(file);
        
        ExtensionFilter sketchFilter = new ExtensionFilter(".ske", "Sketch filse (*.ske)");
        files.addChoosableFileFilter(sketchFilter);         // Add the filter
        files.setFileFilter(sketchFilter);                  // and select it
        
        int result = files.showDialog(SketchFrame2.this, null);
        return (result == files.APPROVE_OPTION) ? files.getSelectedFile() : null;
    } // private File showDialog (String dialogTitle, String approveButtonText, String approveButtonTooltip, char approveButtonMnemonic, File file)
    
    private void saveOperation()
    {
        if(!sketchChanged)
            return;
        if(modelFile != null)
            saveSketch(modelFile);
        else
        {
            File file = showDialog("Save Sketch", "Save", "Save the sketch", 's', new File(files.getCurrentDirectory(), filename));
            if(file == null)
                return;
            else
                if(file.exists())
                    if(JOptionPane.NO_OPTION == JOptionPane.showConfirmDialog(SketchFrame2.this, file.getName() + " exists. Overwrite?", "Confirm Save As", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE))
                        return;
            saveSketch(file);
        } // else
    } // private void saveOperation()
    
    private void saveSketch(File outFile)
    {
        try
        {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            out.writeObject(theApp.getModel());
            out.flush();
            out.close();
        } // try
        catch(IOException e)
        {
            System.out.println(e);
            JOptionPane.showMessageDialog(SketchFrame2.this, "Error writing a sketch file.", "File Output Error", JOptionPane.ERROR_MESSAGE);
            return;
        } // catch(IOException e)
        if(outFile != modelFile)
        {
            modelFile = outFile;
            filename = modelFile.getName();
            setTitle(frameTitle + modelFile.getPath());
        } // if(outFile != modelFile)
        sketchChanged = false;
    } // private void saveSketch(File outFile)
        
    public void checkForSave()
    {
        if(sketchChanged)
            if(JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(SketchFrame2.this, "Current file has changed. Save current file?", "Confirm Save Current File", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE))
                saveOperation();
    } // public void checkForSave()
    
    public void openSketch(File inFile)
    {
        try
        {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            theApp.insertModel((SketchModel) in .readObject());
            in.close();
            modelFile = inFile;                             // Update the filename
            filename = modelFile.getName();                 // Change the window title
            setTitle(frameTitle + modelFile.getPath());     // Status is unchanged
            sketchChanged = false;
        } // try
        catch(Exception e)
        {
            System.out.println(e);
            JOptionPane.showMessageDialog(SketchFrame2.this, "Error reading a sketch file.", "File Input Error", JOptionPane.ERROR_MESSAGE);
        } // catch(Exception e)
    } // public void openSketch(File inFile)
    
    public void actionPerformed(java.awt.event.ActionEvent e) {
        if(e.getSource() == aboutItem)
        {
            //AboutDialog aboutDlg = new AboutDialog(this, "About Sketcher", "Created by ԥ 2002");
            JOptionPane.showMessageDialog((Component)e.getSource(), "Created by ԥ 2002", "About Sketcher", JOptionPane.INFORMATION_MESSAGE);
            //String input = JOptionPane.showInputDialog("Enter Input:");
            //String input = JOptionPane.showInputDialog(null, "Enter Input:", "Dialog for Input", JOptionPane.WARNING_MESSAGE);
            //String[] choices = {"Money", "Health", "Happiness", "This", "That", "The Other"};
            //String input = (String) JOptionPane.showInputDialog(null, "Choose now...", "The Choice of a Lifetime", JOptionPane.QUESTION_MESSAGE, null, choices, choices[1]);
            //JOptionPane.showMessageDialog((Component)e.getSource(), "Created by ԥ 2002\n" + input, "About Sketcher", JOptionPane.INFORMATION_MESSAGE);
        } // if(e.getSource() == aboutItem)
        else if(e.getSource() == fontItem)
        {
            Rectangle bounds = getBounds();
            fontDlg.setLocation(bounds.x + bounds.width/3, bounds.y + bounds.height/3);
            
            fontDlg.setVisible(true);
        } // else if(e.getSource() == fontItem)
        else if(e.getSource() == customColorItem)
        {
            Color color = JColorChooser.showDialog(this, "Select Custom Color", elementColor);
            
            if(color != null)
            {
                elementColor = color;
                statusBar.setColorPane(color);
            } // if(color != null)
        } // else if(e.getSource() == customColorItem)
    }
    
    public void update(java.util.Observable o, Object obj) {
        sketchChanged = true;
    }
    
 // public int getElementType()
    
    class FileAction extends AbstractAction
    {
        
        FileAction(String name)
        {
            super(name);
            String iconFileName = p_path + "images/open.gif";
            if(new File(iconFileName).exists())
                putValue(SMALL_ICON, new ImageIcon(iconFileName));           
        } // FileAction(String name)
        
        FileAction(String name, String tooltip)
        {
            this(name);
            if(tooltip != null)
                putValue(SHORT_DESCRIPTION, tooltip);
        } // FileAction(String name, String toolTip)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            String name = (String) getValue(NAME);
            if(name.equals(saveAction.getValue(NAME)))
            {
                //int result = files.showSaveDialog(SketchFrame2.this);
                saveOperation();
            } // if(name.equals(saveAction.getValue(NAME)))
            else if(name.equals(saveAsAction.getValue(NAME)))
            {
                File file = showDialog("Save Sketch As", "Save", "Save the sketch", 's', modelFile == null ? new File(files.getCurrentDirectory(), filename) : modelFile);
                if(file != null)
                {
                    if(file.exists() && !file.equals(modelFile))
                        if(JOptionPane.NO_OPTION == JOptionPane.showConfirmDialog(SketchFrame2.this, file.getName() + " exists. Overwrite?", "Confirm Save As", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE)) // Overwrite warning, No file selected
                            return;
                    saveSketch(file);
                } // if(file != null)
                return;
            } // else if(name.equals(saveAsAction.getValue(NAME)))
            else if(name.equals(openAction.getValue(NAME)))
            {
                checkForSave();
                
                File file = showDialog("Open Sketch File", "Open", "Read a sketch from file", 'o', null); // Dialog window title, button label, Button tooltip text, Shortcut character, No file selected, If a file was selected, then read it
                if(file != null)
                    openSketch(file);
            } // else if(name.equals(openAction.getValue(NAME)))
            else if(name.equals(newAction.getValue(NAME)))
            {
                checkForSave();
                theApp.insertModel(new SketchModel());              // Insert new empty sketch
                modelFile = null;                                   // No file for it
                filename = DEFAULT_FILENAME;                        // Default name
                setTitle(frameTitle + files.getCurrentDirectory() + "\\" + filename);
                sketchChanged = false;                              // Not changed yet
            } // else if(name.equals(newAction.getValue(NAME)))
            else if(name.equals(printAction.getValue(NAME)))
            {
                
            } // else if(name.equals(printAction.getValue(NAME)))
            else if(name.equals(closeAction.getValue(NAME)))
            {
                checkForSave();
                System.exit(0);
            } // else if(name.equals(closeAction.getValue(NAME)))
        }
        
    } // class FileAction extends AbstractAction
    
    class TypeAction extends AbstractAction
    {
        private int typeID;
        
        TypeAction(String name, int typeID)
        {
            super(name);
            this.typeID = typeID;
            String iconFileName = p_path + "images/g_greenon.gif";
            if(new File(iconFileName).exists())
                putValue(SMALL_ICON, new ImageIcon(iconFileName));
        } // TypeAction(String name, int typeID)
        
        
        TypeAction(String name, int typeID, String tooltip)
        {
            this(name, typeID);
            if(tooltip != null)
                putValue(SHORT_DESCRIPTION, tooltip);
        } // TypeAction(String name, int typeID, String toolTip)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            elementType = typeID;
            statusBar.setTypePane(typeID);
        }
        
    } // class TypeAction extends AbstractAction
    
    class ColorAction extends AbstractAction
    {
        private Color color;
        
        public ColorAction(String name, Color color)
        {
            super(name);
            this.color = color;
            String iconFileName = p_path + "images/gem.gif";
            if(new File(iconFileName).exists())
                putValue(SMALL_ICON, new ImageIcon(iconFileName));
        } // public ColorAction(String name, Color color)
        
        public ColorAction(String name, Color color, String tooltip)
        {
            this(name, color);
            if(tooltip != null)
                putValue(SHORT_DESCRIPTION, tooltip);
        } // public ColorAction(String name, int typeID, String toolTip)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            elementColor = color;
            statusBar.setColorPane(color);
//---------------------------------------------------------------------------            
            //getContentPane().setBackground(color);
//---------------------------------------------------------------------------
        }
        
    } // class ColorAction extends AbstractAction
    
    public class AboutDialog extends JDialog implements ActionListener
    {
        public AboutDialog(Frame parent, String title, String message)
        {
            super(parent, title, true);
            
            if(parent != null)
            {
                Dimension parentSize = parent.getSize();
                Point p = parent.getLocation();
                setLocation(p.x + parentSize.width/4, p.y + parentSize.height/4);
            } // if(parent != null)
            
            JPanel messagePane = new JPanel();
            messagePane.add(new JLabel(message));
            getContentPane().add(messagePane);
            
            JPanel buttonPane = new JPanel();
            JButton button = new JButton("OK");
            buttonPane.add(button);
            button.addActionListener(this);
            getContentPane().add(buttonPane, BorderLayout.SOUTH);
            setDefaultCloseOperation(DISPOSE_ON_CLOSE);
            pack();
            setVisible(true);
                              
        } // public AboutDialog(Frame parent, String title, String message)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            setVisible(false);
            dispose();
        }
        
    } //  public class AboutDialog extends JDialog implements ActionListener
} // public class SketchFrame2 extends JFrame implements Constants, ActionListener