import javax.swing.filechooser.FileFilter;
import java.io.File;

public class ExtensionFilter extends FileFilter
{
    private String description;             // Filter description
    private String extension;               // File extension, including.
    
    public ExtensionFilter(String ext, String descr)
    {
        extension = ext.toLowerCase();          // Store the extension as lower case
        description = descr;
    } // public ExtensionFilter(String ext, String descr)
    
    public boolean accept(java.io.File file) {
        return (file.isDirectory() || file.getName().toLowerCase().endsWith(extension));
    }
    
    public String getDescription() {
        return description;
    }
    
} // public class ExtensionFilter extends FileFilter
