package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.wizards.*;

// the GenericWizardlet provides alot of methods we can use directly
public class ValveElementWizardlet extends GenericWizardlet
{
    /*
    protected String[] allAttr = {};                         // holds all the attributes
    protected boolean[] requiredAttr = {};                    // required attributes
    protected String[] attrDefaultValue = {};
    protected boolean[] hasComboBoxValues = {};
    protected String[][] comboBoxValues = {};
    protected boolean[] useFileChooser = {};
    protected boolean[] chooseOnlyDirectories = {};
     */
    
    //------------------------------------------------------------------------
    //org.apache.catalina.valves.AccessLogValve
    protected String[] allAttr1 = {"className", "directory", "pattern", "prefix", "resolveHosts", "suffix"};                         // holds all the attributes
    protected boolean[] requiredAttr1 = {true, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue1 = {"org.apache.catalina.valves.AccessLogValve", "", "", "", "", ""};                    // attributes values
    protected boolean[] hasComboBoxValues1 = {false, false, false, false, true, false};
    protected String[][] comboBoxValues1 = {null, null, null, null, {"", "false", "true"}, null};
    protected boolean[] useFileChooser1 = {false, true, false, false, false, false};
    protected boolean[] chooseOnlyDirectories1 = {false, true, false, false, false, false};
    protected String originalTextValue1 = "";
    protected String defaultTextValue1 = "";
    protected boolean hasTextElement1 = false;
    
    //org.apache.catalina.valves.RemoteAddrValve
    protected String[] allAttr2 = {"className", "allow", "deny"};                         // holds all the attributes
    protected boolean[] requiredAttr2 = {true, false, false};                    // required attributes
    protected String[] attrDefaultValue2 = {"org.apache.catalina.valves.RemoteAddrValve", "", ""};                    // attributes values
    protected boolean[] hasComboBoxValues2 = {false, false, false};
    protected String[][] comboBoxValues2 = {null, null, null};
    protected boolean[] useFileChooser2 = {false, false, false};
    protected boolean[] chooseOnlyDirectories2 = {false, false, false};
    protected String originalTextValue2 = "";
    protected String defaultTextValue2 = "";
    protected boolean hasTextElement2 = false;
    
    //org.apache.catalina.valves.RemoteHostValve
    protected String[] allAttr3 = {"className", "allow", "deny"};                         // holds all the attributes
    protected boolean[] requiredAttr3 = {true, false, false};                    // required attributes
    protected String[] attrDefaultValue3 = {"org.apache.catalina.valves.RemoteHostValve", "", ""};                    // attributes values
    protected boolean[] hasComboBoxValues3 = {false, false, false};
    protected String[][] comboBoxValues3 = {null, null, null};
    protected boolean[] useFileChooser3 = {false, false, false};
    protected boolean[] chooseOnlyDirectories3 = {false, false, false};
    protected String originalTextValue3 = "";
    protected String defaultTextValue3 = "";
    protected boolean hasTextElement3 = false;
    
    //org.apache.catalina.valves.RequestDumperValve
    protected String[] allAttr4 = {"className"};                         // holds all the attributes
    protected boolean[] requiredAttr4 = {true};                    // required attributes
    protected String[] attrDefaultValue4 = {"org.apache.catalina.valves.RequestDumperValve"};                    // attributes values
    protected boolean[] hasComboBoxValues4 = {false};
    protected String[][] comboBoxValues4 = {null};
    protected boolean[] useFileChooser4 = {false};
    protected boolean[] chooseOnlyDirectories4 = {false};
    protected String originalTextValue4 = "";
    protected String defaultTextValue4 = "";
    protected boolean hasTextElement4 = false;
    
    //org.apache.catalina.authenticator.SingleSignOn
    protected String[] allAttr5 = {"className", "debug"};                         // holds all the attributes
    protected boolean[] requiredAttr5 = {true, false};                    // required attributes
    protected String[] attrDefaultValue5 = {"org.apache.catalina.authenticator.SingleSignOn", ""};                    // attributes values
    protected boolean[] hasComboBoxValues5 = {false, false};
    protected String[][] comboBoxValues5 = {null, null};
    protected boolean[] useFileChooser5 = {false, false};
    protected boolean[] chooseOnlyDirectories5 = {false, false};
    protected String originalTextValue5 = "";
    protected String defaultTextValue5 = "";
    protected boolean hasTextElement5 = false;
    //------------------------------------------------------------------------
    
    //------------------------------------------------------------------------
    //protected String originalTextValue = "";
    //protected JTextField textValueField;
    //protected Node originalTextNode;    
    //protected String defaultTextValue = "";
    //protected boolean hasTextElement = true;        // this indicates that it has a TextElement
    protected int adjustedHeight = 0;       // note: we only use this to adjust the height if this is a text element
    //------------------------------------------------------------------------
    
    public ValveElementWizardlet(String valveName, Document doc)
    {
        super();
        
        
        /*
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasComboBoxValues = hasComboBoxValues;
        super.comboBoxValues = comboBoxValues;
        super.useFileChooser = useFileChooser;
        super.chooseOnlyDirectories = chooseOnlyDirectories;
        this.doc = doc;
         */
                
        //------------------------------------------------------------------------
        /*
        super.originalTextValue = originalTextValue;
        //super.textValueField = textValueField;
        //super.originalTextNode = originalTextNode;
        super.defaultTextValue = defaultTextValue;
        super.hasTextElement = hasTextElement;
        super.adjustedHeight = adjustedHeight;
         */
        
        //------------------------------------------------------------------------
        this.doc = doc;
        super.adjustedHeight = adjustedHeight;
        
        if(valveName.equals("org.apache.catalina.valves.AccessLogValve"))
        {
            super.allAttr = allAttr1;
            super.requiredAttr = requiredAttr1;
            super.attrDefaultValue = attrDefaultValue1;
            super.hasComboBoxValues = hasComboBoxValues1;
            super.comboBoxValues = comboBoxValues1;
            super.useFileChooser = useFileChooser1;
            super.chooseOnlyDirectories = chooseOnlyDirectories1;
            super.originalTextValue = originalTextValue1;
            super.defaultTextValue = defaultTextValue1;
            super.hasTextElement = hasTextElement1;
        } // if(attrNodeValue.equals("org.apache.catalina.valves.AccessLogValve"))
        else if(valveName.equals("org.apache.catalina.valves.RemoteAddrValve"))
        {
            super.allAttr = allAttr2;
            super.requiredAttr = requiredAttr2;
            super.attrDefaultValue = attrDefaultValue2;
            super.hasComboBoxValues = hasComboBoxValues2;
            super.comboBoxValues = comboBoxValues2;
            super.useFileChooser = useFileChooser2;
            super.chooseOnlyDirectories = chooseOnlyDirectories2;
            super.originalTextValue = originalTextValue2;
            super.defaultTextValue = defaultTextValue2;
            super.hasTextElement = hasTextElement2;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteAddrValve"))
        else if(valveName.equals("org.apache.catalina.valves.RemoteHostValve"))
        {
            super.allAttr = allAttr3;
            super.requiredAttr = requiredAttr3;
            super.attrDefaultValue = attrDefaultValue3;
            super.hasComboBoxValues = hasComboBoxValues3;
            super.comboBoxValues = comboBoxValues3;
            super.useFileChooser = useFileChooser3;
            super.chooseOnlyDirectories = chooseOnlyDirectories3;
            super.originalTextValue = originalTextValue3;
            super.defaultTextValue = defaultTextValue3;
            super.hasTextElement = hasTextElement3;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteHostValve"))
        else if(valveName.equals("org.apache.catalina.valves.RequestDumperValve"))
        {
            super.allAttr = allAttr4;
            super.requiredAttr = requiredAttr4;
            super.attrDefaultValue = attrDefaultValue4;
            super.hasComboBoxValues = hasComboBoxValues4;
            super.comboBoxValues = comboBoxValues4;
            super.useFileChooser = useFileChooser4;
            super.chooseOnlyDirectories = chooseOnlyDirectories4;
            super.originalTextValue = originalTextValue4;
            super.defaultTextValue = defaultTextValue4;
            super.hasTextElement = hasTextElement4;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RequestDumperValve"))
        else if(valveName.equals("org.apache.catalina.authenticator.SingleSignOn"))
        {
            super.allAttr = allAttr5;
            super.requiredAttr = requiredAttr5;
            super.attrDefaultValue = attrDefaultValue5;
            super.hasComboBoxValues = hasComboBoxValues5;
            super.comboBoxValues = comboBoxValues5;
            super.useFileChooser = useFileChooser5;
            super.chooseOnlyDirectories = chooseOnlyDirectories5;
            super.originalTextValue = originalTextValue5;
            super.defaultTextValue = defaultTextValue5;
            super.hasTextElement = hasTextElement5;
        } // else if(attrNodeValue.equals("org.apache.catalina.authenticator.SingleSignOn"))
        else
            ;       // do nothing
        
        doAllAttrProcessing();
    } // public ValveElementWizardlet(Document)
    
    public Object createUserObject()
    {
        Node valveElementNode = doc.createElement("Valve");
        NamedNodeMap namedNodeMap = valveElementNode.getAttributes();
        
        //getPropertyValueForPropertyName(String propertyName)
        for(int i = 0; i < allAttr.length; i++)
        {
            String attrValue = getPropertyValueForPropertyName(allAttr[i]);
            
            if(!attrValue.equals(""))
            {
                Node attr = doc.createAttribute(allAttr[i]);
                attr.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(attr);
            } // if(!attrValue.equals(""))
        } // for(int i = 0; i < allAttr.length; i++)
        
        // create a text value
        if(hasTextElement)
            if(!super.textValueField.getText().equals(""))
                valveElementNode.appendChild(doc.createTextNode(super.textValueField.getText()));
        
        userObject = valveElementNode;
        return userObject;
    } // public Object createUserObject()
    
    public String getStepName()
    {
        return "Enter Valve Attributes";
    } // public String getStepName()
} // public class ValveElementWizardlet extends Wizardlet