package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class ValveElementNodeObject extends ElementNodeObject
{
    protected String nodeActionList_deleteValveAction = "Delete Valve";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, nodeActionList_deleteValveAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    //------------------------------------------------------------------------
    //org.apache.catalina.valves.AccessLogValve
    protected String[] allAttr1 = {"className", "directory", "pattern", "prefix", "resolveHosts", "suffix"};                         // holds all the attributes
    protected boolean[] requiredAttr1 = {true, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue1 = {"", "", "", "", "", ""};                    // attributes values
    protected boolean hasTextElement1 = false;
    
    //org.apache.catalina.valves.RemoteAddrValve
    protected String[] allAttr2 = {"className", "allow", "deny"};                         // holds all the attributes
    protected boolean[] requiredAttr2 = {true, false, false};                    // required attributes
    protected String[] attrDefaultValue2 = {"", "", ""};                    // attributes values
    protected boolean hasTextElement2 = false;
    
    //org.apache.catalina.valves.RemoteHostValve
    protected String[] allAttr3 = {"className", "allow", "deny"};                         // holds all the attributes
    protected boolean[] requiredAttr3 = {true, false, false};                    // required attributes
    protected String[] attrDefaultValue3 = {"", "", ""};                    // attributes values
    protected boolean hasTextElement3 = false;
    
    //org.apache.catalina.valves.RequestDumperValve
    protected String[] allAttr4 = {"className"};                         // holds all the attributes
    protected boolean[] requiredAttr4 = {true};                    // required attributes
    protected String[] attrDefaultValue4 = {""};                    // attributes values
    protected boolean hasTextElement4 = false;
    
    //org.apache.catalina.authenticator.SingleSignOn
    protected String[] allAttr5 = {"className", "debug"};                         // holds all the attributes
    protected boolean[] requiredAttr5 = {true, false};                    // required attributes
    protected String[] attrDefaultValue5 = {"", ""};                    // attributes values
    protected boolean hasTextElement5 = false;
    //------------------------------------------------------------------------
        
    public ValveElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        Node valveElementNode = (Node) userObject;
        NamedNodeMap namedNodeMap = valveElementNode.getAttributes();
        
        String nameAttrValue = "";
        Node attrNode = namedNodeMap.getNamedItem("className");
        String attrNodeValue = attrNode.getNodeValue();
        
        if(attrNodeValue.equals("org.apache.catalina.valves.AccessLogValve"))
        {
            super.allAttr = allAttr1;
            super.requiredAttr = requiredAttr1;
            super.attrDefaultValue = attrDefaultValue1;
            super.hasTextElement = hasTextElement1;
        } // if(attrNodeValue.equals("org.apache.catalina.valves.AccessLogValve"))
        else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteAddrValve"))
        {
            super.allAttr = allAttr2;
            super.requiredAttr = requiredAttr2;
            super.attrDefaultValue = attrDefaultValue2;
            super.hasTextElement = hasTextElement2;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteAddrValve"))
        else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteHostValve"))
        {
            super.allAttr = allAttr3;
            super.requiredAttr = requiredAttr3;
            super.attrDefaultValue = attrDefaultValue3;
            super.hasTextElement = hasTextElement3;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RemoteHostValve"))
        else if(attrNodeValue.equals("org.apache.catalina.valves.RequestDumperValve"))
        {
            super.allAttr = allAttr4;
            super.requiredAttr = requiredAttr4;
            super.attrDefaultValue = attrDefaultValue4;
            super.hasTextElement = hasTextElement4;
        } // else if(attrNodeValue.equals("org.apache.catalina.valves.RequestDumperValve"))
        else if(attrNodeValue.equals("org.apache.catalina.authenticator.SingleSignOn"))
        {
            super.allAttr = allAttr5;
            super.requiredAttr = requiredAttr5;
            super.attrDefaultValue = attrDefaultValue5;
            super.hasTextElement = hasTextElement5;
        } // else if(attrNodeValue.equals("org.apache.catalina.authenticator.SingleSignOn"))
        else
            ;       // do nothing
        
    } // public ValveElementNodeObject()
    
    public ValveElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public ValveElementNodeObject()
    
    public ValveElementNodeObject()
    {
        this(null, null);
    } // public ValveElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_deleteValveAction))
        {
            String message = "Delete Valve Element?";
             
            performDeleteElementAction(message, parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Host");
        } // if(actionName.equals(nodeActionList_addHostAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
} // public class ValveElementNodeObject extends ElementNodeObject