package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.wizards.*;

// the GenericWizardlet provides alot of methods we can use directly
public class LoggerElementWizardlet extends GenericWizardlet
{
    /*
    protected String[] allAttr = {};                         // holds all the attributes
    protected boolean[] requiredAttr = {};                    // required attributes
    protected String[] attrDefaultValue = {};
    protected boolean[] hasComboBoxValues = {};
    protected String[][] comboBoxValues = {};
    protected boolean[] useFileChooser = {};
    protected boolean[] chooseOnlyDirectories = {};
     */
    
    //------------------------------------------------------------------------
    //org.apache.catalina.logger.FileLogger
    protected String[] allAttr1 = {"className", "verbosity", "directory", "prefix", "suffix", "timestamp"};                         // holds all the attributes
    protected boolean[] requiredAttr1 = {true, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue1 = {"org.apache.catalina.logger.FileLogger", "", "", "", "", ""};                    // attributes values
    protected boolean[] hasComboBoxValues1 = {false, false, false, false, false, false};
    protected String[][] comboBoxValues1 = {null, null, null, null, null, null};
    protected boolean[] useFileChooser1 = {false, false, true, false, false, false};
    protected boolean[] chooseOnlyDirectories1 = {false, false, true, false, false, false};
    protected String originalTextValue1 = "";
    protected String defaultTextValue1 = "";
    protected boolean hasTextElement1 = false;
    
    //org.apache.catalina.logger.SystemErrLogger
    protected String[] allAttr2 = {"className", "verbosity"};                         // holds all the attributes
    protected boolean[] requiredAttr2 = {true, false};                    // required attributes
    protected String[] attrDefaultValue2 = {"org.apache.catalina.logger.SystemErrLogger", ""};                    // attributes values
    protected boolean[] hasComboBoxValues2 = {false, false};
    protected String[][] comboBoxValues2 = {null, null};
    protected boolean[] useFileChooser2 = {false, false};
    protected boolean[] chooseOnlyDirectories2 = {false, false};
    protected String originalTextValue2 = "";
    protected String defaultTextValue2 = "";
    protected boolean hasTextElement2 = false;
    
    //org.apache.catalina.logger.SystemOutLogger
    protected String[] allAttr3 = {"className", "verbosity"};                         // holds all the attributes
    protected boolean[] requiredAttr3 = {true, false};                    // required attributes
    protected String[] attrDefaultValue3 = {"org.apache.catalina.logger.SystemOutLogger", ""};                    // attributes values
    protected boolean[] hasComboBoxValues3 = {false, false};
    protected String[][] comboBoxValues3 = {null, null};
    protected boolean[] useFileChooser3 = {false, false};
    protected boolean[] chooseOnlyDirectories3 = {false, false};
    protected String originalTextValue3 = "";
    protected String defaultTextValue3 = "";
    protected boolean hasTextElement3 = false;
    
    //------------------------------------------------------------------------
    
    //------------------------------------------------------------------------
    //protected String originalTextValue = "";
    //protected JTextField textValueField;
    //protected Node originalTextNode;    
    //protected String defaultTextValue = "";
    //protected boolean hasTextElement = true;        // this indicates that it has a TextElement
    protected int adjustedHeight = 0;       // note: we only use this to adjust the height if this is a text element
    //------------------------------------------------------------------------
    
    public LoggerElementWizardlet(String loggerName, Document doc)
    {
        super();
        
        
        /*
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasComboBoxValues = hasComboBoxValues;
        super.comboBoxValues = comboBoxValues;
        super.useFileChooser = useFileChooser;
        super.chooseOnlyDirectories = chooseOnlyDirectories;
        this.doc = doc;
         */
                
        //------------------------------------------------------------------------
        /*
        super.originalTextValue = originalTextValue;
        //super.textValueField = textValueField;
        //super.originalTextNode = originalTextNode;
        super.defaultTextValue = defaultTextValue;
        super.hasTextElement = hasTextElement;
        super.adjustedHeight = adjustedHeight;
         */
        
        //------------------------------------------------------------------------
        this.doc = doc;
        super.adjustedHeight = adjustedHeight;
        
        if(loggerName.equals("org.apache.catalina.logger.FileLogger"))
        {
            super.allAttr = allAttr1;
            super.requiredAttr = requiredAttr1;
            super.attrDefaultValue = attrDefaultValue1;
            super.hasComboBoxValues = hasComboBoxValues1;
            super.comboBoxValues = comboBoxValues1;
            super.useFileChooser = useFileChooser1;
            super.chooseOnlyDirectories = chooseOnlyDirectories1;
            super.originalTextValue = originalTextValue1;
            super.defaultTextValue = defaultTextValue1;
            super.hasTextElement = hasTextElement1;
        } // if(attrNodeValue.equals("org.apache.catalina.loggers.AccessLogLogger"))
        else if(loggerName.equals("org.apache.catalina.logger.SystemErrLogger"))
        {
            super.allAttr = allAttr2;
            super.requiredAttr = requiredAttr2;
            super.attrDefaultValue = attrDefaultValue2;
            super.hasComboBoxValues = hasComboBoxValues2;
            super.comboBoxValues = comboBoxValues2;
            super.useFileChooser = useFileChooser2;
            super.chooseOnlyDirectories = chooseOnlyDirectories2;
            super.originalTextValue = originalTextValue2;
            super.defaultTextValue = defaultTextValue2;
            super.hasTextElement = hasTextElement2;
        } // else if(attrNodeValue.equals("org.apache.catalina.loggers.RemoteAddrLogger"))
        else if(loggerName.equals("org.apache.catalina.logger.SystemOutLogger"))
        {
            super.allAttr = allAttr3;
            super.requiredAttr = requiredAttr3;
            super.attrDefaultValue = attrDefaultValue3;
            super.hasComboBoxValues = hasComboBoxValues3;
            super.comboBoxValues = comboBoxValues3;
            super.useFileChooser = useFileChooser3;
            super.chooseOnlyDirectories = chooseOnlyDirectories3;
            super.originalTextValue = originalTextValue3;
            super.defaultTextValue = defaultTextValue3;
            super.hasTextElement = hasTextElement3;
        } // else if(attrNodeValue.equals("org.apache.catalina.loggers.RemoteHostLogger"))        
        else
            ;       // do nothing
        
        doAllAttrProcessing();
    } // public LoggerElementWizardlet(Document)
    
    public Object createUserObject()
    {
        Node loggerElementNode = doc.createElement("Logger");
        NamedNodeMap namedNodeMap = loggerElementNode.getAttributes();
        
        //getPropertyValueForPropertyName(String propertyName)
        for(int i = 0; i < allAttr.length; i++)
        {
            String attrValue = getPropertyValueForPropertyName(allAttr[i]);
            
            if(!attrValue.equals(""))
            {
                Node attr = doc.createAttribute(allAttr[i]);
                attr.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(attr);
            } // if(!attrValue.equals(""))
        } // for(int i = 0; i < allAttr.length; i++)
        
        // create a text value
        if(hasTextElement)
            if(!super.textValueField.getText().equals(""))
                loggerElementNode.appendChild(doc.createTextNode(super.textValueField.getText()));
        
        userObject = loggerElementNode;
        return userObject;
    } // public Object createUserObject()
    
    public String getStepName()
    {
        return "Enter Logger Attributes";
    } // public String getStepName()
} // public class LoggerElementWizardlet extends Wizardlet