package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class LoggerElementNodeObject extends ElementNodeObject
{
    protected String nodeActionList_deleteLoggerAction = "Delete Logger";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, nodeActionList_deleteLoggerAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    //------------------------------------------------------------------------
    //org.apache.catalina.logger.FileLogger
    protected String[] allAttr1 = {"className", "verbosity", "directory", "prefix", "suffix", "timestamp"};                         // holds all the attributes
    protected boolean[] requiredAttr1 = {true, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue1 = {"", "", "", "", "", ""};                    // attributes values
    protected boolean hasTextElement1 = false;
    
    //org.apache.catalina.logger.SystemErrLogger
    protected String[] allAttr2 = {"className", "verbosity"};                         // holds all the attributes
    protected boolean[] requiredAttr2 = {true, false};                    // required attributes
    protected String[] attrDefaultValue2 = {"", ""};                    // attributes values
    protected boolean hasTextElement2 = false;
    
    //org.apache.catalina.logger.SystemOutLogger
    protected String[] allAttr3 = {"className", "verbosity"};                         // holds all the attributes
    protected boolean[] requiredAttr3 = {true, false};                    // required attributes
    protected String[] attrDefaultValue3 = {"", ""};                    // attributes values
    protected boolean hasTextElement3 = false;    
    //------------------------------------------------------------------------
        
    public LoggerElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        Node loggerElementNode = (Node) userObject;
        NamedNodeMap namedNodeMap = loggerElementNode.getAttributes();
        
        String nameAttrValue = "";
        Node attrNode = namedNodeMap.getNamedItem("className");
        String attrNodeValue = attrNode.getNodeValue();
        
        if(attrNodeValue.equals("org.apache.catalina.logger.FileLogger"))
        {
            super.allAttr = allAttr1;
            super.requiredAttr = requiredAttr1;
            super.attrDefaultValue = attrDefaultValue1;
            super.hasTextElement = hasTextElement1;
        } // if(attrNodeValue.equals("org.apache.catalina.loggers.AccessLogLogger"))
        else if(attrNodeValue.equals("org.apache.catalina.logger.SystemErrLogger"))
        {
            super.allAttr = allAttr2;
            super.requiredAttr = requiredAttr2;
            super.attrDefaultValue = attrDefaultValue2;
            super.hasTextElement = hasTextElement2;
        } // else if(attrNodeValue.equals("org.apache.catalina.logger.SystemErrLogger"))
        else if(attrNodeValue.equals("org.apache.catalina.logger.SystemOutLogger"))
        {
            super.allAttr = allAttr3;
            super.requiredAttr = requiredAttr3;
            super.attrDefaultValue = attrDefaultValue3;
            super.hasTextElement = hasTextElement3;
        } // else if(attrNodeValue.equals("org.apache.catalina.logger.SystemOutLogger"))
        else
            ;       // do nothing
        
    } // public LoggerElementNodeObject()
    
    public LoggerElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public LoggerElementNodeObject()
    
    public LoggerElementNodeObject()
    {
        this(null, null);
    } // public LoggerElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_deleteLoggerAction))
        {
            String message = "Delete Logger Element?";
             
            performDeleteElementAction(message, parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Host");
        } // if(actionName.equals(nodeActionList_addHostAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
} // public class LoggerElementNodeObject extends ElementNodeObject