package jp.turbosql.modules.at.app.tomcat4;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------

import jp.turbosql.modules.at.app.*;
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class ContextElementNodeObject extends ElementNodeObject
{
    //protected Node contextElementNode;
    
    protected String nodeActionList_AddValveAction = "Add Valve", nodeActionList_AddLoggerAction = "Add Logger", nodeActionList_deleteContextAction = "Delete Context";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction, "JSeparator", nodeActionList_AddValveAction, nodeActionList_AddLoggerAction, nodeActionList_deleteContextAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    
    protected String[] allAttr = {"className", "cookies", "crossContext", "docBase", "override", "path", "privileged", "reloadable", "useNaming", "wrapperClass", "debug", "workDir"};                         // holds all the attributes
    protected boolean[] requiredAttr = {false, false, false, true, false, true, false, false, false, false, false, false};                    // required attributes
    protected String[] attrDefaultValue = {"", "", "", "", "", "", "", "", "", "", "", ""};                    // attributes values
    
    protected boolean hasTextElement = false;
    
    public ContextElementNodeObject(String objectName, Object userObject)
    {
        super(objectName, userObject);
                
        super.nodeActionList = nodeActionList;
        super.multipleNodeActionList = multipleNodeActionList;
        
        super.allAttr = allAttr;
        super.requiredAttr = requiredAttr;
        super.attrDefaultValue = attrDefaultValue;
        super.hasTextElement = hasTextElement;
        //this.contextElementNode = (Node) userObject;
    } // public ContextElementNodeObject()
    
    public ContextElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null);
    } // public ContextElementNodeObject()
    
    public ContextElementNodeObject()
    {
        this(null, null);
    } // public ContextElementNodeObject()
    
    // Only Handle the one we want to
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_deleteContextAction))
        {
            String message = "Delete Context Element?";
             
            performDeleteElementAction(message, parentComponent, actionName, jTree, refreshListener);
            //System.out.println("add Context");
        } // if(actionName.equals(nodeActionList_addContextAction))
        /*
        else if(actionName.equals(nodeActionList_AddAliasAction))
        {
            performAddAliasAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_deleteContextAction))
         */
        else if(actionName.equals(nodeActionList_AddValveAction))
        {
            performAddValveAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_AddValveAction))
        else if(actionName.equals(nodeActionList_AddLoggerAction))
        {
            performAddLoggerAction(parentComponent, actionName, jTree, refreshListener);
        } // else if(actionName.equals(nodeActionList_AddLoggerAction))
        else if(actionName.equals(nodeActionList_addAttributesAction) || actionName.equals(nodeActionList_removeAttributesAction) || actionName.equals(nodeActionList_viewAttributesAction)) // we delegate to the ihe parent class
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
        else
            super.performSingleNodeAction(parentComponent, actionName, jTree, refreshListener);
    } // public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddAliasAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        AliasElementWizardlet aliasElementWizardlet = new AliasElementWizardlet(doc);
        Wizardlet[] wizardlets = {aliasElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node aliasElementNode = (Node) aliasElementWizardlet.createUserObject();
            
            nodeObject.appendChild(aliasElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddAliasAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        ValveElementWizardlet valveElementWizardlet = new ValveElementWizardlet("org.apache.catalina.valves.AccessLogValve", doc);
        Wizardlet[] wizardlets = {valveElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node valveElementNode = (Node) valveElementWizardlet.createUserObject();
            
            nodeObject.appendChild(valveElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddValveAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        LoggerElementWizardlet loggerElementWizardlet = new LoggerElementWizardlet("org.apache.catalina.logger.FileLogger", doc);
        Wizardlet[] wizardlets = {loggerElementWizardlet};
        WizardControllerPane wizardControllerPane = new WizardControllerPane(wizardlets);
        JDialog dialog = wizardControllerPane.createDialog(parentComponent, "Wizard");
        //System.out.println(wizardControllerPane.getNormalFinish());
        dialog.show();
        
        //System.out.println(wizardControllerPane.getNormalFinish());
        if(wizardControllerPane.getNormalFinish())
        {                      
            Node LoggerElementNode = (Node) loggerElementWizardlet.createUserObject();
            
            nodeObject.appendChild(LoggerElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(wizardControllerPane.getNormalFinish())
    } // protected void performAddLoggerAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    /*
    protected void performDeleteContextAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        String message = "Delete Context Element?";
        
        if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        {
            Node parentNode = contextElementNode.getParentNode();
            parentNode.removeChild(contextElementNode);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        
    } // protected void performDeleteContextAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
     */
    
    public Wizardlet getWizardlet()
    {
        return null;
    } // public Wizardlet getWizardlet()
       
} // public class ContextElementNodeObject extends ElementNodeObject