package jp.turbosql.modules.at.app.dialogs;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.accessibility.*;

import jp.turbosql.modules.at.app.*;

public class AttributeAddPane extends JComponent implements Accessible
{
    JDialog dialog;
    String attrName = "";
    String attrValue = "";
    JPanel tabbedPanel1;
    JPanel contentPanel;
    JPanel buttonPanel;
    JLabel attrNameLabel;
    JTextField attrNameField;
    JLabel attrValueLabel;
    JTextField attrValueField;
    JButton okButton;
    JButton cancelButton;
    
    ActionListener refreshListener;
    
    ElementNodeObject elementNodeObject;
    
    // Note this not Generic, it only works with ElementNodeObjects.
    public AttributeAddPane(ElementNodeObject elementNodeObject, ActionListener refreshListener)
    {
        this.elementNodeObject = elementNodeObject;
        this.refreshListener = refreshListener;
    } // public DatabaseAddPane()
        
    public JDialog createDialog(Component parentComponent, String title)
    {
        dialog = new JDialog((JFrame)parentComponent, true);
        Container contentPane;
        tabbedPanel1 = new JPanel();
                
        //okButton = new JButton("Ok");
        JTabbedPane tabbedPane = new JTabbedPane();
        
        okButton = new JButton(new AbstractAction("Ok"){
            public void actionPerformed(ActionEvent e)
            {
                String errorMSG = elementNodeObject.createAttr(attrNameField.getText(), attrValueField.getText());
                
                if(errorMSG == null)
                    return;
                if(!errorMSG.equals(""))
                {
                    JOptionPane.showMessageDialog(dialog, "Error: " + errorMSG);
                } // if(!errorMSG.equals(""))
                else                            // we finish it if there is no errorMSG
                {
                    if(refreshListener != null)
                            refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
                    dialog.dispose();
                } // else
            } // public void actionPerformed(ActionEvent e)
        });
        
        cancelButton = new JButton(new AbstractAction("Cancel"){
            public void actionPerformed(ActionEvent e)
            {
                dialog.dispose();
            } // public void actionPerformed(ActionEvent e)
        });
        
        dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
        
        buttonPanel = new JPanel();
        contentPanel = new JPanel(new GridLayout(2, 2));
                
        attrNameLabel = new JLabel("Attribute Name: ");
        attrNameField = new JTextField();
                
        attrValueLabel = new JLabel("Attribute Value: ");
        attrValueField = new JTextField();
        
        contentPanel.add(attrNameLabel);
        contentPanel.add(attrNameField);
        contentPanel.add(attrValueLabel);
        contentPanel.add(attrValueField);
        
        
        
        tabbedPane.setBounds(0, 0, 100, 100);
        contentPanel.setPreferredSize(new Dimension(100, 100));
        
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        
        contentPane = dialog.getContentPane();
        
        tabbedPanel1.setLayout(new BorderLayout());
        
        tabbedPanel1.add(contentPanel, BorderLayout.CENTER);
        tabbedPanel1.add(buttonPanel, BorderLayout.SOUTH);
                
        tabbedPane.addTab("Add Attribute", null, tabbedPanel1, "Add Attribute");
        tabbedPane.setSelectedIndex(0);
        
        contentPane.add(tabbedPane);
        
        dialog.setBounds(0, 0, 300, 140);
        
        return dialog;
    } // public JDialog createDialog(Component parentComponent, String title)
    
    public static void main(String args[])
    {
        JFrame jFrame = new JFrame("test");
        jFrame.setBounds(0, 0, 100, 100);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        AttributeAddPane pane = new AttributeAddPane(null, null);
        JDialog jDialog = pane.createDialog(jFrame, "test dialog");
        //dialog.setVisible(true);
        jDialog.show();
    } // public static void main(String args[])
} // public class AttributeAddPane extends JComponent implements Accessible


