package jp.turbosql.modules.at.app;

import javax.swing.JInternalFrame;
import javax.swing.JDesktopPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JMenuBar;
import javax.swing.JFrame;
import javax.swing.UIManager;

import javax.swing.*;

import java.awt.event.*;
import java.awt.*;

import jp.turbosql.swing.plaf.tsql.TSQLLookAndFeel;

public class MainFrame extends JFrame {
        
    JDesktopPane desktop;
    MainInternalFrame internalFrame;

    public MainFrame() {
        super("turbosql");
        try
        {
            UIManager.setLookAndFeel(new TSQLLookAndFeel());
        } // try
        catch(Exception e)
        {
            System.out.println(e.getMessage());
        } // catch(ClassNotFoundException cnfe)
        //Make the big window be indented 50 pixels from each edge 
        //of the screen.
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        //setBounds(inset, inset, 
        //          screenSize.width - inset*2, 
        //          screenSize.height-inset*2);
        setBounds(0, 0, 
                  screenSize.width, 
                  screenSize.height- 40);

        //Quit this app when the big window closes.
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                exitApplication();
            }
        });

        //Set up the GUI.
        desktop = new JDesktopPane(); //a specialized layered pane
        createFrame(); //Create first window
        setContentPane(desktop);
        setJMenuBar(createMenuBar());

        //Make dragging faster:
        desktop.putClientProperty("JDesktopPane.dragMode", "outline");
    }

    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();

        /*
        JMenu menu = new JMenu("Document");
        menu.setMnemonic(KeyEvent.VK_D);
        JMenuItem menuItem = new JMenuItem("New");
        menuItem.setMnemonic(KeyEvent.VK_N);
        menuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                createFrame();
            }
        });
        menu.add(menuItem);
        menuBar.add(menu);
         */
        // creating the file menu
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(KeyEvent.VK_F);
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        exitMenuItem.setMnemonic(KeyEvent.VK_X);

        exitMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                exitApplication();
            }
        });
        fileMenu.add(exitMenuItem);
        
        // creating the view menu
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic(KeyEvent.VK_V);
        JMenuItem viewMainInternalFrameMenuItem = new JMenuItem("Show window");
        //viewMainInternalFrameMenuItem.setMnemonic(KeyEvent.VK_X);

        viewMainInternalFrameMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                viewMainInternalFrame();
            }
        });
        viewMenu.add(viewMainInternalFrameMenuItem);
        
        menuBar.add(fileMenu);
        menuBar.add(viewMenu);
        
        return menuBar;
    }
    
    protected void createFrame() {
        //MainInternalFrame frame = new MainInternalFrame();
        internalFrame = new MainInternalFrame();
	internalFrame.setVisible(true); //necessary as of kestrel
        desktop.add(internalFrame);
        try {
            internalFrame.setSelected(true);
        } catch (java.beans.PropertyVetoException e) {}
    }
    
    protected void viewMainInternalFrame() {
        internalFrame.setVisible(true); //necessary as of kestrel
        // to make the same frame reappear
        desktop.remove(internalFrame);
        desktop.add(internalFrame);
        try {
            internalFrame.setSelected(true);
        } catch (java.beans.PropertyVetoException e) {}
    }
           
    protected int exitApplication()
    {
        if(internalFrame.exitApplication() == 0)
            System.exit(0);        
        return 0;
    } // protected intexitApplication()

    public static void main(String[] args) {
        //Canvas canvas = new Canvas
        //Image image = new Image
        //--------------------------------------------------------------------
        // making a splash screen
        //MainFrame frame = new MainFrame();          // make the application before the splash screen
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JWindow window = new JWindow();
        JPanel panel = new JPanel(new GridLayout(3, 1));
        JPanel panel1 = new JPanel();
        panel1.setBackground(new Color(255, 153, 102));
        JLabel label1 = new JLabel("turbosql AT");
        label1.setFont(new Font("Plain", 0, 40));
        panel1.add(label1);
        
        JPanel panel2 = new JPanel();
        panel2.setBackground(new Color(255, 153, 102));
        JLabel label2 = new JLabel("Loading...");
        panel2.add(label2);
        
        JPanel panel3 = new JPanel();
        panel3.setBackground(new Color(255, 153, 102));
        
        panel.add(panel1);
        panel.add(panel2);
        panel.add(panel3);
        //Graphics g = panel.getGraphics();
        //g.setFont(new Font("Plain", 0, 40));
        //panel.add(new JButton("Test"));
        //Container container = new Container();
        //container.setBackground(new Color(255, 102, 51));
        //window.getContentPane().setBackground(new Color(255, 102, 51));
        window.getContentPane().add(panel);
        //window.add(panel);
        //window.setContentPane(container);
        //window.setRootPane(panel);
        window.setBounds((screenSize.width/2 - 200), (screenSize.height/2 - 100), 400, 200);
        window.setVisible(true);
        window.show();
          
        MainFrame frame = new MainFrame();          // load the frame during the splash screen sequence
        ClassLoader urlClassLoader = frame.getClass().getClassLoader();
        frame.setIconImage(new ImageIcon(urlClassLoader.getResource("jp/turbosql/modules/at/app/images/development/Server16.gif")).getImage());
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);     // handled by our own methods
        
        //for(int i = 0; i < 600000000; i++);        // create a delay
        label2.setText("Openning Main Window...");
        //for(int i = 0; i < 400000000; i++);        // create a delay
        window.dispose();
        //--------------------------------------------------------------------
        frame.setVisible(true);
    }
}
