package jp.turbosql.modules.at.app;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
//-----------------------------------
// xml libraries
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.apache.xerces.dom.*;
import org.apache.xml.serialize.*;
import org.apache.xerces.parsers.*;
import org.w3c.dom.traversal.*;
import org.xml.sax.*;
//-----------------------------------
import jp.turbosql.modules.at.app.dialogs.*;
import jp.turbosql.modules.at.app.wizards.*;

public class ElementNodeObject extends AbstractNodeObject
{
    protected String nodeActionList_addAttributesAction = "Add Attributes", nodeActionList_viewAttributesAction = "Edit Attributes", nodeActionList_removeAttributesAction = "Remove Attributes";
    protected String[] nodeActionList = {nodeActionList_addAttributesAction, nodeActionList_removeAttributesAction, nodeActionList_viewAttributesAction};
    protected String multipleNodeActionList_viewAttributesAction = "Do nothing";
    protected String[] multipleNodeActionList = {multipleNodeActionList_viewAttributesAction};
    protected Node nodeObject;
    
    // left to be null here, should be initialized by the child nodes
    protected String[] allAttr;                         // holds all the attributes
    protected boolean[] requiredAttr;                    // required attributes
    protected String[] attrDefaultValue;                    // attributes values
          
    protected static final String htmlOrange = "\"ff3300\"", htmlRed = "\"ff0000\"", htmlGreen = "\"00ff00\"", htmlBlue = "\"0000ff\"", htmlYellow = "\"00ffff\"", htmlGray = "\"808080\"";
    protected Document doc;
    protected boolean hasTextElement = false;
        
    public ElementNodeObject(String objectName, Object userObject, boolean hasTextElement)
    {
        this.objectName = objectName;
        this.userObject = userObject;
        this.nodeObject = (Node) userObject;
        this.hasTextElement = hasTextElement;
        doc = getDocumentFromNodeObject();
        //this.allAttr = allAttr;
        //this.requiredAttr = requiredAttr;
        //this.attrDefaultValue = attrDefaultValue;
    } // public ElementNodeObject()
    
    public ElementNodeObject(String objectName, Object userObject)
    {
        this(objectName, userObject, false);
    } // public ElementNodeObject(String objectName, Object userObject)
    
    public ElementNodeObject(String objectName)     // overloaded constructor
    {
        this(objectName, null, false);
    } // public ElementNodeObject()
    
    public ElementNodeObject()
    {
        this(null);
    } // public ElementNodeObject()
    
    public String[] getNodeActionList()
    {
        return nodeActionList;
    } // public String[] getNodeActionList()
    
    public String[] getMultipleNodeActionList()
    {
        return multipleNodeActionList;
    } // public String[] getNodeActionList()
    
    public void setAllAttr(String[] allAttr)
    {
        this.allAttr = allAttr;
        //System.out.println("allAttr is:" + allAttr);
        //System.out.println("this.allAttr is:" + this.allAttr);
    } // public void setAllAttr(String[] allAttr)
    
    public String[] getAllAttr()
    {
        return allAttr;
    } // public String[] getAllAttr()
    
    public void setRequiredAttr(boolean[] requiredAttr)
    {
        this.requiredAttr = requiredAttr;
    } // public void setRequiredAttr(boolean[] requiredAttr)
    
    public boolean[] getRequiredAttr()
    {
        return requiredAttr;
    } // public boolean[] setRequiredAttr()
    
    /*
    public void testing(String testStr)
    {
        //System.out.println("testStr is:" + testStr);
        //System.out.println("allAttr is:" + allAttr);
        this.test = testStr;
    } // public void testing(String testStr)
     */
    
    public void setAttrDefaultValue(String[] attrDefaultValue)
    {
        this.attrDefaultValue = attrDefaultValue;
    } // public void setAttrDefaultValue(String[] attrDefaultValue)
    
    public String[] getAttrDefaultValue()
    {
        return attrDefaultValue;
    } // public String[] getAttrDefaultValue()
    
    public void performSingleNodeAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(actionName.equals(nodeActionList_viewAttributesAction))
        {
            GenericPropertyPane propertyPane = new GenericPropertyPane(nodeObject, getDocumentFromNodeObject(), hasTextElement, refreshListener, "Attributes", getTextNode());
                                    
            NamedNodeMap namedNodeMap = nodeObject.getAttributes();
            //System.out.println("Type " + type + ": " + name 
            //+ " \"" + value + "\"");
            //System.out.println("allAttr1 is " + allAttr);
            //System.out.println("requiredAttr is " + requiredAttr);
            //System.out.println("attrDefaultValue is " + attrDefaultValue);
            //System.out.println("test is: " + test);
            //testing(null);
            if(allAttr == null)     // if there are no defautl attributes to begin with
            {
                //System.out.println("allAttr is null");
                if(namedNodeMap != null)
                {
                    for(int i = 0; i < namedNodeMap.getLength(); i++)
                    {
                        /*  refactored, we should treat the Genric Property as a separate type
                        if(allAttr == null)     // if there are no defautl attributes to begin with
                            propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());      // treat all of them as generic properties
                        else if(allAttr.length == 0)       // if there are no defautl attributes to begin with
                            propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());      // treat all of them as defaults properties
                        else        // we have a list know attributes
                        {
                            if(!isKnownAttr(namedNodeMap.item(j).getNodeName()))
                                propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());      // we don't know what attribute this is
                        } // else
                        */
                                        
                        propertyPane.add(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue());      // treat all of them as generic properties
                        //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                    } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
                } // if(namedNodeMap != null)
            } // if(allAttr == null)
            else    // we will have to determine the type of attribute here
            {
                if(namedNodeMap != null)
                {
                    int foundAttrCount = 0;
                    
                    for(int i = 0; i < allAttr.length; i++)
                    {
                        if(requiredAttr[i])
                        {
                            Node tempNode = namedNodeMap.getNamedItem(allAttr[i]);
                            String attrValue;
                            
                            if(tempNode == null)
                            {
                                attrValue = "";
                            } // if(tempNode == null)
                            else
                            {
                                attrValue = tempNode.getNodeValue();
                                foundAttrCount++;
                            } // else
                            
                            propertyPane.add(allAttr[i], attrValue, GenericPropertyPane.REQUIRED_PROPERTY);
                            //System.out.println("Required property");
                        } // if(requiredAttr[i])
                        else
                        {
                            Node tempNode = namedNodeMap.getNamedItem(allAttr[i]);
                            String attrValue;
                            
                            if(tempNode == null)
                            {
                                attrValue = "";
                            } // if(tempNode == null)
                            else
                            {
                                attrValue = tempNode.getNodeValue();
                                foundAttrCount++;
                            } // else
                                                
                            propertyPane.add(allAttr[i], attrValue, GenericPropertyPane.NORMAL_PROPERTY);
                            //System.out.println("Normal property");
                        } // else                        
                        
                    } // for(int i = 0; i < allAttr.length; i++)
                    
                    // we can skip this step if all the nodes in the attributes in the namedNodeMap are already added
                    if(foundAttrCount != namedNodeMap.getLength())
                    {
                        for(int i = 0; i < namedNodeMap.getLength(); i++)
                        {
                            if(!isKnownAttr(namedNodeMap.item(i).getNodeName()))
                                propertyPane.add(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue(), GenericPropertyPane.UNKNOWN_PROPERTY);
                        } // for(int i = 0; i < namedNodeMap.getLength(); i++)
                    } // if(foundAttrCount != namedNodeMap.getLength())
                    
                } // if(namedNodeMap != null)
                else        // if namedNode map is null, we only need to add the properties of allAttr
                {
                    for(int i = 0; i < allAttr.length; i++)
                    {
                        if(requiredAttr[i])
                            propertyPane.add(allAttr[i], attrDefaultValue[i], GenericPropertyPane.REQUIRED_PROPERTY);
                        else
                            propertyPane.add(allAttr[i], attrDefaultValue[i], GenericPropertyPane.NORMAL_PROPERTY);
                    } // for(int i = 0; i < allAttr.length; i++)
                } // else
            } // else
            
            if(hasTextElement)
                propertyPane.addTextValue(getNodeTextValue());
                            
            //propertyPane.add("className", "jp.turbosql.modules.at.app.dialogs");
            
            JDialog dialog = propertyPane.createDialog(parentComponent, "Attributes");
            dialog.show();
        } // if(actionName.equals(nodeActionList_viewAttributesAction))
        else if(actionName.equals(nodeActionList_addAttributesAction))
        {
            AttributeAddPane pane = new AttributeAddPane(this, refreshListener);
            JDialog dialog = pane.createDialog(parentComponent, "Add Attribute");
            dialog.show();
        } // else if(actionName.equals(nodeActionList_addAttributesAction))
        else if(actionName.equals(nodeActionList_removeAttributesAction))
        {
            AttributeRemovePane pane = new AttributeRemovePane(this, refreshListener);
            JDialog dialog = pane.createDialog(parentComponent, "Remove Attribute");
            dialog.show();
        } // else if(actionName.equals(nodeActionList_removeAttributesAction))
                
    } // public void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    
    public String getPropertyHTML()
    {
        String propertyStr = "<B>" + nodeObject.getNodeName() + " attributes</B><BR>";
        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
            
        if(allAttr == null)     // if there are no defautl attributes to begin with
        {
            if(namedNodeMap != null)
            {
                for(int i = 0; i < namedNodeMap.getLength(); i++)
                {
                    propertyStr = propertyStr + "<FONT color=" +  htmlOrange + ">" + namedNodeMap.item(i).getNodeName() + "</FONT>: " + namedNodeMap.item(i).getNodeValue() + "<BR>";
                    //propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());
                    //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
            } // if(namedNodeMap != null)
        } // if(allAttr == null)
        /*
        else
        {
            if(namedNodeMap != null)
            {
                for(int j = 0; j < namedNodeMap.getLength(); j++)
                {
                    int index = indexOfAttrName(namedNodeMap.item(j).getNodeName())
                    if(index != -1)
                    {
                        
                    } // if(isKnown(namedNodeMap.item(j).getNodeName()))
                    else
                        propertyStr = propertyStr + "<FONT color=" +  htmlGray + ">" + namedNodeMap.item(j).getNodeName() + "</FONT>: " + namedNodeMap.item(j).getNodeValue() + "<BR>";
                    //propertyPane.add(namedNodeMap.item(j).getNodeName(), namedNodeMap.item(j).getNodeValue());
                    //System.out.println("attributes: /Name: " + namedNodeMap.item(j).getNodeName() + " /Value: " + namedNodeMap.item(j).getNodeValue());
                } // for(int i = 0; i < namedNodeMap.getLenth(); i++)
            } // if(namedNodeMap != null)
        } // else
         */
        
        else    // we will have to determine the type of attribute here
        {
            if(namedNodeMap != null)
            {
                int foundAttrCount = 0;
                String foundPropertyStr = "";
                String unfoundPropertyStr = "";
                    
                for(int i = 0; i < allAttr.length; i++)
                {
                    if(requiredAttr[i])
                    {
                        Node tempNode = namedNodeMap.getNamedItem(allAttr[i]);
                        String attrValue;
                        boolean attrNotFound = false;
                            
                        if(tempNode == null)
                        {
                            attrValue = "";
                            attrNotFound = true;
                            if(unfoundPropertyStr.equals(""))       // first unfound property should be not have a leading comma
                                unfoundPropertyStr = unfoundPropertyStr + "<B><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></B>";
                            else
                                unfoundPropertyStr = unfoundPropertyStr + ", <B><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></B>";
                        } // if(tempNode == null)
                        else
                        {
                            attrValue = tempNode.getNodeValue();
                            foundAttrCount++;
                            foundPropertyStr = foundPropertyStr + "<B><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></B>: " + attrValue + "<BR>";
                        } // else
                            
                        //propertyPane.add(allAttr[i], attrValue, GenericPropertyPane.REQUIRED_PROPERTY);
                        
                        //System.out.println("Required property");
                    } // if(requiredAttr[i])
                    else
                    {
                        Node tempNode = namedNodeMap.getNamedItem(allAttr[i]);
                        String attrValue;
                            
                        if(tempNode == null)
                        {
                            attrValue = "";
                            if(unfoundPropertyStr.equals(""))       // first unfound property should be not have a leading comma
                                unfoundPropertyStr = unfoundPropertyStr + "<I><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></I>";
                            else
                                unfoundPropertyStr = unfoundPropertyStr + ", <I><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></I>";
                        } // if(tempNode == null)
                        else
                        {
                            attrValue = tempNode.getNodeValue();
                            foundAttrCount++;
                            foundPropertyStr = foundPropertyStr + "<I><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></I>: " + attrValue + "<BR>";
                        } // else
                                                
                        //propertyPane.add(allAttr[i], attrValue, GenericPropertyPane.NORMAL_PROPERTY);
                                                //System.out.println("Normal property");
                    } // else                        
                        
                } // for(int i = 0; i < allAttr.length; i++)
                    
                // we can skip this step if all the nodes in the attributes in the namedNodeMap are already added
                if(foundAttrCount != namedNodeMap.getLength())
                {
                    for(int i = 0; i < namedNodeMap.getLength(); i++)
                    {
                        if(!isKnownAttr(namedNodeMap.item(i).getNodeName()))
                            //propertyPane.add(namedNodeMap.item(i).getNodeName(), namedNodeMap.item(i).getNodeValue(), GenericPropertyPane.UNKNOWN_PROPERTY);
                            foundPropertyStr = foundPropertyStr + "<B><FONT color=" +  htmlGray + ">" + namedNodeMap.item(i).getNodeName() + "</FONT></B>: " + namedNodeMap.item(i).getNodeValue() + "<BR>";
                    } // for(int i = 0; i < namedNodeMap.getLength(); i++)
                } // if(foundAttrCount != namedNodeMap.getLength())
                                
                if(!foundPropertyStr.equals(""))
                    propertyStr = propertyStr + foundPropertyStr;
                if(!unfoundPropertyStr.equals(""))
                    propertyStr = propertyStr + "<BR><B>Unused attributes</B><BR>" + unfoundPropertyStr;
            } // if(namedNodeMap != null)
            else        // if namedNode map is null, we only need to add the properties of allAttr
            {
                for(int i = 0; i < allAttr.length; i++)
                {
                    if(requiredAttr[i])
                        //propertyPane.add(allAttr[i], attrDefaultValue[i], GenericPropertyPane.REQUIRED_PROPERTY);
                        propertyStr = propertyStr + "<B><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></B>: " + attrDefaultValue[i] + "<BR>";
                    else
                        //propertyPane.add(allAttr[i], attrDefaultValue[i], GenericPropertyPane.NORMAL_PROPERTY);
                        propertyStr = propertyStr + "<I><FONT color=" +  htmlOrange + ">" + allAttr[i] + "</FONT></I>: " + attrDefaultValue[i] + "<BR>";
                } // for(int i = 0; i < allAttr.length; i++)
            } // else
        } // else
        
        if(hasTextElement)
            propertyStr = propertyStr + "<FONT color=" + htmlRed + ">VALUE</FONT>: " + getNodeTextValue() + "<BR>";
        
        return propertyStr;
    } // public String getPropertyHTML()
    
    //------------------------------------------------------------------------
    // methods for allAttr
    // determine if it the attribute is known
    public boolean isKnownAttr(String attrName)
    {
        for(int i = 0; i < allAttr.length; i++)
            if(allAttr[i].equals(attrName))
                return true;
        return false;
    } // public boolean isKnownAttr(String attrName)
    
    public int indexOfAttrName(String attrName)
    {
        for(int i = 0; i < allAttr.length; i++)
            if(allAttr[i].equals(attrName))
                return i;
        return -1;
    } // public int indexOfAttrName(String attrName)
    //------------------------------------------------------------------------
    
    public Document getDocumentFromNodeObject()
    {
        return (Document) getTopNode(nodeObject);
    } // public Document getDocumentFromNode()
    
    public Node getTopNode(Node node)
    {
        if(node.getParentNode() != null)
            return getTopNode(node.getParentNode());
        else
            return node;        
    } // public Node getParent(Node node)
    
    public String createAttr(String attrName, String attrValue)
    {
        String errorMSG = "";
        Node tempNode;
        Document doc  = getDocumentFromNodeObject();
        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
                
        tempNode = namedNodeMap.getNamedItem(attrName);
        
        if(tempNode == null)        // we add the new attribute
        {
            Node tempNode2;
            try
            {
                tempNode2 = doc.createAttribute(attrName);
                tempNode2.setNodeValue(attrValue);
                namedNodeMap.setNamedItem(tempNode2);
            } // try
            catch(DOMException DOMe)
            {
                errorMSG = DOMe.getMessage();
            } // catch(DOMException DOMe)
                        
        } // if(tempNode == null)
        else        // we raise an error
        {
            errorMSG = "Attribute already exists.";
        } // else
        
        return errorMSG;
    } // public String createAttr(String attrName, String attrValue)
    
    public String removeAttr(String attrName)
    {
        String errorMSG = "";
        Node tempNode;
        Document doc  = getDocumentFromNodeObject();
        NamedNodeMap namedNodeMap = nodeObject.getAttributes();
        
        try
        {
            namedNodeMap.removeNamedItem(attrName);
        }
        catch(DOMException DOMe)
        {
            errorMSG = DOMe.getMessage();
        } // catch(DOMException DOMe)
        
        return errorMSG;
    } // public String removeAttr(String attrName)
    
    public String getNodeTextValue()
    {
        NodeList childNodeList = nodeObject.getChildNodes();
        
        if(childNodeList.getLength() != 0)
        {
            for(int i = 0; i < childNodeList.getLength(); i++)
            {
                Node childNode = childNodeList.item(i);
                if(childNode.getNodeType() == Node.TEXT_NODE)
                    return childNode.getNodeValue();
            } // for(int i = 0; i < childNodeList.getLength(); i++)
        } // if(childNodeList.getLength != 0)
        
        return "";  // if we cannot find any Text nodes
    } // public String getNodeTextValue()
    
    public Node getTextNode()
    {
        NodeList childNodeList = nodeObject.getChildNodes();
        
        if(childNodeList.getLength() != 0)
        {
            for(int i = 0; i < childNodeList.getLength(); i++)
            {
                Node childNode = childNodeList.item(i);
                if(childNode.getNodeType() == Node.TEXT_NODE)
                    return childNode;
            } // for(int i = 0; i < childNodeList.getLength(); i++)
        } // if(childNodeList.getLength != 0)
        
        return null;  // if we cannot find any Text nodes
    } // public String getNodeTextValue()
    
    protected void performDeleteElementAction(String message, Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    {
        if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        {
            Node parentNode = nodeObject.getParentNode();
            parentNode.removeChild(nodeObject);
            
            if(refreshListener != null)
                refreshListener.actionPerformed(new ActionEvent(this, ActionEvent.ACTION_PERFORMED, "data modified"));
        } // if(JOptionPane.showConfirmDialog(parentComponent, message, "msg", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
        
    } // protected void performDeleteElementAction(Component parentComponent, String actionName, JTree jTree, ActionListener refreshListener)
    
    public Wizardlet getWizardlet()
    {
        return null;
    } // public Wizardlet getWizardlet()
    
} // public class ElementNodeObject