package module1;

import org.openide.loaders.*;
import org.openide.nodes.*;
import org.openide.util.NbBundle;

/** A node to represent this object.
 *
 * @author  root
 */
public class MyDataNode extends DataNode {
    
    public MyDataNode(MyDataObject obj) {
        this(obj, Children.LEAF);
    }
    
    public MyDataNode(MyDataObject obj, Children ch) {
        super(obj, ch);
        setIconBase("/module1/MyDataIcon");
    }
    
    protected MyDataObject getMyDataObject() {
        return (MyDataObject) getDataObject();
    }
    
    /* Example of adding Executor / Debugger / Arguments to node:
    protected Sheet createSheet () {
        Sheet sheet = super.createSheet ();
        Sheet.Set set = sheet.get (ExecSupport.PROP_EXECUTION);
        if (set == null) {
            set = new Sheet.Set ();
            set.setName (ExecSupport.PROP_EXECUTION);
            set.setDisplayName (NbBundle.getMessage (MyDataNode.class, "LBL_DataNode_exec_sheet"));
            set.setShortDescription (NbBundle.getMessage (MyDataNode.class, "HINT_DataNode_exec_sheet"));
        }
        ((ExecSupport) getCookie (ExecSupport.class)).addProperties (set);
        // Maybe:
        ((CompilerSupport) getCookie (CompilerSupport.class)).addProperties (set);
        sheet.put (set);
        return sheet;
    }
     */
    
    /*
    public SystemAction getDefaultAction () {
        return SystemAction.get (MyFavoriteAction.class);
    }
     */
    
}
