package module1;

import java.io.IOException;

import org.openide.actions.*;
import org.openide.filesystems.*;
import org.openide.loaders.*;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/** Recognizes single files in the Repository as being of a certain type.
 *
 * @author root
 */
public class MyDataLoader extends UniFileLoader {
    
    public MyDataLoader() {
        this("module1.MyDataObject");
    }
    
    // Can be useful for subclasses:
    protected MyDataLoader(String recognizedObjectClass) {
        super(recognizedObjectClass);
    }
    
    protected String defaultDisplayName() {
        return NbBundle.getMessage(MyDataLoader.class, "LBL_loaderName");
    }
    
    protected void initialize() {
        
        super.initialize();
        
        ExtensionList extensions = new ExtensionList();
        extensions.addExtension("*.jsp");
        extensions.addExtension("*.java");
        setExtensions(extensions);
        
    }
    
    protected SystemAction[] defaultActions() {
        return new SystemAction[] {
            SystemAction.get(OpenAction.class),
            // SystemAction.get (CustomizeBeanAction.class),
            SystemAction.get(FileSystemAction.class),
            null,
            /*
            SystemAction.get (CompileAction.class),
            null,
            SystemAction.get (BuildAction.class),
            null,
            SystemAction.get (ExecuteAction.class),
            null,
             */
            SystemAction.get(CutAction.class),
            SystemAction.get(CopyAction.class),
            SystemAction.get(PasteAction.class),
            null,
            SystemAction.get(DeleteAction.class),
            SystemAction.get(RenameAction.class),
            null,
            SystemAction.get(SaveAsTemplateAction.class),
            null,
            SystemAction.get(ToolsAction.class),
            SystemAction.get(PropertiesAction.class),
        };
    }
    
    protected MultiDataObject createMultiObject(FileObject primaryFile)
    throws DataObjectExistsException, IOException {
        return new MyDataObject(primaryFile, this);
    }
    
    // Additional user-configurable properties:
    /*
    public String getMyProp () {
        return (String) getProperty ("myProp");
    }
    public void setMyProp (String nue) {
        putProperty ("myProp", nue, true);
    }
    public void writeExternal (ObjectOutput out) throws IOException {
        super.writeExternal (out);
        out.writeUTF (getMyProp ());
    }
    public void readExternal (ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal (in);
        setMyProp (in.readUTF ());
    }
     */
    
}
