/*
 * GazoogleDataObject.java
 *
 * Created on 12 July 2001 1616 MDT
 */

package jp.turbosql.modules.sketcher.ide;

import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class GazoogleDataObject extends MultiDataObject
{

    /** Creates new GazoogleDataObject */
    public GazoogleDataObject(FileObject primaryFile, GazoogleDataObjectLoader loader) 
      throws DataObjectExistsException
    {
        super(primaryFile, loader);
        
        // blank out the cookie set for this data object:
        CookieSet cs = new CookieSet();
        cs.add(new GazoogleOpenSupport());
        cs.add(new GazoogleDuplicateSupport());
        cs.add(new GazoogleDeleteSupport());
        this.setCookieSet(cs);
    }
}

