package jp.turbosql.modules.sketcher.app;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class SketchFrame extends JFrame implements Constants
{
    private JMenuBar menuBar = new JMenuBar();
    
    private JMenuItem newItem, openItem, closeItem, saveItem, saveAsItem, printItem;
    
    private JRadioButtonMenuItem lineItem, rectangleItem, circleItem, curveItem, textItem;
    
    private JCheckBoxMenuItem redItem, yellowItem, greenItem, blueItem;
    
    private Color elementColor = DEFAULT_ELEMENT_COLOR;
    
    private int elementType = DEFAULT_ELEMENT_TYPE;
    
    public SketchFrame(String title)
    {
        setTitle(title);
        setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
                
        setJMenuBar(menuBar);
        
        JMenu fileMenu = new JMenu("File");
        JMenu elementMenu = new JMenu("Elements");
        fileMenu.setMnemonic('F');
        elementMenu.setMnemonic('E');
        
        newItem = fileMenu.add("New");
        openItem = fileMenu.add("Open");
        closeItem = fileMenu.add("Close");
        fileMenu.addSeparator();
        saveItem = fileMenu.add("Save");
        saveAsItem = fileMenu.add("Save As...");
        printItem = fileMenu.add("Print");
        
        newItem.setAccelerator(KeyStroke.getKeyStroke('N', Event.CTRL_MASK));
        openItem.setAccelerator(KeyStroke.getKeyStroke('O', Event.CTRL_MASK));
        saveItem.setAccelerator(KeyStroke.getKeyStroke('S', Event.CTRL_MASK));
        printItem.setAccelerator(KeyStroke.getKeyStroke('P', Event.CTRL_MASK));
        
        elementMenu.add(lineItem = new JRadioButtonMenuItem("Line", elementType==LINE));
        elementMenu.add(rectangleItem = new JRadioButtonMenuItem("Rectangle", elementType==RECTANGLE));
        elementMenu.add(circleItem = new JRadioButtonMenuItem("Circle", elementType==CIRCLE));
        elementMenu.add(curveItem = new JRadioButtonMenuItem("Curve", elementType==CURVE));
        ButtonGroup types = new ButtonGroup();
        types.add(lineItem);
        types.add(rectangleItem);
        types.add(circleItem);
        types.add(curveItem);
        
        lineItem.setAccelerator(KeyStroke.getKeyStroke('L', Event.CTRL_MASK));
        rectangleItem.setAccelerator(KeyStroke.getKeyStroke('E', Event.CTRL_MASK));
        circleItem.setAccelerator(KeyStroke.getKeyStroke('I', Event.CTRL_MASK));
        curveItem.setAccelerator(KeyStroke.getKeyStroke('V', Event.CTRL_MASK));
        
        lineItem.addActionListener(new TypeListener(LINE));
        rectangleItem.addActionListener(new TypeListener(RECTANGLE));
        circleItem.addActionListener(new TypeListener(CIRCLE));
        curveItem.addActionListener(new TypeListener(CURVE));
        
        elementMenu.addSeparator();
        
        JMenu colorMenu = new JMenu("Color");
        elementMenu.add(colorMenu);
        colorMenu.add(redItem = new JCheckBoxMenuItem("Red", elementColor.equals(Color.red)));
        colorMenu.add(yellowItem = new JCheckBoxMenuItem("Yellow", elementColor.equals(Color.yellow)));
        colorMenu.add(greenItem = new JCheckBoxMenuItem("Green", elementColor.equals(Color.green)));
        colorMenu.add(blueItem = new JCheckBoxMenuItem("Blue", elementColor.equals(Color.blue)));
        
        redItem.setAccelerator(KeyStroke.getKeyStroke('R', Event.CTRL_MASK));
        yellowItem.setAccelerator(KeyStroke.getKeyStroke('Y', Event.CTRL_MASK));
        greenItem.setAccelerator(KeyStroke.getKeyStroke('G', Event.CTRL_MASK));
        blueItem.setAccelerator(KeyStroke.getKeyStroke('B', Event.CTRL_MASK));
        
        redItem.addActionListener(new ColorListener(Color.red));
        yellowItem.addActionListener(new ColorListener(Color.yellow));
        greenItem.addActionListener(new ColorListener(Color.green));
        blueItem.addActionListener(new ColorListener(Color.blue));
        
        ButtonGroup colors = new ButtonGroup();
        colors.add(redItem);
        colors.add(yellowItem);
        colors.add(greenItem);
        colors.add(blueItem);
        
        menuBar.add(fileMenu);
        menuBar.add(elementMenu);
        //enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    }
    
    /*
    protected void processWindowEvent(WindowEvent e)
    {
        if (e.getID() == WindowEvent.WINDOW_CLOSING)
        {
            dispose();
            System.exit(0);
        } // if (e.getID() == WindowEvent.WINDOW_CLOSING)
        super.processWindowEvent(e);
    } // protected void processWindowEvent(WindowEvent e)
    */
    
    class TypeListener implements ActionListener
    {
        private int type;
        
        TypeListener(int type)
        {
            this.type = type;
        } // TypeListener(int type)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            elementType = type;
        }
        
    } // class TypeListener implements ActionListener
    
    class ColorListener implements ActionListener
    {
        private Color color;
        
        public ColorListener(Color color)
        {
            this.color = color;
        } // public ColorListener(Color color)
        
        public void actionPerformed(java.awt.event.ActionEvent actionEvent) {
            elementColor = color;
            
            /*
            redItem.setState(color.equals(Color.red));
            greenItem.setState(color.equals(Color.green));
            blueItem.setState(color.equals(Color.blue));
            yellowItem.setState(color.equals(Color.yellow));
             */
        }
        
    } // class ColorListener implements ActionListener
} // public class SketchFrame extends JFrame


