/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.wizarduidemo;


import java.awt.Dialog;
import java.awt.Panel;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeListener;

import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardDescriptor.ArrayIterator;

import org.openide.TopManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

/** Simple action. Opens up a new window and displays a message, after traversing the wizard */
public class WizardAction extends CallableSystemAction {
    // generated
    private static final long serialVersionUID = 6101321673293585672L;
    
    public String getName () {
        return NbBundle.getBundle (WizardAction.class).getString ("LBL_WizardAction");
    }
    
    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected String iconResource () {
        return "Wizard.gif";
    }
   
    public void performAction () {      
       FirstPanelClass myPanel1;
       SecondPanelClass myPanel2;
       myPanel1 = new FirstPanelClass();  
       myPanel2 = new SecondPanelClass();     
      //create an array of WizardDescriptor.Panel objects
       WizardDescriptor.Panel wdp[] = new WizardDescriptor.Panel[]{ 
                          myPanel1, 
                          myPanel2, 
                  } ;         
       WizardDescriptor wd = new WizardDescriptor(wdp);                       
       // wd.setTitle("NEW WIZARD TITLE");
       java.text. MessageFormat format = new java.text.MessageFormat("TEST WIZARD"); 
        wd.setTitleFormat(format);            
       Dialog dialog = TopManager.getDefault().createDialog(wd);      
       //dialog.setSize(640,480); 
       dialog.show();       
    //what to do when dialog was closed 
       if (wd.getValue () == WizardDescriptor.OK_OPTION) { 
        //ok button was pressed  .......        
           
        TopManager.getDefault ().notify
        (new NotifyDescriptor.Message
        (NbBundle.getBundle (WizardAction.class).getString ("MSG_really_perform"))); //         
        
        } else { 
        //cancel button was pressed 
            
        }        
        
    }
}

/*
Each wizard panel have to implement WizardDescriptor.Panel interface 
(see    http://www.netbeans.org/download/apis/org/openide/WizardDescriptor.Panel.html).

Two important methods:
WizardDescriptor.Panel.getComponent() should return Component which will
be displayed in the wizard.
WizardDescriptor.Panel.isValid() should return true to enable "Next"
wizard button.

WizardDescriptor tries to register listener on a WizardDescriptor.Panel
validation change events (WizardDescriptor.Panel.addChangeListener(),
WizardDescriptor.Panel.removeChangeListener()). If validation of your
panel changes then you have to notify WizardDescriptor with ChangeEvent.

*/ 