package org.netbeans.mymodules.projectlistener;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

import org.openide.src.*;
import org.openide.src.ElementProperties;
import org.openide.nodes.Node;

import org.openide.src.SourceException;
import org.openide.cookies.*;

import org.openide.loaders.*;
import org.openide.loaders.DataShadow.*;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.execution.NbClassPath;

import java.util.Enumeration;
import java.beans.*;
import java.io.IOException;

/** Action that can always be invoked and work procedurally.
 *
 * @author  oye
 */
public class ProjectListener extends NodeAction {  
    
    protected void performAction (Node[] activatedNodes) {
        org.openide.nodes.Node n = TopManager.getDefault ().getPlaces ().nodes ().projectDesktop ();
        DataObject dobj = (DataObject)n.getCookie (DataObject.class);        
        System.out.println("The Current Project is ..");     // 
        System.out.println(dobj.getName());  
        System.out.println("The Current Project Path is ..");     // 
        System.out.println( NbClassPath.toFile(dobj.getPrimaryFile() ) ) ;  
        //DataFolder dataf = dobj.getFolder();   // create a datafolder   
        
        System.out.println("The files in the current project are ");
        for (int j=0; j < dobj.getPrimaryFile().getChildren().length; j++) {
        System.out.println(dobj.getPrimaryFile().getChildren()[j]);  
        }    
                      
        FileObject fo = dobj.getPrimaryFile();                       
        Enumeration all = fo.getChildren(true);         
        while (all.hasMoreElements()) {                 //      run through the elements in the project folder
          Object o=all.nextElement();
          if (o instanceof FileObject) {
             FileObject fileobj=(FileObject) o;                
 /*#1.*/     if (fileobj.getExt().indexOf("shadow") == 0)    {
                System.out.println("Listening to these links within current project... ");                                
                System.out.println(fileobj.getName());                    
                // account for linked folders including source files
                 try {    
                    DataShadow dataShadow = (DataShadow) DataObject.find( fileobj ); //            
                    DataObject origdob = dataShadow.getOriginal();
                    
                    FileObject fobb = origdob.getPrimaryFile();            //  does it work even if there's just one file ?           
                    if (fobb.getExt().indexOf("java") == 0)    {                 
                       ClassEventCheck(fobb);
                    } else {                                                                               
                        Enumeration allinlink = fobb.getChildren(true);         
                        while (allinlink.hasMoreElements()) {                   //      run through the elements in the project folder
                            Object oo=allinlink.nextElement();
                            if (oo instanceof FileObject) {
                                FileObject fl=(FileObject) oo;                
                                if (fl.getExt().indexOf("java") == 0)    {                 
                                    ClassEventCheck(fl);
                                }
                            }
                        }                    
                    }     // end else branch
                 } catch (DataObjectNotFoundException doe) {
                    doe.fillInStackTrace();
                 }                                  
             }
 /*#2.*/     if (fileobj.getExt().indexOf("java") == 0)    {          // only valid for java source files, not folders
                System.out.println("Listening to these files within current project... "); 
                System.out.println(fileobj.getName());                    
               ClassEventCheck(fileobj);
             }
          }
        }               
    }   
            
       public void ClassEventCheck (FileObject fo)  {   
          try {    
            DataObject dataObject = DataObject.find ( fo ); //              
            SourceElement src = ((SourceCookie) dataObject.getCookie (SourceCookie.class)).getSource ();        

            final ClassElement clazz = src.getClasses () [0];  //
            MethodElement[] Methods = clazz.getMethods();
            clazz.addPropertyChangeListener (new PropertyChangeListener () {  // 
            
            public void propertyChange (PropertyChangeEvent ev) {                 
                if (ElementProperties.PROP_METHODS.equals (ev.getPropertyName())) {

                    MethodElement[] newMethods = clazz.getMethods();               
                    //System.out.println (newMethods.length);                                        
                      for (int i = 0; i < newMethods.length; i++)  {
                       System.out.println ("The methods and modified class are... ");    
                       System.out.println (newMethods [i].getName());
                        System.out.println (newMethods [i].getDeclaringClass().getName());
                       }                    
                }                
           /*    
           > The  ev.getNewValue () returns null, hence newMethods is null........            
            Any PropertyChangeEvent according to the Beans spec may leave the
            property name, new value, and/or old value null if it is too much work
            to compute it. In many cases specifying these things can be used to
            minimize the number of refreshes that listeners need to be perform. In
            this case holding onto the old methods is not practical for memory
            performance reasons. So that is perfectly within the rights of the code
            firing the event.             
           */                                                               
                else if (ElementProperties.PROP_FIELDS.equals (ev.getPropertyName())) { 
                     FieldElement[] newFields = clazz.getFields();  //                     
                      for (int i = 0; i < newFields.length; i++)  {
                       System.out.println ("The fields and modified class are...");    
                       System.out.println (newFields [i].getName());
                       System.out.println (newFields [i].getDeclaringClass().getName());
                       }                                                           
                }
                
                else if (ElementProperties.PROP_CLASSES.equals (ev.getPropertyName())) { 
                      ClassElement[] newInnerClasses = clazz.getClasses();  //                     
                      for (int i = 0; i < newInnerClasses.length; i++)  {
                       System.out.println ("The inner classes and mofdified class are...");    
                       System.out.println (newInnerClasses [i].getName());
                       System.out.println (newInnerClasses [i].getDeclaringClass().getName());
                       }                                 
                }                                
                
                else if (ElementProperties.PROP_INTERFACES.equals (ev.getPropertyName())) {
                      Identifier[] newInterfaces = clazz.getInterfaces();  //                     
                      for (int i = 0; i < newInterfaces.length; i++)  {
                       System.out.println ("The interfaces and modified class are...");    
                       System.out.println (newInterfaces [i].getName());
                       System.out.println (newInterfaces [i].getClass().getName());                       
                       }                                 
                }                                          
            }
            }); 
            } catch (IOException ioe) {
                ioe.printStackTrace();        
            } catch (Exception e) {
                e.printStackTrace();
            }      
        }         
                        
    public HelpCtx getHelpCtx () {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean enable (Node[] arr) {
        org.openide.nodes.Node n = TopManager.getDefault ().getPlaces ().nodes ().projectDesktop ();
        if (n.getCookie (DataObject.class) == null) {
            return false;
        };        
        if ((arr == null) || (arr.length == 0)) return false;
        return true;
    }
    
    public String getName() {
        return org.openide.util.NbBundle.getBundle (ProjectListener.class).getString ("LBL_ProjectListener");
    }

}