/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microopenide.systems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.createfile;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.TopManager;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import java.io.IOException;

import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileAlreadyLockedException;
import java.io.PrintWriter;

/** Simple action. Creates a subfolder and an empty file (NewSource.java) */
/** Missing Icon Resource*/

public class CreateFile extends CallableSystemAction {
   // generated
    private static final long serialVersionUID = 6105821673293585672L;

    public String getName () {
        return NbBundle.getBundle (CreateFile.class).getString ("LBL_CreateFile");
    }

    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    
    public void performAction () {
    Repository repo = TopManager.getDefault().getRepository();
    FileObject folder = repo.find("org.netbeans.mymodules.createfile", null, null);
    // from an existing file system
    try {
        FileObject subfolder = folder.createFolder("sub");
        FileObject newfile = subfolder.createData("NewSourceFile", "java");
        FileLock lock;            // = null;
        try { 
            lock = newfile.lock();
        } catch (
            FileAlreadyLockedException e) {
            // Try again later;
            // perhaps display a warning dialog.
            return;
        }

        try {
            PrintWriter to = new PrintWriter(newfile.getOutputStream(lock));
            try {
                to.println("/* testing... */");
                to.println("package org.netbeans.mymodules.createfile;");
                to.println("      ");
                to.println("      ");
                to.println("public class NewSourceFile {");
                to.println("      ");
                to.println("public NewSourceFile(){}");
                to.println("private int newfield;");
                to.println("      ");
                to.println("}");
                } finally {
                    to.close();
                }
            } finally {
                lock.releaseLock();
            }
        } catch (IOException ioex) {
        ioex.printStackTrace ();
    }
}




}
