/*
 *                 Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 *
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2000 Sun
 * Microopenide.systems, Inc. All Rights Reserved.
 */

package org.netbeans.mymodules.addmethod;

import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.TopManager;
//import org.openide.filesystems.FileLock;

import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.cookies.*;

import java.io.IOException;

import org.openide.src.*;
import org.openide.src.nodes.*;
import org.openide.loaders.*;
import org.openide.filesystems.FileSystem; // override java.io.FileSystem
import org.openide.compiler.*;
import org.openide.compiler.Compiler;
import org.openide.src.MemberElement;
import java.lang.reflect.Modifier;
import org.openide.src.SourceException;

/** Simple action. Adds a method to a pre-existing class. */
/** No need to lock the file*/

public class AddMethod extends CallableSystemAction  {
    // generated
    private static final long serialVersionUID = 6101321673293585672L;
    
    public String getName () {
        return NbBundle.getBundle (AddMethod.class).getString ("LBL_AddMethod");
    }

    /*
    protected String iconResource () {
        return "AddMethodIcon.gif";
    }
    */
    
    public HelpCtx getHelpCtx () {
        // In a real situation could map to installed JavaHelp...
        return HelpCtx.DEFAULT_HELP;
    }
    
    public void performAction () {
        Repository repo = TopManager.getDefault().getRepository();
        //pick specific file object to make changes on
        FileObject filetobemodified = repo.findResource("org/netbeans/mymodules/createfile/sub/NewSourceFile.java"); // from an existing file system
        
        try {
            
            DataObject dob = DataObject.find ( filetobemodified );
            SourceCookie cookie = (SourceCookie) dob.getCookie (SourceCookie.class);                        
            ClassElement ce = cookie.getSource ().getClasses ()[0];
            // Get a class element from the system (say, a Java source file):
            // ClassElement ce = ClassElement.forName ("org.netbeans.mymodules.newmenuitem.sub.FooClass"); //(searches the hierarchy for FooClass!)
            // Now make up a method with an in-memory implementation:
            MethodElement me = new MethodElement ();
            //other elements include FieldElement, ConstructorElement, MemberElements
            // Set its properties:
            me.setName (Identifier.create ("newMethod"));
            me.setParameters (new MethodParameter[] { });
            me.setReturn (Type.INT);
            me.setExceptions (new Identifier[] { Identifier.create ("java.io.IOException") });
            me.setModifiers (Modifier.PUBLIC | Modifier.STATIC);
            me.setBody ("return 501;");
            // Add a copy to the class element, actually adding the method to source
            // code if writing is supported by the element hierarchy implementation:
            ce.addMethod (me);
            // public static int getFoo () throws IOException { return 5; }
            SaveCookie save = (SaveCookie) dob.getCookie (SaveCookie.class);
            save.save ();
        } catch (SourceException soe) {
            soe.printStackTrace();
            
        } catch (IOException ioe){
            ioe.printStackTrace();
            
        } catch (Exception e){
            e.printStackTrace();
        }
    }
    
}
