/*
 * DuplicateAction.java
 *
 * Created on Friday, 13 July 2001 1546 MDT
 */

package com.example.nb.tutorial.chapter_5;

import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class DuplicateAction extends CookieAction 
{

    /** Creates new DuplicateAction */
    public DuplicateAction() 
    {
    }

    public java.lang.String getName() 
    {
        return "Duplicate"; //NOI18N
    }
    
    public HelpCtx getHelpCtx() 
    {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected int mode() 
    {
        // enable duplication for as many qualifying nodes as are selected:
        return CookieAction.MODE_ALL;
    }
    
    protected java.lang.Class[] cookieClasses() 
    {
        // just the DuplicateCookie:
        return new Class[] {DuplicateCookie.class};
    }
    
    protected void performAction(final Node[] activatedNodes) 
    {
        RequestProcessor.postRequest(new Runnable() 
        {
            public void run() 
            {
                for (int i=0; i<activatedNodes.length; i++) 
                {
                    DuplicateCookie dc = (DuplicateCookie)activatedNodes[i].getCookie(DuplicateCookie.class);
                    if (dc != null) 
                    {
                        dc.duplicate();
                    }
                }
            }
        });
    }
}

