/*
 * DeleteAction.java
 *
 * Created on Friday, 13 July 2001 1546 MDT
 */

package com.example.nb.tutorial.chapter_5;

import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;

/**
 *
 * @author  adams
 * @version 1.0
 */
public class DeleteAction extends CookieAction 
{

    /** Creates new DeleteAction */
    public DeleteAction() 
    {
    }

    public java.lang.String getName() 
    {
        return "Delete"; //NOI18N
    }
    
    public HelpCtx getHelpCtx() 
    {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected int mode() 
    {
        // enable duplication for as many qualifying nodes as are selected:
        return CookieAction.MODE_ALL;
    }
    
    protected java.lang.Class[] cookieClasses() 
    {
        // just the DeleteCookie:
        return new Class[] {DeleteCookie.class};
    }
    
    protected void performAction(final Node[] activatedNodes) 
    {
        RequestProcessor.postRequest(new Runnable() 
        {
            public void run() 
            {
                for (int i=0; i<activatedNodes.length; i++) 
                {
                    DeleteCookie dc = (DeleteCookie)activatedNodes[i].getCookie(DeleteCookie.class);
                    if (dc != null) 
                    {
                        dc.delete();
                    }
                }
            }
        });
    }
}

