/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;

import org.openide.actions.*;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.*;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ScoreDataLoader extends MultiFileLoader {
    public static final String SCORE_MIME = "text/x-minicomposer-score"; // NOI18N
    public static final String AU_MIME = "audio/basic"; // NOI18N
    public static final String STANDARD_AU_EXT = "au"; // NOI18N
    private static final long serialVersionUID = 6424491892249774122L;
    public ScoreDataLoader() {
        super("org.netbeans.examples.modules.minicomposer.ScoreDataObject"); // NOI18N
    }
    protected String defaultDisplayName() {
        return NbBundle.getMessage(ScoreDataLoader.class, "LBL_loaderName");
    }
    protected SystemAction[] defaultActions() {
        return new SystemAction[] {
            SystemAction.get(OpenAction.class),
            SystemAction.get(EditAction.class),
            SystemAction.get(FileSystemAction.class),
            null,
            SystemAction.get(CompileAction.class),
            null,
            SystemAction.get(BuildAction.class),
            null,
            SystemAction.get(ExecuteAction.class),
            null,
            SystemAction.get(NewAction.class),
            SystemAction.get(ReorderAction.class),
            null,
            SystemAction.get(CutAction.class),
            SystemAction.get(CopyAction.class),
            SystemAction.get(PasteAction.class),
            null,
            SystemAction.get(DeleteAction.class),
            SystemAction.get(RenameAction.class),
            null,
            SystemAction.get(SaveAsTemplateAction.class),
            null,
            SystemAction.get(ToolsAction.class),
            SystemAction.get(PropertiesAction.class),
        };
    }
    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.getMIMEType().equals(SCORE_MIME)) {
            return fo;
        } else if (fo.getMIMEType().equals(AU_MIME) && !fo.isRoot()) {
            // Find a sibling with the MIME type for scores.
            Enumeration e = fo.getParent().getData(false);
            while (e.hasMoreElements()) {
                FileObject fo2 = (FileObject)e.nextElement();
                if (fo2.getMIMEType().equals(SCORE_MIME) && fo2.getName().equals(fo.getName())) {
                    return fo2;
                }
            }
            // This is an audio file but there is no score file to match.
            return null;
        } else {
            // Unrelated file.
            return null;
        }
    }
    protected MultiDataObject createMultiObject(FileObject primaryFile)
            throws DataObjectExistsException, IOException {
        return new ScoreDataObject(primaryFile, this);
    }
    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new FileEntry(obj, primaryFile);
    }
    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        secondaryFile.setImportant(false);
        return new FileEntry.Numb(obj, secondaryFile);
    }
    /** Utility method for players to find the .au file from a data object. */
    public static FileObject findAudioFile(ScoreDataObject obj) {
        Set seconds = obj.secondaryEntries(); // Set<MultiDataObject.Entry>
        if (seconds.isEmpty()) return null;
        MultiDataObject.Entry entry = (MultiDataObject.Entry)seconds.iterator().next();
        return entry.getFile();
    }
}
