package jp.turbosql.examples.modules.minicomposer;

import org.openide.text.*;
import org.openide.cookies.*;
import org.openide.windows.*;

public class ScoreEditorSupport extends DataEditorSupport implements EditorCookie, EditCookie, PrintCookie, CloseCookie
{
    public ScoreEditorSupport(ScoreDataObject obj)
    {
        super(obj, new ScoreEnv(obj));
    } // public ScoreEditorSupport()
    
    protected boolean notifyModified()
    {
        if(!super.notifyModified())
        {
            return false;
        } // if(!super.notifyModified())
        ScoreDataObject obj = (ScoreDataObject) getDataObject();
        if(obj.getCookie(SaveCookie.class) == null)
        {
            obj.addSaveCookie(new Save());
            obj.setModified(true);
        } // if(obj.getCookie(SaveCookie.class) == null)
        return true;
    } // protected boolean notifyModified()
    
    protected void notifyUnmodified()
    {
        super.notifyModified();
        ScoreDataObject obj = (ScoreDataObject) getDataObject();
        SaveCookie save = (SaveCookie) obj.getCookie(SaveCookie.class);
        if(save != null)
        {
            obj.removeSaveCookie(save);
            obj.setModified(false);
        } // if(save != null)
    } // protected void notifyUnmodified()
    
    private class Save implements SaveCookie
    {
        
        public void save() throws java.io.IOException {
            saveDocument();
            getDataObject().setModified(false);
        }
        
    } // private class Save implements SaveCookie
    
    private static class ScoreEnv extends DataEditorSupport.Env
    {
        private static final long serialVersionUID = 85639662675875L;
        
        public ScoreEnv(ScoreDataObject obj)
        {
            super(obj);
        } // public ScoreEnv(ScoreDataObject obj)
        
        protected org.openide.filesystems.FileObject getFile() {
            return getDataObject().getPrimaryFile();
        }
        
        protected org.openide.filesystems.FileLock takeLock() throws java.io.IOException {
            return ((ScoreDataObject) getDataObject()).getPrimaryEntry().takeLock();
        }
        
        public CloneableOpenSupport findCloneableOpenSupport()
        {
            return (ScoreEditorSupport) getDataObject().getCookie(ScoreEditorSupport.class);
        } // public CloneableOpenSupport findCloneableOpenSupport()
        
    } // private static class ScoreEnv extends DataEditorSupport.Env
    
} // public class ScoreEditorSupport extends DataEditorSupport implements EditorCookie, EditCookie, PrintCookie, CloseCookie


