package jp.turbosql.examples.modules.minicomposer;

import java.io.Serializable;
import java.io.*;
import java.util.*;

public final class Score implements Serializable
{
    /** Names in text fpr the tones */
    public static final String[] TONES_SHORT;
    /** Display names of the tones */
    public static final String[] TONES_LONG;
    /** Default tone to start with in a GUI. */
    public static final int DEFAULT_TONE1;
    /** Names in text for the octaves. */
    public static final String[] OCTAVES_SHORT;
    /** Display names of octaves. */
    public static final String[] OCTAVES_LONG;
    /** Default octave to display. */
    public static final int DEFAULT_OCTAVE;
    /** Frequency of middle C. */
    public static final float MIDDLE_C_HERTZ;
    /** Position of C in the tone list. */
    public static final int WHERE_IS_MIDDLE_OCTAVE;
    /** Frequency increment og one half-tone. */
    public static final float HALF_STEP;
    /** Names in text for durations. */
    public static final String[] DURATIONS_SHORT;
    /** Display names for durations. */
    public static final String[] DURATIONS_LONG;
    /** Lengths of durations in seconds. */
    public static final float[] DURATION_SECONDS;
    /** index of default duration to select. */
    public static final int DEFAULT_DURATION;
    /** Parse a score from a text stream. */
    public static Score parse(Reader r) throws IOException;
    /** Write a score to a text stream. */
    public static void generate(Score a, Writer w) throws IOException;
    /** One note (or rest) in a score. */
    public static final class Note implements Serializable, Cloneable
    {
        public Note(int tone, int octave, int duration);
        public int getTone();
        public int getOctave();
        public int getDuration();
        public Note cloneNote();
    } // publics static final class Note implements Serializable, Cloneable
    /** Create a new score programmatically.
     * Specify the tone, octave, and duration of each note. */
    public Score(List notes);
    /** Number of notes (and rests) in the score. */
    public int getSize();
    /** Get the note (or rest) at a given position. */
    public Note getNote(int pos);
    public boolean equals(Object o);
    public int hashCode();
} // public final class Score implements Serializable

