/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.openide.TopManager;
import org.openide.nodes.*;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/** Children of a score node.
 * One child node for each note.
 * A key is a Score.Note.
 */
public class ScoreChildren extends Children.Keys implements ChangeListener, TaskListener {
    private final ScoreCookie cookie;
    private boolean added = false;
    public ScoreChildren(ScoreCookie cookie) {
        this.cookie = cookie;
    }
    protected Node[] createNodes(Object key) {
        Score.Note n = (Score.Note)key;
        return new Node[] {new NoteNode(n)};
    }
    protected void addNotify() {
        super.addNotify();
        cookie.addChangeListener(this);
        added = true;
        stateChanged(null);
    }
    protected void removeNotify() {
        cookie.removeChangeListener(this);
        added = false;
        setKeys(Collections.EMPTY_SET);
        super.removeNotify();
    }
    public void stateChanged(ChangeEvent e) {
        if (added) {
            cookie.prepare().addTaskListener(this);
        }
    }
    public void taskFinished(Task task) {
        if (cookie.isValid()) {
            try {
                Score s = cookie.getScore();
                int c = s.getSize();
                Score.Note[] notes = new Score.Note[c];
                for (int i = 0; i < c; i++) {
                    notes[i] = s.getNote(i);
                }
                setKeys(notes);
            } catch (IOException ioe) {
                // ignore
            }
        }
    }
    public Index getIndex() {
        return new IndexImpl();
    }
    private class IndexImpl extends Index.Support {
        public Node[] getNodes() {
            return ScoreChildren.this.getNodes();
        }
        public int getNodesCount() {
            return getNodes().length;
        }
        public void reorder(int[] perm) {
            try {
                Score s = cookie.getScore();
                if (s.getSize() != perm.length) throw new IllegalArgumentException();
                Score.Note[] notes = new Score.Note[perm.length];
                for (int i = 0; i < perm.length; i++) {
                    notes[perm[i]] = s.getNote(i);
                }
                cookie.setScore(new Score(Arrays.asList(notes)));
                fireChangeEvent(new ChangeEvent(IndexImpl.this));
            } catch (IOException ioe) {
                TopManager.getDefault().getErrorManager().notify(ioe);
            }
        }
    }
}
