/*
 *                 Sun Public License Notice
 * 
 * The contents of this file are subject to the Sun Public License
 * Version 1.0 (the "License"). You may not use this file except in
 * compliance with the License. A copy of the License is available at
 * http://www.sun.com/
 * 
 * The Original Code is NetBeans. The Initial Developer of the Original
 * Code is Sun Microsystems, Inc. Portions Copyright 1997-2001 Sun
 * Microsystems, Inc. All Rights Reserved.
 */

package org.netbeans.examples.modules.minicomposer;

import java.io.File;
import java.io.IOException;

import javax.sound.sampled.*;

import org.openide.TopManager;
import org.openide.execution.*;
import org.openide.filesystems.*;
import org.openide.loaders.DataObject;
import org.openide.util.*;

public class InternalPlayer extends Executor {
    private static final long serialVersionUID = -3129235161777547136L;
    public ExecutorTask execute(ExecInfo info) throws IOException {
        throw new IllegalStateException("not called");
    }
    public ExecutorTask execute(DataObject obj) throws IOException {
        if (!(obj instanceof ScoreDataObject)) {
            IOException ioe = new IOException("Wrong type: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(InternalPlayer.class, "EXC_wrong_type", obj.getLoader().getDisplayName()));
            throw ioe;
        }
        FileObject fo = ScoreDataLoader.findAudioFile((ScoreDataObject)obj);
        if (fo == null) {
            IOException ioe = new IOException("No .au: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(InternalPlayer.class, "EXC_No_AU_file_found"));
            throw ioe;
        }
        final File f = FileUtil.toFile(fo);
        if (f == null) {
            IOException ioe = new IOException("No .au: " + obj);
            TopManager.getDefault().getErrorManager().annotate(ioe, NbBundle.getMessage(InternalPlayer.class, "EXC_file_must_be_local"));
            throw ioe;
        }
        class Job implements Runnable {
            public void run() {
                try {
                    AudioInputStream ais = AudioSystem.getAudioInputStream(f);
                    AudioFormat format = ais.getFormat();
                    DataLine.Info dlinfo = new DataLine.Info(Clip.class, ais.getFormat());
                    Clip clip = (Clip)AudioSystem.getLine(dlinfo);
                    clip.open(ais);
                    clip.start();
                    while (clip.isActive()) {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException ie) {
                        }
                    }
                    clip.stop();
                    clip.close();
                } catch (Exception e) {
                    // Will appear in Output Window.
                    e.printStackTrace();
                }
            }
        }
        return TopManager.getDefault().getExecutionEngine().execute
            (NbBundle.getMessage(ScoreExecSupport.class, "LBL_audio_play_process"),
             new Job(), null);
    }
    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.examples.modules.minicomposer.playing");
    }
}
