package jp.turbosql.modules.db.app;

import java.sql.*;
import java.util.Vector;
import java.util.StringTokenizer;
import java.math.BigDecimal;
import javax.swing.tree.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import jp.turbosql.modules.db.app.sqlanalyzer.*;
import jp.turbosql.modules.db.app.dialogs.*;

public class PostgreSQLDataObject implements DatabaseDataObjectInterface
{
    //SQL constants
    private static final String QUOTE = "\"";
    private static final String SQL_GET_DATABASES = "SELECT oid, *, pg_encoding_to_char(encoding) AS serverencoding, pg_get_userbyid(datdba) AS datowner FROM pg_database";
    private static final String SQL_GET_LANGUAGES = "SELECT now() AS ts, oid, * FROM pg_language";
    private static final String SQL_GET_USERS = "SELECT * FROM pg_user";
    private static final String SQL_GET_GROUPS = "SELECT * FROM pg_group";
    private static final String SQL_GET_SEQUENCES = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) AS seqowner, relacl FROM pg_class WHERE relkind = 'S'";
    private static final String SQL_GET_VIEWS = "SELECT now() AS ts, c.oid, c.relname, pg_get_userbyid(c.relowner) AS viewowner, c.relacl, pg_get_viewdef(c.relname) AS definition FROM pg_class c WHERE ((c.relhasrules AND (EXISTS (SELECT r.rulename FROM pg_rewrite r WHERE ((r.ev_class = c.oid) AND (bpchar(r.ev_type) = '1'::bpchar))))) OR (c.relkind = 'v'::" + QUOTE + "char" + QUOTE + "))";
    private static final String SQL_GET_TYPES7_1 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typrelid = 0";
    private static final String SQL_GET_TYPES7_3 = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as typeowner FROM pg_type WHERE typtype = 'b'";
    private static final String SQL_GET_DOMAINS = "SELECT now() AS ts, oid, *, pg_get_userbyid(typowner) as domainowner FROM pg_type WHERE typtype = 'd'";
    private static final String SQL_GET_FUNCTIONS = "SELECT now() AS ts, oid, *, pg_get_userbyid(proowner) as funcowner FROM pg_proc";
    private static final String SQL_GET_OPERATORS = "SELECT now() AS ts, oid, *, pg_get_userbyid(oprowner) as opowner FROM pg_operator";
    private static final String SQL_GET_RULES = "SELECT now() AS ts, oid, rulename, pg_get_ruledef(rulename) as definition FROM pg_rewrite";
    private static final String SQL_GET_TRIGGERS = "SELECT now() AS ts, t.oid, tgname, proname, tgargs, tgtype FROM pg_trigger t, pg_proc p WHERE t.tgfoid = p.oid AND tgisconstraint = FALSE";
    private static final String SQL_GET_TABLES7_1 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_TABLES7_2 = "SELECT now() AS ts, oid, relname, pg_get_userbyid(relowner) as tableowner, relacl, relhasoids FROM pg_class WHERE ((relkind = 'r') OR (relkind = 's'))";
    private static final String SQL_GET_COLUMNS7_1 = "SELECT a.oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_COLUMNS7_2 = "SELECT 0::oid AS oid, a.attname, a.attnum, t.typname, CASE WHEN ((a.attlen = -1) AND ((a.atttypmod)::int4 = (-1)::int4)) THEN (0)::int4 ELSE CASE WHEN a.attlen = -1 THEN CASE WHEN ((t.typname = 'bpchar') OR (t.typname = 'char') OR (t.typname = 'varchar')) THEN (a.atttypmod -4)::int4 ELSE (a.atttypmod)::int4 END ELSE (a.attlen)::int4 END END AS length, a.attnotnull, (SELECT adsrc FROM pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum) AS default, (SELECT indisprimary FROM pg_index i, pg_class ic, pg_attribute ia  WHERE i.indrelid = a.attrelid AND i.indexrelid = ic.oid AND ic.oid = ia.attrelid AND ia.attname = a.attname LIMIT 1) AS primarykey FROM pg_attribute a, pg_type t WHERE a.atttypid = t.oid";
    private static final String SQL_GET_INDEXES = "SELECT now() AS ts, i.oid, i.relname, x.indisunique, x.indisprimary, pg_get_indexdef(i.oid) AS definition FROM pg_index x, pg_class i WHERE i.oid = x.indexrelid";
    private static final String SQL_GET_INDEX_COLUMNS = "SELECT attname FROM pg_attribute";
    private static final String SQL_GET_CHECKS = "SELECT rcname, rcsrc FROM pg_relcheck WHERE NOT EXISTS (SELECT * FROM pg_relcheck AS c, pg_inherits AS i WHERE i.inhrelid = pg_relcheck.rcrelid AND (c.rcname = pg_relcheck.rcname OR (c.rcname[0] = '$' AND pg_relcheck.rcname[0] = '$')) AND c.rcsrc = pg_relcheck.rcsrc AND  c.rcrelid = i.inhparent)";
    private static final String SQL_GET_INHERITED_TABLES = "SELECT c.relname FROM pg_class c, pg_inherits i WHERE c.oid = i.inhparent";
    private static final String SQL_GET_AGGREGATES = "SELECT now() AS ts, oid, aggname, pg_get_userbyid(aggowner) AS owner, aggtransfn, aggfinalfn, aggbasetype, aggtranstype, aggfinaltype, agginitval FROM pg_aggregate";
    private static final String SQL_GET_FOREIGN_KEYS = "SELECT oid, tgrelid, tgconstrname, tgnargs, tgargs, tgdeferrable, tginitdeferred FROM pg_trigger WHERE tgisconstraint = TRUE AND tgtype = 21";

    //SQL related to Revision Control.
    //Note that the object OID is also logged to help create objects in dependency order when building scripts.
    private static final String SQL_CREATE_REVLOG = "CREATE TABLE pgadmin_rclog(rc_timestamp timestamp DEFAULT now(), rc_user name DEFAULT current_user, rc_action varchar(1), rc_type varchar(32), rc_identifier varchar(256), rc_oid oid, rc_table varchar(64), rc_version int4, rc_definition text, rc_comment text); GRANT SELECT, INSERT ON pgadmin_rclog TO PUBLIC; COMMENT ON TABLE pgadmin_rclog IS 'pgAdmin II Revision Log'; CREATE INDEX pgadmin_rclog_idx ON pgadmin_rclog (rc_action, rc_type, rc_identifier, rc_table, rc_oid, rc_version);";
    private static final String SQL_DROP_REVLOG = "DROP TABLE pgadmin_rclog;";
    private static final String SQL_GRAVEYARD = "SELECT DISTINCT ON (rc_type, rc_identifier) * FROM pgadmin_rclog ORDER BY rc_type, rc_identifier, rc_version DESC";
    
    private static final String[] drivers = {"org.postgresql.Driver"};   // postgresql driver
    private static final String defaultDriver = "org.postgresql.Driver";
    private static final String dbProtocol = "jdbc:postgresql://";              // protocol used for communicating with the db
    
    //------------------------------------------------------------------------
    // List for making the popup menus
    private static final String defaultActionList_default = "no action";
    private static final String[] defaultActionList = {defaultActionList_default};
    
    //private static final String serverNodeActionList_disconnectAction = "disconnect server", serverNodeActionList_propertiesAction = "properties";
    private static final String serverNodeActionList_propertiesAction = "Do Nothing";
    //private static final String[] serverNodeActionList = {serverNodeActionList_disconnectAction, serverNodeActionList_propertiesAction};
    private static final String[] serverNodeActionList = {serverNodeActionList_propertiesAction};
    private static final String serverMultipleNodeActionList_disconnectAction = "disconnect", serverMultipleNodeActionList_propertiesAction = "Properties";
    private static final String[] serverMultipleNodeActionList = {serverMultipleNodeActionList_disconnectAction};
    
    //private static final String[] databaselistNodeActionList = {"properties"};
    private static final String databaseListNodeActionList_addAction = "add Database", databaseListNodeActionList_propertiesAction = "properties";
    private static final String[] databaseListNodeActionList = {databaseListNodeActionList_addAction};
    private static final String databaseListMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] databaseListMultipleNodeActionList = {databaseListMultipleNodeActionList_propertiesAction};
    
    private static final String databaseNodeActionList_addAction = "add Database", databaseNodeActionList_deleteAction = "delete Database", databaseNodeActionList_executeSQLQuery = "execute SQL Query", databaseNodeActionList_propertiesAction = "properties";
    private static final String[] databaseNodeActionList = {databaseNodeActionList_addAction, databaseNodeActionList_deleteAction, databaseNodeActionList_executeSQLQuery};
    private static final String databaseMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] databaseMultipleNodeActionList = {databaseMultipleNodeActionList_propertiesAction};
    
    //private static final String[] tablelistNodeActionList = {"properties"};
    private static final String tableListNodeActionList_addAction = "add Table", tableListNodeActionList_propertiesAction = "properties";
    private static final String[] tableListNodeActionList = {tableListNodeActionList_addAction};
    private static final String tableListMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] tableListMultipleNodeActionList = {tableListMultipleNodeActionList_propertiesAction};
    
    private static final String tableNodeActionList_addAction = "add Table", tableNodeActionList_renameAction = "rename Table", tableNodeActionList_deleteAction = "delete Table", tableNodeActionList_viewDataAction = "view Data", tableNodeActionList_propertiesAction = "Properties";
    private static final String[] tableNodeActionList = {tableNodeActionList_addAction, tableNodeActionList_renameAction, tableNodeActionList_deleteAction, tableNodeActionList_viewDataAction};
    private static final String tableMultipleNodeActionList_propertiesAction = "Do Nothing";
    private static final String[] tableMultipleNodeActionList = {tableMultipleNodeActionList_propertiesAction};
    
    //-----------------------------------------------------------------------
    
    private static final String[] dbEncodings = {"UNICODE", "EUC-JP"};
    
    private static final String htmlOrange = "\"ff3300\"", htmlRed = "\"ff0000\"", htmlGreen = "\"00ff00\"", htmlBlue = "\"0000ff\"", htmlYellow = "\"00ffff\"";
    
    /*
    public ResultSet executeQuery()
    {
        ;
    }
     */
    
    public static Vector processToDataRows(ResultSet results)
    {
        
            // Get all rows.
            Vector dataRows = new Vector();                                // New Vector to store the data
            //String[] rowData;                                       // Stores one row
            try
            { 
                ResultSetMetaData metadata = results.getMetaData();
                int columns = metadata.getColumnCount();         // Get number of columns
                int[] columnTypes = new int[columns];
                String[] columnTypeNames = new String[columns];
            
                for(int i = 0; i < columns; i++)
                {
                    //columnNames[i] = metadata.getColumnLabel(i + 1);
                    columnTypes[i] = metadata.getColumnType(i + 1);
                    columnTypeNames[i] = metadata.getColumnTypeName(i + 1);
                    //System.out.println("column " + (i+1) +": " + metadata.getColumnTypeName(i+1));
                } // for(int i = 0; i < columns; i++)
            
                Object[] rowData;
                while(results.next())                                   // For each row...
                {
                    //rowData = new String[columns];                      // create array to hold the data
                    rowData = new Object[columns];
                    for(int i = 0; i < columns; i++)                    // For each column
                    {
                    //rowData[i] = results.getString(i+1);            // retrive the data item
                    //rowData[i] = results.getObject(i+1);
                        switch(columnTypes[i])
                        {
                            case Types.BIT:
                                // System.out.println("column " + (i+1) +" Datatype is BIT" );
                                rowData[i] = new Boolean(results.getBoolean(i+1));
                                break;
                            case Types.TINYINT:
                                // System.out.println("column " + (i+1) +" Datatype is TINYINT" );
                                rowData[i] = new Byte(results.getByte(i+1));
                                break;  
                            case Types.SMALLINT:
                                // System.out.println("column " + (i+1) +" Datatype is SMALLINT" );
                                rowData[i] = new Short(results.getShort(i+1));
                                break;
                            case Types.INTEGER:
                                // System.out.println("column " + (i+1) +" Datatype is INTEGER" );
                                rowData[i] = new Integer(results.getInt(i+1));
                                break;
                            case Types.BIGINT:
                                // System.out.println("column " + (i+1) +" Datatype is BIGINT" );
                                rowData[i] = new Long(results.getLong(i+1));
                                break;
                            case Types.FLOAT:
                                // System.out.println("column " + (i+1) +" Datatype is FLOAT" );
                                rowData[i] = new Float(results.getFloat(i+1));
                                break;
                            case Types.DOUBLE:
                                // System.out.println("column " + (i+1) +" Datatype is DOUBLE" );
                                rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.DECIMAL:
                                // System.out.println("column " + (i+1) +" Datatype is DECIMAL" );
                                rowData[i] = results.getBigDecimal(i+1);
                                //rowData[i] = new Float(results.getFloat(i+1));
                                rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.NUMERIC:
                                // System.out.println("column " + (i+1) +" Datatype is NUMERIC" );
                                rowData[i] = results.getBigDecimal(i+1);
                                //rowData[i] = new Float(results.getFloat(i+1));
                                //rowData[i] = new Double(results.getDouble(i+1));
                                break;
                            case Types.CHAR:
                                // System.out.println("column " + (i+1) +" Datatype is CHAR" );
                                rowData[i] = results.getString(i+1);
                                break;
                            case Types.VARCHAR:
                                // System.out.println("column " + (i+1) +" Datatype is VARCHAR" );
                                rowData[i] = results.getString(i+1);
                                break;
                            case Types.DATE:
                                // System.out.println("column " + (i+1) +" Datatype is DATE" );
                                //rowData[i] = results.getDate(i+1);
                                // String representation makes it modifyable.
                                Date temp_date;
                                temp_date = results.getDate(i+1);
                                if(temp_date != null)
                                    rowData[i] = temp_date.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getDate(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.TIME:
                                // System.out.println("column " + (i+1) +" Datatype is TIME" );
                                //rowData[i] = results.getString(i+1);
                                Time temp_time;
                                temp_time = results.getTime(i+1);
                                if(temp_time != null)
                                    rowData[i] = temp_time.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getTime(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.TIMESTAMP:
                                // System.out.println("column " + (i+1) +" Datatype is TIMESTAMP" );
                                //rowData[i] = results.getString(i+1);
                                Timestamp temp_timestamp;
                                temp_timestamp = results.getTimestamp(i+1);
                                if(temp_timestamp != null)
                                    rowData[i] = temp_timestamp.toString();
                                else
                                    rowData[i] = null;
                                //rowData[i] = results.getTimestamp(i+1).toString();
                                //rowData[i] = results.getString(i+1);
                                break;
                            case Types.JAVA_OBJECT:
                                // System.out.println("column " + (i+1) +" Datatype is JAVA_OBJECT" );
                                rowData[i] = results.getObject(i+1);
                                break;
                            default:
                                if(columnTypeNames[i].equals("text"))
                                {
                                    // System.out.println("column " + (i+1) +" Datatype is text" );
                                    rowData[i] = results.getString(i+1);
                                } // if(columnTypeNames[i].equals("text"))
                                else
                                {
                                    // System.out.println("column " + (i+1) +" Datatype is unknown" );
                                    rowData[i] = results.getString(i+1);
                                } // else
                                break;
                        } // switch(args.length)
                        
                        if(results.wasNull())                                   // This should take care of all nulls in the columns.
                            rowData[i] = null;
                                    //rowData[i] = results.getObject(i+1);
                                    //rowData[i] = results.getString(i+1);
                        /*
                                if(columnTypeNames[i].equals("oid"))
                                {
                                    //System.out.println("column " + (i+1) +" Datatype is text" );
                                    rowData[i] = new Integer(results.getInt(i+1));                                  
                                } // if(columnTypeNames[i].equals("text"))
                                else
                                {
                                    System.out.println("column " + (i+1) +" Datatype is unknown" );
                                    rowData[i] = results.getObject(i+1);
                                } // else
                         */
                    } // for(int i = 0; i < columns; i++)
                    dataRows.addElement(rowData);                       // Store the row in the vector
                } // while(results.next())
            } // try
            catch (SQLException sqle)
            {
                System.err.println(sqle);
            } // catch (SQLException sqle)
            return dataRows;
    } // public void setDataRows(Vector param_dataRows)
    
    public static Object[] processToColumnTypeArray(int[] columnTypes, String[] columnTypeNames)
    {
        int columnCount = columnTypes.length;
        Object[] columnTypeArray = new Object[columnCount];
        //int[] columnTypes = param_ColumnTypes;
        //String[] columnTypeNames = param_ColumnTypeNames;
        
        for(int i = 0; i < columnCount; i++)                    // For each column
        {
            //rowData[i] = results.getString(i+1);            // retrive the data item
            //rowData[i] = results.getObject(i+1);
            switch(columnTypes[i])
            {
                case Types.BIT:
                    //System.out.println("column " + (i+1) +" Datatype is BIT" );
                    columnTypeArray[i] = new Boolean(false);
                    break;
                case Types.TINYINT:
                    //System.out.println("column " + (i+1) +" Datatype is TINYINT" );
                    columnTypeArray[i] = new Byte(Byte.MIN_VALUE);
                    break;  
                case Types.SMALLINT:
                    //System.out.println("column " + (i+1) +" Datatype is SMALLINT" );
                    columnTypeArray[i] = new Short(Short.MIN_VALUE);
                    break;
                case Types.INTEGER:
                    //System.out.println("column " + (i+1) +" Datatype is INTEGER" );
                    columnTypeArray[i] = new Integer(0);
                    break;
                case Types.BIGINT:
                    //System.out.println("column " + (i+1) +" Datatype is BIGINT" );
                    columnTypeArray[i] = new Long(0);
                    break;
                case Types.FLOAT:
                    //System.out.println("column " + (i+1) +" Datatype is FLOAT" );
                    columnTypeArray[i] = new Float(0);
                    break;
                case Types.DOUBLE:
                    //System.out.println("column " + (i+1) +" Datatype is DOUBLE" );
                    columnTypeArray[i] = new Double(0);
                    break;
                case Types.DECIMAL:
                    //System.out.println("column " + (i+1) +" Datatype is DECIMAL" );
                    columnTypeArray[i] = new BigDecimal(0);
                    break;
                case Types.NUMERIC:
                    //System.out.println("column " + (i+1) +" Datatype is NUMERIC" );
                    columnTypeArray[i] = new BigDecimal(0);
                    break;
                case Types.CHAR:
                    //System.out.println("column " + (i+1) +" Datatype is CHAR" );
                    columnTypeArray[i] = new String("");
                    break;
                case Types.VARCHAR:
                    //System.out.println("column " + (i+1) +" Datatype is VARCHAR" );
                    columnTypeArray[i] = "";
                    break;
                case Types.DATE:
                    //System.out.println("column " + (i+1) +" Datatype is DATE" );
                    //rowData[i] = results.getDate(i+1);
                    // String representation makes it modifyable.
                    //rowData[i] = results.getDate(i+1).toString();
                    columnTypeArray[i] =  new String("");
                    break;
                case Types.TIME:
                    //System.out.println("column " + (i+1) +" Datatype is TIME" );
                    //rowData[i] = results.getString(i+1);
                    //rowData[i] = results.getTime(i+1).toString();
                    columnTypeArray[i] = new String("");
                    break;
                case Types.TIMESTAMP:
                    //System.out.println("column " + (i+1) +" Datatype is TIMESTAMP" );
                    //rowData[i] = results.getString(i+1);
                    //rowData[i] = results.getTimestamp(i+1).toString();
                    columnTypeArray[i] = new String("");
                    break;
                case Types.JAVA_OBJECT:
                    //System.out.println("column " + (i+1) +" Datatype is JAVA_OBJECT" );
                    columnTypeArray[i] = new Object();
                    break;
                default:
                    if(columnTypeNames[i].equals("text"))
                    {
                        //System.out.println("column " + (i+1) +" Datatype is text" );
                        columnTypeArray[i] = new String("");
                    } // if(columnTypeNames[i].equals("text"))
                    else
                    {
                        //System.out.println("column " + (i+1) +" Datatype is unknown" );
                        columnTypeArray[i] = new String("");
                    } // else
                        break;
                    } // switch(args.length)
                    //rowData[i] = results.getObject(i+1);
                    //rowData[i] = results.getString(i+1);
                     /*
                   if(columnTypeNames[i].equals("oid"))
                   {
                        //System.out.println("column " + (i+1) +" Datatype is text" );
                        rowData[i] = new Integer(results.getInt(i+1));                                  
                    } // if(columnTypeNames[i].equals("text"))
                    else
                    {
                        System.out.println("column " + (i+1) +" Datatype is unknown" );
                        rowData[i] = results.getObject(i+1);
                    } // else
                    */
        } // for(int i = 0; i < columns; i++)
        return columnTypeArray;
    } // public static Object[] processToColumnTypeArray(int[] param_ColumnTypes, String[] param_ColumnTypeNames)
    
    public static StatementMetaData parseSQLStatement(String statement)
    {
        StringTokenizer strTokenizer;
        String statementTrimmed = statement.trim();
        String statementQuote = "";                               // statement with spaces within QUOTEs and DOUBLE QUOTEs removed
        boolean inQuote = false;
        String lowerCaseStatementQuote;
        int start_ptr = 0;                                      // start pointer for sub-string
        int end_ptr = 0;                                        // end pointer for sub-string
        int from_start_ptr = 0;                                 // start pointer for the SQL keyword FROM
        String SQL_KEYWORD_FROM_lc = "from";                    // the FROM keyword in lower case;
        boolean has_FROM = false;                               // has the keyword FROM
        boolean is_escape = false;                              // an escape character
        boolean was_space = false;                              // to indicate that the previous character was a space
        String table_name = "";                                 // the table name
        boolean table_updatable = true;                         // whether the table is updatable or not.
        
        // System.out.println(statementTrimmed.length());
        
        
        // Replace spaces and new lines \n inside QUOTEs with tabs \t
        // Replace tabs \t and new lines \n outside QUOTEs with spaces
        
        for(int i = 0; i < statementTrimmed.length(); i++)
        {
            if(is_escape)
            {
                is_escape = false;
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
            } // if(is_escape)
            else if(statementTrimmed.substring(i, i+1).equals("\\"))
            {
                is_escape = true;
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
            } // else if(statementTrimmed.substring(i, i+1).equals("\\"))
            else if(statementTrimmed.substring(i, i+1).equals("'") || statementTrimmed.substring(i, i+1).equals("\""))
            {
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
                inQuote = !inQuote;
            } // if(statementTrimmed.substring(i, i).equals("'") || statementTrimmed.substring(i).equals("\""))
            else if(((statementTrimmed.substring(i, i+1).equals(" ") || statementTrimmed.substring(i, i+1).equals("\n")) && inQuote))
            {
                statementQuote = statementQuote + "\t";                  // <tab>
            } // else if((statementTrimmed.substring(i, i+1).equals(" ") && inQuote))
            else if(((statementTrimmed.substring(i, i+1).equals("\t") || statementTrimmed.substring(i, i+1).equals("\n")) && (!inQuote)))
            {
                statementQuote = statementQuote + " ";                      // <SPACE>
            }
            else
                statementQuote = statementQuote + statementTrimmed.substring(i, i+1);
        } // for(int i = 0; i < statementTrimmed.length(); i++)
                       
        String temp_str = "";
        String temp_str2 = "";
        
        // Remove the unnescessary spaces
        for(int i = 0; i < statementQuote.length(); i++)
        {
            if(statementQuote.substring(i, i+1).equals(" ") && (!was_space))
            {
                was_space = true;
                temp_str = temp_str + statementQuote.substring(i, i+1);
            } // if(is_escape)
            else if((!statementQuote.substring(i, i+1).equals(" ")))
            {
                was_space = false;
                temp_str = temp_str + statementQuote.substring(i, i+1);
            } // else if(was_space)
        } // for(int i = 0; i < statement.length(); i++)
        statementQuote = temp_str;
        // System.out.println(statementQuote);
        
        // find a 'FROM'
        temp_str = "";
        lowerCaseStatementQuote = statementQuote.toLowerCase();
        if((lowerCaseStatementQuote.indexOf(" from ", start_ptr)) != -1)
        {
            has_FROM = true;
            temp_str = statementQuote.substring(lowerCaseStatementQuote.indexOf(" from ", start_ptr) + SQL_KEYWORD_FROM_lc.length() + 2); // adjusted + 2 for space
            strTokenizer = new StringTokenizer(temp_str, " ");
            if(strTokenizer.hasMoreTokens())
                table_name = strTokenizer.nextToken();
            if(table_name.toLowerCase().equals("only"))                         // take care of the keyword ONLY.
                table_name = strTokenizer.nextToken();
            temp_str2 = "";
        
            for(int i = 0; i < table_name.length(); i++)
            {
                if(table_name.substring(i, i+1).equals("\t"))
                    temp_str2 = temp_str2 + " ";
                else
                    temp_str2 = temp_str2 + table_name.substring(i, i+1);
            } // for(int i = 0; i < table_name; i++)
        
            table_name = temp_str2;
        
            // find a comma ,
            
            if(table_name.substring(table_name.length()-1, table_name.length()).equals(","))
            {
                table_updatable = false;
                table_name = table_name.substring(0, table_name.length()-1);
            }
             
                    
        } // if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from ", start_ptr)) != -1)
        else
        {
            table_updatable = false;
        } // else
                
        // System.out.println("table: " + table_name);
        
        /*
        if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from ", start_ptr)) == -1)
            if((from_start_ptr = lowerCaseStatementQuote.indexOf("\nfrom ", start_ptr)) == -1)
                if((from_start_ptr = lowerCaseStatementQuote.indexOf("\nfrom\n", start_ptr)) == -1)
                    if((from_start_ptr = lowerCaseStatementQuote.indexOf(" from\n", start_ptr)) == -1)
        */
        
        //Integer
        
        return new StatementMetaData(table_name, table_updatable);
    } // public StatementMetaData parseSQLStatement()
        
    // make a prepared statement
    public static PreparedStatement getPreparedStatementForUpdate(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    {
        Vector SET_parameters = new Vector();                       // parameter list for only changed columns
        String sql_statement = "UPDATE " + tableName;
        String WHERE_statement = " WHERE";
        
        PreparedStatement pStatement = null;
        
        String temp_condition = "";             // used in the WHERE
        // get the list of columns with changed data
        for(int i = 0; i < columnNames.length; i++)
        {
            if((changedRowData[i] == null) && (originalRowData[i] == null))
                ;                                                   // If both are still null, we don't need to do anything.
            else if(originalRowData[i] == null)
                SET_parameters.add(new Integer(i));                 // If the original data is null, we will take the new value if it is not null(automatically not null since it passed the first if statement)
            else if(changedRowData[i] == null)
                SET_parameters.add(new Integer(i));                 // If the changed data is null, we will take the new value as null(original value automatically not null since it passed the first if statement)
            else if(!(changedRowData[i].equals(originalRowData[i])))
                SET_parameters.add(new Integer(i));
            
            // construct the WHERE_statement
            // Need to compansate for null
            if(originalRowData[i] == null)
                temp_condition = columnNames[i] + " IS NULL";
            else
                temp_condition = columnNames[i] + "=?";
                //if(originalRowData[i].getClass().equals(new BigDecimal(0).getClass()))
                //    temp_condition = columnNames[i] + "=\'?\'";
                //else
                    //temp_condition = columnNames[i] + "=?";
            if(i == 0)
                WHERE_statement = WHERE_statement + " " + temp_condition;
            else
                WHERE_statement = WHERE_statement + " AND " + temp_condition;
        } // for(int i = 0; i < columnNames.length; i++)
        
        if(SET_parameters.size() == 0)      // Don't do anything if statement if 0;
        {
            return null;
        } // if(SET_parameters.size() == 0)
        
        // Form the sql statement
        sql_statement = sql_statement + " SET";
        for(int i = 0; i < SET_parameters.size(); i++)
        {
            if(i == 0)
                sql_statement = sql_statement + " " + columnNames[((Integer)SET_parameters.get(i)).intValue()] + "=?";
            else
                sql_statement = sql_statement + ", " + columnNames[((Integer)SET_parameters.get(i)).intValue()] + "=?";
        } // for(int i = 0; i < SET_parameters.size(); i++)
        
        sql_statement = sql_statement + WHERE_statement;
        
        // System.out.println(sql_statement);
                
        // Fiil up the parameters
        int temp_index = 0;
        // index to go through all the '?' in the statment.
        
        try
        {
        pStatement = conn.prepareStatement(sql_statement);
        
        for(int i = 0; i < SET_parameters.size(); i++)
            pStatement.setObject(++temp_index, changedRowData[((Integer)SET_parameters.get(i)).intValue()]);    // increment before using the varaible
        
        for(int i = 0; i < columnNames.length; i++)
            if(originalRowData[i] != null)                                      // skip if it is a null, value is already assigned as "IS NULL"
                pStatement.setObject(++temp_index, originalRowData[i]);                                             // increment before using the varaible
        }
        catch (SQLException sqle)
        {
            System.err.println("From pStatement" +  sqle);
        } // catch (SQLException sqle)
        
        //System.out.println("temp index: " +temp_index);
        
        return pStatement;
    } // public static PreparedStatement getPreparedStatementForUpdate(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    
    public static PreparedStatement getPreparedStatementForInsert(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    {
        Vector columnsInsert_parameters = new Vector();                 // columns with data
        String sql_statement = "INSERT INTO " + tableName;
        String VALUES_statement = " VALUES(";
        String columnsInsert_statement = "(";
        
        PreparedStatement pStatement = null;
                
        // get the list of columns with changed data
        for(int i = 0; i < columnNames.length; i++)
        {
            if(changedRowData[i] != null)
                columnsInsert_parameters.add(new Integer(i));
        } // for(int i = 0; i < columnNames.length; i++)
        
        if(columnsInsert_parameters.size() == 0)                // don't need to do anythinf if there is no change at all
            return null;
        
        // System.out.println("columnNames.length: " + columnNames.length);
        // System.out.println("columnsInsert_parameters.size: " + columnsInsert_parameters.size());
        
        // go through and construct the columnInsert statement and VALUES statement
        for(int i = 0; i < columnsInsert_parameters.size(); i++)
        {
            if(i == 0)
            {
                columnsInsert_statement = columnsInsert_statement + columnNames[((Integer)columnsInsert_parameters.get(i)).intValue()];
                VALUES_statement = VALUES_statement + "?";
            } // if(i == 0)
            else
            {
                columnsInsert_statement = columnsInsert_statement + ", " +columnNames[((Integer)columnsInsert_parameters.get(i)).intValue()];
                VALUES_statement = VALUES_statement + ", ?";
            } // else
        } // for(int i = 0; i < columnsInsert_parameters.size(); i++)
        
        columnsInsert_statement = columnsInsert_statement + ")";
        VALUES_statement = VALUES_statement + ")";
        
        sql_statement = sql_statement + " " + columnsInsert_statement + VALUES_statement;
        
        // System.out.println(sql_statement);
        
        // Fiil up the parameters
        int temp_index = 0;
        // index to go through all the '?' in the statment.
        
        try
        {
        pStatement = conn.prepareStatement(sql_statement);
        
        for(int i = 0; i < columnsInsert_parameters.size(); i++)
            pStatement.setObject(++temp_index, changedRowData[((Integer)columnsInsert_parameters.get(i)).intValue()]);    // increment before using the varaible
        }
        catch (SQLException sqle)
        {
            //System.err.println("From pStatement" +  sqle);
            System.err.println(sqle);
        } // catch (SQLException sqle)
        
        // System.out.println("temp index(INSERT): " +temp_index);
        
        return pStatement;
    } // public static PreparedStatement getPreparedStatementForInsert(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    
    public static PreparedStatement getPreparedStatementForDelete(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    {
        String sql_statement = "DELETE FROM " + tableName;
        String WHERE_statement = " WHERE";
        
        PreparedStatement pStatement = null;
        
        String temp_condition = "";             // used in the WHERE
        // get the list of columns with changed data
        for(int i = 0; i < columnNames.length; i++)
        {
            // construct the WHERE_statement
            // Need to compansate for null
            if(originalRowData[i] == null)
                temp_condition = columnNames[i] + " IS NULL";
            else
                temp_condition = columnNames[i] + "=?";
                //if(originalRowData[i].getClass().equals(new BigDecimal(0).getClass()))
                //    temp_condition = columnNames[i] + "=\'?\'";
                //else
                    //temp_condition = columnNames[i] + "=?";
            if(i == 0)
                WHERE_statement = WHERE_statement + " " + temp_condition;
            else
                WHERE_statement = WHERE_statement + " AND " + temp_condition;
        } // for(int i = 0; i < columnNames.length; i++)
        
        sql_statement = sql_statement + " " + WHERE_statement;
        //System.out.println(sql_statement);
        
        int temp_index = 0;
        // index to go through all the '?' in the statment.
        
        try
        {
        pStatement = conn.prepareStatement(sql_statement);
        
        for(int i = 0; i < originalRowData.length; i++)
            if(originalRowData[i] != null)
                pStatement.setObject(++temp_index, originalRowData[i]);    // increment before using the varaible
        }
        catch (SQLException sqle)
        {
            System.err.println("From pStatementDelete " +  sqle);
            //System.err.println(sqle);
        } // catch (SQLException sqle)
        
        // System.out.println("temp index(INSERT): " +temp_index);
        
        return pStatement;
    } // public static PreparedStatement getPreparedStatementForDelete(Connection conn, String tableName, String[] columnNames, int[] columnTypes, String[] columnTypeNames, Object[] originalRowData, Object[] changedRowData)
    
    public static String[] getDBEncodings()
    {
        return dbEncodings;
    } // public static void String[] getDBEncodings()
    
//---------------------------------------------------------------------------
// methods for building a db tree
    // building the server node
    public static void buildServerNode(TreeNode serverNode, Connection conn)
    {
        DefaultMutableTreeNode databaseListNode;
        DatabaseListNodeObject databaseListNodeObject = new DatabaseListNodeObject("Databases");
        databaseListNode = new DefaultMutableTreeNode(databaseListNodeObject);
        DefaultMutableTreeNode serverNodeDef = ((DefaultMutableTreeNode)serverNode);

        // build the DatabaseListNode
        //--------------------------------------------------------------------
        // We have to add this one before we build the tree or we wiil not be able to use getParent.
        serverNodeDef.add(databaseListNode);
        //--------------------------------------------------------------------
        PostgreSQLDataObject.buildDatabaseListNode(databaseListNode, conn);
                
    } // public static JTree getDBTree(Connection conn)
    
    public static void buildDatabaseListNode(TreeNode databaseListNode, Connection conn)
    {
        // building the child nodes
        DefaultMutableTreeNode[] databaseNodes;
        String[] databaseNames = PostgreSQLDataObject.getDatabaseNames(conn);
        DefaultMutableTreeNode databaseListNodeDef = ((DefaultMutableTreeNode)databaseListNode);
        
        //ServerNodeObject serverNodeObject = (ServerNodeObject)((DefaultMutableTreeNode)databaseListNode.getParent()).getUserObject();        // to get information to build new connections
        
        DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
        ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
        
        
        String username = serverNodeObject.getUsername();
        String password = serverNodeObject.getPassword();
        // shortern the number of variables
        //String serverIP = serverNodeObject.getServerIP();
        //String serverPort = serverNodeObject.getServerPort();
        String urlPrefix = dbProtocol + serverNodeObject.getServerIP() + ":" + serverNodeObject.getServerPort() + "/";
                
        for(int i = 0; i < databaseNames.length; i++)
        {
            if(databaseNames[i].equals("template0"))             // we cannot connect to template0.
                continue;
            DefaultMutableTreeNode databaseNode = new DefaultMutableTreeNode(new DatabaseNodeObject(databaseNames[i]));
            Connection conn2 = PostgreSQLDataObject.getConnection(urlPrefix + databaseNames[i], username, password);
            
            databaseListNodeDef.add(databaseNode);
            PostgreSQLDataObject.buildDatabaseNode(databaseNode, conn2);
            //conn2.close();
        } // for(int i = 0; i < databaseNames.length; i++)
        
    } // public static void buildDatabaseListNode(MutableTreeNode databaseListNode, Connection conn)
    
    public static void buildDatabaseNode(TreeNode databaseNode, Connection conn)
    {
        DefaultMutableTreeNode tableListNode;
        TableListNodeObject tableListNodeObject = new TableListNodeObject("Tables");
        tableListNode = new DefaultMutableTreeNode(tableListNodeObject);
        DefaultMutableTreeNode databaseNodeDef = ((DefaultMutableTreeNode)databaseNode);

        // build the DatabaseListNode
        databaseNodeDef.add(tableListNode);
        PostgreSQLDataObject.buildTreeListNode(tableListNode, conn);
        // databaseNodeDef.add(tableListNode);
    } // public static void buildDatabaseNode(MutableTreeNode databaseNode, Connection conn)
    
    public static void buildTreeListNode(TreeNode tableListNode, Connection conn)
    {
        DefaultMutableTreeNode[] tableNodes;
        String[] tableNames = PostgreSQLDataObject.getTableNames(conn);
        DefaultMutableTreeNode tableListNodeDef = ((DefaultMutableTreeNode)tableListNode);
        
        for(int i = 0; i < tableNames.length; i++)
        {
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(new TableNodeObject(tableNames[i]));
                        
            tableListNodeDef.add(tableNode);
        } // for(int i = 0; i < databaseNames.length; i++)
        
    } // public static void buildTreeListNode(TreeNode databaseNode, Connection conn)
        
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
// Handling popup menus
    
    public static String[] getPopupMenuNodeActionList(NodeObject nodeObject)
    {
        String[] popupList;
        
        if(nodeObject instanceof ServerNodeObject)
        {
            popupList = serverNodeActionList;
        } // if(nodeObject instanceof ServerNodeObject)
        else if(nodeObject instanceof DatabaseNodeObject)
        {
            popupList = databaseNodeActionList;
        } // else if(nodeObject instanceof DatabaseNodeObject)
        else if(nodeObject instanceof DatabaseListNodeObject)
        {
            popupList = databaseListNodeActionList;
        } // else if(nodeObject instanceof DatabaseNodeObject)
        else if(nodeObject instanceof TableNodeObject)
        {
            popupList = tableNodeActionList;
        } // else if(nodeObject instanceof DatabaseNodeObject)
        else if(nodeObject instanceof TableListNodeObject)
        {
            popupList = tableListNodeActionList;
        } // else if(nodeObject instanceof DatabaseNodeObject)
        /*
        else if(nodeObject instanceof ViewNodeObject)
        {
            setDisabledIcon(new ImageIcon(viewNodeImageURL));
        } // else if(nodeObject instanceof DatabaseNodeObject)
        */
        else
        {
            popupList = defaultActionList;
        } // else
        
        return popupList;
    } // public static JPopupMenu getPopupMenuNodeAction(NodeObject nodeObject)
    
    public static String[] getPopupMenuMultipleNodeActionList(NodeObject nodeObject)
    {
        String[] popupList;
        
        if(nodeObject instanceof ServerNodeObject)
        {
            popupList = serverMultipleNodeActionList;
        } // if(nodeObject instanceof ServerNodeObject)
        else if(nodeObject instanceof DatabaseListNodeObject)
        {
            popupList = databaseListMultipleNodeActionList;
        } // else if(nodeObject instanceof DatabaseListNodeObject)
        else if(nodeObject instanceof DatabaseNodeObject)
        {
            popupList = databaseMultipleNodeActionList;
        } // else if(nodeObject instanceof DatabaseNodeObject)        
        else if(nodeObject instanceof TableListNodeObject)
        {
            popupList = tableListMultipleNodeActionList;
        } // else if(nodeObject instanceof TableListNodeObject)
        else if(nodeObject instanceof TableNodeObject)
        {
            popupList = tableMultipleNodeActionList;
        } // else if(nodeObject instanceof TableNodeObject)
        /*
        else if(nodeObject instanceof ViewNodeObject)
        {
            setDisabledIcon(new ImageIcon(viewNodeImageURL));
        } // else if(nodeObject instanceof DatabaseNodeObject)
        */
        else
        {
            popupList = defaultActionList;
        } // else
        
        return popupList;
    } // public static String[] getPopupMenuMultipleNodeActionList(NodeObject nodeObject)
    
//---------------------------------------------------------------------------
    // method to get database names
    public static String[] getDatabaseNames(Connection conn)
    {
        Statement statement; 
        ResultSet rs;
        String[] databaseNames = null;
        Vector databaseNamesVector = new Vector();
        
        try
        {
        statement = conn.createStatement();
        rs = statement.executeQuery(SQL_GET_DATABASES);
        
        while(rs.next())
        {
            databaseNamesVector.add(rs.getString(2));       // fixed to column 2
        } // while(rs.next())
        
        databaseNames = new String[databaseNamesVector.size()];
        
        for(int i = 0; i < databaseNamesVector.size(); i++)
        {
            databaseNames[i] = (String) databaseNamesVector.get(i);
        } // for(int i = 0; i < databaseNamesVector.size(); i++)
        
        } // try
        catch(SQLException sqle)
        {
            System.out.println(sqle.getMessage());
        } // catch(SQLException sqle)
        return databaseNames;
    } // public static String[] getDatabaseNames(Connection conn)
    
    // assuming the database from which the tables come from is already set by the connection
    public static String[] getTableNames(Connection conn)
    {
        String[] tableNames = null;
        Vector tableNamesVector = new Vector();
        
        DatabaseMetaData dbMetaData;
        String[] tableTypes = {"TABLE"};                    // We want only tables
        ResultSet rs;
                
        try
        {
            dbMetaData = conn.getMetaData();
            rs = dbMetaData.getTables(null, null, null, tableTypes);         // Get the tables info
            while(rs.next())                                // For each table
            {
                tableNamesVector.add(rs.getString("TABLE_NAME"));     // get the table name
            } // while(rs.next())
            
            tableNames = new String[tableNamesVector.size()];
            
            for(int i = 0; i < tableNamesVector.size(); i++)
            {
                tableNames[i] = (String) tableNamesVector.get(i);
            } // for(int i = 0; i < databaseNamesVector.size(); i++)
            
        } // try
        catch(SQLException sqle)
        {
            System.out.println(sqle.getMessage());
        } // catch(SQLException sqle)
        return tableNames;
        
    } // public static void getTableNames(Connection conn)
    
    public static Connection getConnection(String url, String username, String password)
    {
        Connection conn = null;
        
        for(int i = 0; i < drivers.length; i++)
            try
            {
                Class.forName(drivers[i]);
            }
            catch(ClassNotFoundException cnfe)
            {
                System.err.println(cnfe);
                //status.setText("Driver load failed: " + cnfe.getMessage());
            } // catch(ClassNotFoundException cnfe)
        
        try
        {
            conn = DriverManager.getConnection(url, username, password);
        } // try
        catch(SQLException sqle)    
        {
            //System.out.println("From PostgreSQLDataObject.getConnection: " + sqle.getMessage());
            System.out.println(sqle.getMessage());
        } // catch(SQLException sqle)
        return conn;
    } // public static Connection getConnection(String url, String username, String password)
    
    public static String getDBProtocol()
    {
        return dbProtocol;
    } // public static String getDbProtocol()
    
    public static String getDefaultDBURL(String serverIP, String serverPort)
    {
        return dbProtocol + serverIP + ":" + serverPort + "/template1";          // template1 can be used for the default db to connect to.
    } // public static String getDbProtocol()
//---------------------------------------------------------------------------
// handle actions
    
    public static void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    {        
        /*
        Component parent = getParentFromPopupComponent(component);
        
        //parent = ((JComponent)component_ptr).getTopLevelAncestor();
        JDialog jDialog = new JOptionPane(parent.getClass().toString(), JOptionPane.YES_NO_CANCEL_OPTION).createDialog(parent, "test");
        //jDialog.set
        //JOptionPane.showMessageDialog(parent, "test");
        jDialog.show();
         */
        int selectionCount = jTree.getSelectionCount();
        int[] selectedRows;
        //boolean hasSelection = false;
        
        //String driver = "org.postgresql.Driver";
        //String url = "jdbc:postgresql://192.168.168.235:5432/testdb2";
        //String user = "postgres";
        //String password = "pg.test";
        //String dataTypeMapper = "PostgreSQLDataTypeMapper";             // PostgreSQL-to-Java DataType mapping.
        
        /*
        DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
        ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
        String username = serverNodeObject.getUsername();
        String password = serverNodeObject.getPassword();
        // shortern the number of variables
        //String serverIP = serverNodeObject.getServerIP();
        //String serverPort = serverNodeObject.getServerPort();
        String urlPrefix = dbProtocol + serverNodeObject.getServerIP() + ":" + serverNodeObject.getServerPort() + "/";
         */
        
        //--------------------------------------------------------------------
        // node actions
        if(selectionCount != 0)
        {
            selectedRows = jTree.getSelectionRows();
            TreePath[] treePath = jTree.getSelectionPaths();
            //hasSelection = true;
            Object[] selectedNodes = new Object[selectionCount];
            for(int i = 0; i < selectionCount; i++)
            {
                selectedNodes[i] = ((DefaultMutableTreeNode) treePath[i].getLastPathComponent()).getUserObject();
            } // for(int i = 0; i < selectionCount; i++)
            
            
            if(selectedNodes[0] instanceof ServerNodeObject)
            {
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    ;
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    ;
                } // else
            } // if(nodeObject instanceof ServerNodeObject)
            else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            {
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                if(actionName.equals(databaseNodeActionList_addAction))
                {
                    DatabaseAddPane pane = new DatabaseAddPane(serverIP, serverPort, username, password, refreshListener);
                    JDialog dialog = pane.createDialog(getParentFromPopupComponent(component), "Add Database");
                    //dialog.setVisible(true);
                    dialog.show();
                } // if(actionName.equals(databaseNodeActionList_addAction))
            } // else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            else if(selectedNodes[0] instanceof DatabaseNodeObject)
            {
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                String dbName = ((DatabaseNodeObject) selectedNodes[0]).getObjectName();    // applies only for DatabaseNodeObject, but not for DatabaseListNodeObject.
                
                String url = urlPrefix + dbName;
                
                
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    if(actionName.equals(databaseNodeActionList_executeSQLQuery))
                    {
                        InteractiveSQL theApp = new InteractiveSQL(defaultDriver, url, username, password);
                    } // if(actionName.equals(databaseNodeActionList_executeSQLQuery))
                    else if(actionName.equals(databaseNodeActionList_addAction))
                    {
                        DatabaseAddPane pane = new DatabaseAddPane(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, refreshListener);
                        JDialog dialog = pane.createDialog(getParentFromPopupComponent(component), "Add Database");
                        //dialog.setVisible(true);
                        dialog.show();
                    } // if(actionName.equals(databaseNodeActionList_addAction))
                    else if(actionName.equals(databaseNodeActionList_deleteAction))
                    {
                        JOptionPane optionPane = new JOptionPane();
                        int choosenOption = optionPane.showConfirmDialog(getParentFromPopupComponent(component), "Delete " + dbName + "?", "Delete Database", JOptionPane.YES_NO_CANCEL_OPTION);
                        if(choosenOption == optionPane.YES_OPTION)
                        {
                            String errorMSG = deleteDatabase(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName);
                            if(errorMSG == null)
                                return;
                            if(!errorMSG.equals(""))
                            {                
                                JOptionPane.showConfirmDialog(getParentFromPopupComponent(component), errorMSG, "msg", JOptionPane.WARNING_MESSAGE);
                            } // if(!errorMSG.equals(""))
                            else                            // we finish it if there is no errorMSG
                                refreshListener.actionPerformed(null);
                        } // if(choosenOption == optionPane.YES_OPTION)
                    } // if(actionName.equals(databaseNodeActionList_addAction))
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    ;
                } // else
            } // else if(nodeObject instanceof DatabaseNodeObject)
            else if(selectedNodes[0] instanceof TableListNodeObject)
            {
                //System.out.println("TableNodeObject");                
                DefaultMutableTreeNode tableListNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode) tableListNode.getParent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                
                //------------------------------------------------------------
                // needs customization
                String dbName = ((DatabaseNodeObject) databaseNode.getUserObject()).getObjectName();    // applies only for TableNodeObject
                //------------------------------------------------------------
                
                String url = urlPrefix + dbName;
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    if(actionName.equals(tableListNodeActionList_addAction))
                    {
                        TableAddFrame jFrame = new TableAddFrame(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, refreshListener);
                    } // if(actionName.equals(databaseNodeActionList_addAction))                    
                } // else if(selectedNodes[0] instanceof TableNodeObject)
                // More than one node sslected
                else
                {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof TableListNodeObject)
            else if(selectedNodes[0] instanceof TableNodeObject)
            {
                //System.out.println("TableNodeObject");                
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode tableListNode = (DefaultMutableTreeNode) tableNode.getParent();
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode) tableListNode.getParent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                
                //------------------------------------------------------------
                // needs customization
                String tableName = ((TableNodeObject) tableNode.getUserObject()).getObjectName();    // applies only for TableNodeObject
                String dbName = ((DatabaseNodeObject) databaseNode.getUserObject()).getObjectName();    // applies only for TableNodeObject
                //------------------------------------------------------------
                
                String url = urlPrefix + dbName;
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    if(actionName.equals(tableNodeActionList_addAction))
                    {
                        TableAddFrame jFrame = new TableAddFrame(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, refreshListener);
                    } // if(actionName.equals(databaseNodeActionList_addAction))
                    else if(actionName.equals(tableNodeActionList_renameAction))
                    {
                        String newTableName = JOptionPane.showInputDialog(getParentFromPopupComponent(component), "Enter a new name for the table:", "Rename Table", JOptionPane.PLAIN_MESSAGE);
                        // If name is nothing or "" we exit.
                        if(newTableName == null)                   // handle cancel, which which produce a null;
                            return;
                        if(newTableName.equals(""))
                        {
                            JOptionPane.showConfirmDialog(getParentFromPopupComponent(component), "New name not entered", "msg", JOptionPane.WARNING_MESSAGE);
                           return;
                        } // if(tableName.equals(""))
                        
                        String errorMSG = renameTable(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, tableName, newTableName);
                        if(errorMSG == null)
                            return;
                        if(!errorMSG.equals(""))
                        {                
                            JOptionPane.showConfirmDialog(getParentFromPopupComponent(component), errorMSG, "msg", JOptionPane.WARNING_MESSAGE);
                        } // if(!errorMSG.equals(""))
                        else                            // we finish it if there is no errorMSG
                            refreshListener.actionPerformed(null);                        
                    } // else if(actionName.equals(tableNodeActionList_renameAction))
                    else if(actionName.equals(tableNodeActionList_deleteAction))
                    {
                        JOptionPane optionPane = new JOptionPane();
                        int choosenOption = optionPane.showConfirmDialog(getParentFromPopupComponent(component), "Delete " + tableName + "?", "Delete Table", JOptionPane.YES_NO_CANCEL_OPTION);
                        if(choosenOption == optionPane.YES_OPTION)
                        {
                            String errorMSG = deleteTable(serverNodeObject.getServerIP(), serverNodeObject.getServerPort(), username, password, dbName, tableName);
                            if(errorMSG == null)
                                return;
                            if(!errorMSG.equals(""))
                            {
                                JOptionPane.showConfirmDialog(getParentFromPopupComponent(component), errorMSG, "msg", JOptionPane.WARNING_MESSAGE);
                            } // if(!errorMSG.equals(""))
                            else                            // we finish it if there is no errorMSG
                                refreshListener.actionPerformed(null);
                        } // if(choosenOption == optionPane.YES_OPTION)
                    } // if(actionName.equals(databaseNodeActionList_addAction))
                    else if(actionName.equals(tableNodeActionList_viewDataAction))
                    {
                        String tableNameToExecute = "SELECT * FROM \"" + tableName + "\"";
                        InteractiveSQL theApp = new InteractiveSQL(defaultDriver, url, username, password, tableNameToExecute);
                    } // else if(actionName.equals(tableNodeActionList_viewDataAction))
                } // else if(selectedNodes[0] instanceof TableNodeObject)
                // More than one node sslected
                else
                {
                    ;
                } // else
            } // else if(selectedNodes[0] instanceof TableNodeObject)
            /*
            else if(nodeObject instanceof ViewNodeObject)
            {
                setDisabledIcon(new ImageIcon(viewNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            */
            else
            {
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    ;
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    ;
                } // else
            } // else
        } // else if(selectedNodes[0] instanceof TableNodeObject)
        else
        {
        //--------------------------------------------------------------------
        // default actions
        
            Component parent = getParentFromPopupComponent(component);
        
        
            JDialog jDialog = new JOptionPane(parent.getClass().toString(), JOptionPane.YES_NO_CANCEL_OPTION).createDialog(parent, "test");
        
        
            jDialog.show();        
        } // else
        
    } // public static void performAction(Component component, String actionName, JTree jTree, ActionListener refreshListener)
    
    public static String getNodePropertyInHTML(Component component, JTree jTree)
    {
        int selectionCount = jTree.getSelectionCount();
        int[] selectedRows;
                
        //--------------------------------------------------------------------
        // node actions
        if(selectionCount != 0)
        {
            selectedRows = jTree.getSelectionRows();
            TreePath[] treePath = jTree.getSelectionPaths();
            //hasSelection = true;
            Object[] selectedNodes = new Object[selectionCount];
            for(int i = 0; i < selectionCount; i++)
            {
                selectedNodes[i] = ((DefaultMutableTreeNode) treePath[i].getLastPathComponent()).getUserObject();
            } // for(int i = 0; i < selectionCount; i++)
            
            
            if(selectedNodes[0] instanceof ServerNodeObject)
            {
                return ""; // show a blank property screen
                // Only one node selected
                /*
                if(selectedNodes.length == 1)
                {
                    return ""; // show a blank property screen
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    return ""; // show a blank property screen
                } // else
                 */
            } // if(nodeObject instanceof ServerNodeObject)
            else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            {
                return ""; // show a blank property screen
            } // else if(selectedNodes[0] instanceof DatabaseListNodeObject)
            else if(selectedNodes[0] instanceof DatabaseNodeObject)
            {
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                String dbName = ((DatabaseNodeObject) selectedNodes[0]).getObjectName();    // applies only for DatabaseNodeObject, but not for DatabaseListNodeObject.
                
                String url = urlPrefix + dbName;
                
                
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    return getDatabasePropertyHTML(component, serverIP, serverPort, username, password, dbName);
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    return ""; // show a blank property screen
                } // else
            } // else if(nodeObject instanceof DatabaseNodeObject)
            else if(selectedNodes[0] instanceof TableListNodeObject)
            {
                return ""; // show a blank property screen
            } // else if(selectedNodes[0] instanceof TableListNodeObject)
            else if(selectedNodes[0] instanceof TableNodeObject)
            {
                //System.out.println("TableNodeObject");                
                DefaultMutableTreeNode tableNode = (DefaultMutableTreeNode) treePath[0].getLastPathComponent();
                DefaultMutableTreeNode tableListNode = (DefaultMutableTreeNode) tableNode.getParent();
                DefaultMutableTreeNode databaseNode = (DefaultMutableTreeNode) tableListNode.getParent();
                DefaultMutableTreeNode databaseListNode = (DefaultMutableTreeNode) databaseNode.getParent();
                DefaultMutableTreeNode tempNode = (DefaultMutableTreeNode) databaseListNode.getParent();
                ServerNodeObject serverNodeObject = (ServerNodeObject) tempNode.getUserObject();
                
                //------------------------------------------------------------
                // standard variables
                String serverIP = serverNodeObject.getServerIP();
                String serverPort = serverNodeObject.getServerPort();
                String username = serverNodeObject.getUsername();
                String password = serverNodeObject.getPassword();
                //------------------------------------------------------------
                
                String urlPrefix = dbProtocol + serverIP + ":" + serverPort + "/";
                
                //------------------------------------------------------------
                // needs customization
                String tableName = ((TableNodeObject) tableNode.getUserObject()).getObjectName();    // applies only for TableNodeObject
                String dbName = ((DatabaseNodeObject) databaseNode.getUserObject()).getObjectName();    // applies only for TableNodeObject
                //------------------------------------------------------------
                
                String url = urlPrefix + dbName;
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    return getTablePropertyHTML(component, serverIP, serverPort, username, password, dbName, tableName);
                } // else if(selectedNodes[0] instanceof TableNodeObject)
                // More than one node sslected
                else
                {
                    return ""; // show a blank property screen
                } // else
            } // else if(selectedNodes[0] instanceof TableNodeObject)
            /*
            else if(nodeObject instanceof ViewNodeObject)
            {
                setDisabledIcon(new ImageIcon(viewNodeImageURL));
            } // else if(nodeObject instanceof DatabaseNodeObject)
            */
            else
            {
                return ""; // show a blank property screen
                /*
                // Only one node selected
                if(selectedNodes.length == 1)
                {
                    ;
                } // if(selectedNodes.length == 1)
                // More than one node sslected
                else
                {
                    ;
                } // else
                 */
            } // else
        } // else if(selectedNodes[0] instanceof TableNodeObject)
        else
        {
        //--------------------------------------------------------------------
        // default actions
            return ""; // show a blank property screen
            //return null;
        } // else
        
        //return null;            // should not reach here unless something goes wrong
    } // public static String getNodePropertyInHTML(Component component, JTree jTree)
    
    public static String getDatabasePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";        // connect to the default db
        String sqlQueryStr = SQL_GET_DATABASES + " WHERE datname = '" + dbName + "'";
        boolean hasError = false;
        
        String sqlError = "";
        String htmlStr = "";
        
        String dbNameLabel = "Database Name";
        String dbOwnerLabel = "Database Owner";
        String dbEncodingLabel = "Database Encoding";
        
        //String dbName = "";
        String dbOwner = "";
        String dbEncoding = "";
               
        //System.out.println(sqlQueryStr);
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        ResultSet rs;
        
        try
        {
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlQueryStr);
            
            rs.next();
            //dbName = rs.getString("datname");
            dbOwner = rs.getString("datowner");
            dbEncoding = rs.getString("serverencoding");
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
            hasError = true;
        } // catch(SQLException sqle)
        
        if(hasError)
        {
            JOptionPane.showConfirmDialog(component, sqlError, "msg", JOptionPane.WARNING_MESSAGE);
            return ""; // show blank screen
        } // if(hasError)
        else
        {
            //htmlStr = dbName + " " + dbOwner + " " + dbEncoding;
            
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbNameLabel + "</font>: " + dbName + "<br>";
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbOwnerLabel + "</font>: " + dbOwner + "<br>";
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + dbEncodingLabel + "</font>: " + dbEncoding + "<br>";
            return htmlStr;
        } // else
        
        //return htmlStr;
    } // public static String getDatabasePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName)
    
    public static String getTablePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName, String tableName)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;
        String sqlQueryStr = SQL_GET_TABLES7_2 + " AND relname = '" + tableName + "'";
        String sqlQueryStr2 = "SELECT COUNT(*) FROM \"" + tableName + "\"";
        boolean hasError = false;
        
        String sqlError = "";
        String htmlStr = "";
        
        String tableNameLabel = "Table Name";
        String tableOwnerLabel = "Table Owner";
        String tableRowCountLabel = "rows";
        
        //String dbName = "";
        String tableOwner = "";
        int tableRowCount = 0;
               
        //System.out.println(sqlQueryStr);
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        ResultSet rs;
        
        try
        {
            statement = conn.createStatement();
            rs = statement.executeQuery(sqlQueryStr);
            
            rs.next();
            //dbName = rs.getString("datname");
            tableOwner = rs.getString("tableowner");
            //dbEncoding = rs.getString("serverencoding");
            
            rs = statement.executeQuery(sqlQueryStr2);
            rs.next();
            tableRowCount = rs.getInt(1);
            
            conn.close();
            
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
            hasError = true;
        } // catch(SQLException sqle)
        
        if(hasError)
        {
            JOptionPane.showConfirmDialog(component, sqlError, "msg", JOptionPane.WARNING_MESSAGE);
            return ""; // show blank screen
        } // if(hasError)
        else
        {
            //htmlStr = dbName + " " + dbOwner + " " + dbEncoding;
            
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableNameLabel + "</font>: " + tableName + "<br>";
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableOwnerLabel + "</font>: " + tableOwner + "<br>";
            htmlStr = htmlStr + "<font color=" + htmlOrange + ">" + tableRowCountLabel + "</font>: " + tableRowCount + "<br>";
            return htmlStr;
        } // else
        
        //return htmlStr;
    } // public static String getDatabasePropertyHTML(Component component, String serverIP, String serverPort, String username, String password, String dbName)
    
    public static Component getParentFromPopupComponent(Component popupComponent)
    {
        Component component_ptr = popupComponent;
        JPopupMenu jPopupMenu;
        
        // to get get the parent frame
        while(component_ptr.getParent() != null)
        {
            component_ptr = (Component) component_ptr.getParent();
            //if(component_ptr instanceof JPopupMenu)
               //break;
        } // while(component_ptr.getParent() != null)
        
        
        jPopupMenu = (JPopupMenu) component_ptr;
        component_ptr = (Component) jPopupMenu.getInvoker();
        
        
        while(component_ptr.getParent() != null)
        {
            component_ptr = (Component) component_ptr.getParent();
            //if(component_ptr instanceof JComponent)
               // break;
        } // while(component_ptr.getParent() != null)
        
        return component_ptr;
    } // public static Component getParentFromPopupComponent(Component popupComponent)
    
//---------------------------------------------------------------------------
// database manipulation methods
    
    // Note: the method is specific only to postgreSQL
    public static String createDatabase(String serverIP, String serverPort, String username, String password, String dbName, String dbEncoding, boolean revisionControl, String comments)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";        // connect to the default db
        String sqlQueryStr = "CREATE DATABASE \"" + dbName + "\" WITH ENCODING = '" + dbEncoding + "'";
        String sqlError = "";
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        
        try
        {
            statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        } // catch(SQLException sqle)
        
        return sqlError;
    } // public static void createDatabase()
    
    public static String deleteDatabase(String serverIP, String serverPort, String username, String password, String dbName)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/template1";        // connect to the default db
        String sqlQueryStr = "DROP DATABASE \"" + dbName + "\"";
        String sqlError = "";
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        
        try
        {
            statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        } // catch(SQLException sqle)
        
        return sqlError;
    } // public static String deleteDatabase(String serverIP, String serverPort, String username, String password, String dbName)
    
    public static String createTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, boolean[] relationalColumnPrimaryKeys, String[] relationalColumnNames, String[] relationalColumnTypes, Integer[] relationalColumnLengths, boolean[] relationalColumnAllowNullsArray, String[] relationalColumnDefaultValues, String[] relationalColumnComments, Integer[] relationalColumnNumericPrecisions)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;        // connect to the default db
        String sqlQueryStr = "CREATE TABLE \"" + tableName + "\"";
        String sqlError = "";       // This will indicate that there is no error
        String columnsStr = "";
        String commentsStr = "";
        String pKeyStr = "";
        int commentCount = 0;
        int pKeyCount = 0;
        
        for(int i = 0; i < relationalColumnNames.length; i++)
        {
            if(i == 0)
            {
                columnsStr = relationalColumnNames[i];
                                
            } // if(i == 0)
            else
            {
                columnsStr = columnsStr + ", " + relationalColumnNames[i];
            } // else
            
            /*
          // should be check else where
          if(relationalColumnTypes[i] != null)
          {
                columns
           } // if(relationalColumnTypes[i] != null)
           */
            
            columnsStr = columnsStr + " " + relationalColumnTypes[i];
                
            // handle datatypes which has
            if(relationalColumnLengths[i] != null)
            {
                if(relationalColumnNumericPrecisions[i] != null)
                {
                    columnsStr = columnsStr + "(" + relationalColumnLengths[i] + ", " + relationalColumnNumericPrecisions[i] + ")";
                } // if(relationalColumnPrecision[i] != null)
                else
                {
                    columnsStr = columnsStr + "(" + relationalColumnLengths[i] + ")";
                } // else
            } // if(relationalColumnLengths[i] != null)
            
            // add default valurs
            if(relationalColumnDefaultValues[i] != null)
            {
                if(!relationalColumnDefaultValues[i].equals(""))    // We do not treat zero-length string as a default value
                    columnsStr = columnsStr + " DEFAULT " + relationalColumnDefaultValues[i];
            } // if(relationalColumnDefaultValues[i] != null)
            
            if(!relationalColumnAllowNullsArray[i])
            {
                columnsStr = columnsStr + " NOT NULL";
            } // if(!relationalColumnAllowNullsArray[i])
            
            if(relationalColumnComments[i] != null)
            {
                if(relationalColumnComments[i].length() != 0)
                {
                    if(commentCount++ == 0)             // increment after evaluation
                    {
                        commentsStr = "COMMENT ON COLUMN \"" + tableName + "\".\"" + relationalColumnNames[i] + "\" IS '" + relationalColumnComments[i] + "'";
                    } // if(commentCount == 0)
                    else
                    {
                        commentsStr = commentsStr + "; COMMENT ON COLUMN \"" + tableName + "\".\"" + relationalColumnNames[i] + "\" IS '" + relationalColumnComments[i] + "'";
                    } // else
                } // if(relationalColumnComments[i].length() != 0)
            } // if(relationalColumnComments[i] != null)
            
            if(relationalColumnPrimaryKeys[i])
            {
                if(pKeyCount++ == 0)             // increment after evaluation
                {
                    pKeyStr = "\"" + relationalColumnNames[i] + "\"";
                } // if(commentCount == 0)
                else
                {
                    pKeyStr = pKeyStr + ", \"" + relationalColumnNames[i] + "\"";
                } // else                
            } // if(relationalColumnPrimaryKeys[i])
            
        } // for(int i = 0; i < relationalColumnNames.length; i++)
        
        if(pKeyCount != 0)
        {
            pKeyStr = "CONSTRAINT \"" + tableName + "_pkey\" PRIMARY KEY(" + pKeyStr + ")";
        } // if(pKeyCount != 0)
        
        //sqlQueryStr = sqlQueryStr + " (" + columnsStr + ", " + pKeyStr + ") WITHOUT OIDS";       // no OIDS for rows in the table
        sqlQueryStr = sqlQueryStr + " (" + columnsStr;
        if(pKeyCount != 0)
            sqlQueryStr = sqlQueryStr + ", " + pKeyStr;        
        sqlQueryStr = sqlQueryStr + ") WITHOUT OIDS";       // no OIDS for rows in the table
        
        if(commentCount != 0)
        {
            sqlQueryStr = sqlQueryStr + "; " + commentsStr;
        } // if(commentCount != 0)
        
        //System.out.println(sqlQueryStr);
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        
        try
        {
            statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        } // catch(SQLException sqle)
        
        return sqlError;
    } // public static String createTable(boolean[] relationalColumnPrimaryKeys, String[] relationalColumnNames, String[] relationalColumnTypes, Integer[] relationalColumnLengths, boolean[] relationalColumnAllowNullsArray)
    
    public static String deleteTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;        // connect to the default db
        String sqlQueryStr = "DROP TABLE \"" + tableName + "\"";
        String sqlError = "";
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        
        try
        {
            statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        } // catch(SQLException sqle)
        
        return sqlError;
    } // public static String deleteTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName)
    
    public static String renameTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, String newTableName)
    {
        String url = dbProtocol + serverIP + ":" + serverPort + "/" + dbName;        // connect to the default db
        String sqlQueryStr = "ALTER TABLE \"" + tableName + "\" RENAME TO \"" + newTableName + "\"";
        String sqlError = "";
        
        Connection conn = getConnection(url, username, password);
        
        Statement statement;
        
        try
        {
            statement = conn.createStatement();
            statement.executeUpdate(sqlQueryStr);
            
            conn.close();
        } // try
        catch(SQLException sqle)
        {
            System.out.print(sqle.getMessage());
            sqlError = sqle.getMessage();
        } // catch(SQLException sqle)
        
        return sqlError;
    } // public static String renameTable(String serverIP, String serverPort, String username, String password, String dbName, String tableName, String newTableName)
    
//---------------------------------------------------------------------------    
    
} // public class PostgreSQLDataObject implements DatabaseDataObjectAbstract
