/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.ide;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jp.turbosql.modules.sketcher.ide.ResultsModel;

class DatabaseBrowse
extends JInternalFrame
implements ActionListener,
TreeSelectionListener {
    private String userID = "postgres";
    private String password = "pg.test";
    private String url = "jdbc:postgresql://192.168.168.235:5432/testdb";
    private JTextField database = new JTextField(this.url);
    private JTextField userIDInput = new JTextField(this.userID);
    private JPasswordField passwordInput = new JPasswordField(this.password);
    private JTextArea status = new JTextArea(3, 30);
    private DefaultMutableTreeNode dbNode;
    private DefaultTreeModel dbTreeModel;
    private JTree dbTree;
    private JScrollPane treePane;
    ResultsModel tableModel;
    private JTable table;
    JScrollPane tablePane;
    private JScrollPane statusPane;
    private String[] drivers = new String[]{"org.postgresql.Driver"};
    Connection connection;
    Statement statement;

    public DatabaseBrowse() {
        super("Database Browser", true, true, true, true);
        this.setBounds(0, 0, 400, 300);
        this.setDefaultCloseOperation(2);
        JLabel dbURLLabel = new JLabel("Database URL: ");
        JLabel userIDLabel = new JLabel("User ID:", 4);
        userIDLabel.setPreferredSize(dbURLLabel.getPreferredSize());
        JLabel passwordLabel = new JLabel("Password: ");
        Box dbPane = Box.createHorizontalBox();
        dbPane.add(dbURLLabel);
        dbPane.add(this.database);
        Box loginPane = Box.createHorizontalBox();
        loginPane.add(userIDLabel);
        loginPane.add(this.userIDInput);
        loginPane.add(passwordLabel);
        loginPane.add(this.passwordInput);
        Box inputPane = Box.createVerticalBox();
        inputPane.add(dbPane);
        inputPane.add(loginPane);
        this.getContentPane().add((Component)inputPane, "North");
        this.status.setText("Enter a database URL and/or press Enter");
        this.status.setEditable(false);
        this.status.setLineWrap(true);
        this.status.setWrapStyleWord(true);
        this.status.setBorder(BorderFactory.createBevelBorder(1));
        this.statusPane = new JScrollPane(this.status);
        this.statusPane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.getContentPane().add((Component)this.statusPane, "South");
        this.dbNode = new DefaultMutableTreeNode("No database");
        this.dbTreeModel = new DefaultTreeModel(this.dbNode);
        this.dbTree = new JTree(this.dbTreeModel);
        this.treePane = new JScrollPane(this.dbTree);
        this.treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.tableModel = new ResultsModel();
        JTable table = new JTable(this.tableModel);
        table.setPreferredSize(new Dimension(800, 400));
        table.setAutoResizeMode(0);
        this.tablePane = new JScrollPane(table);
        this.tablePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        JSplitPane splitpane = new JSplitPane(1, true, this.treePane, this.tablePane);
        this.getContentPane().add((Component)splitpane, "Center");
        splitpane.setDividerLocation(150);
        this.database.addActionListener(this);
        this.userIDInput.addActionListener(this);
        this.passwordInput.addActionListener(this);
        this.dbTree.addTreeSelectionListener(this);
        this.pack();
        this.setVisible(true);
        this.show();
        this.database.requestFocus();
        int i = 0;
        while (i < this.drivers.length) {
            try {
                Class.forName(this.drivers[i]);
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println(cnfe);
                this.status.setText("Driver load failed: " + cnfe.getMessage());
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        DatabaseBrowse databaseBrowse = new DatabaseBrowse();
    }

    public void openConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
                this.tableModel.setResultSet(null);
                this.tablePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                this.dbNode = new DefaultMutableTreeNode("No database");
                this.dbTreeModel.setRoot(this.dbNode);
                this.dbTree.setRootVisible(true);
                this.treePane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
                this.dbTreeModel.reload();
            }
            this.connection = DriverManager.getConnection(this.url, this.userID, this.password);
            this.status.setText("Database connection established");
            this.statement = this.connection.createStatement();
            this.dbNode = new DefaultMutableTreeNode(this.url);
            this.dbTreeModel.setRoot(this.dbNode);
            this.setupTree(this.connection.getMetaData());
            this.treePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), this.url, 2, 0));
            this.dbTree.setRootVisible(false);
            this.dbTreeModel.reload();
        }
        catch (SQLException sqle) {
            this.status.setText(sqle.getMessage());
            do {
                System.err.println("Exception occured:\nMessage: " + sqle.getMessage());
                System.err.println("SQL state: " + sqle.getSQLState());
                System.err.println("Vendor code: " + sqle.getErrorCode() + "\n----------------------------");
            } while ((sqle = sqle.getNextException()) != null);
        }
    }

    private void setupTree(DatabaseMetaData metadata) throws SQLException {
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet tables = metadata.getTables(null, null, null, tableTypes);
        while (tables.next()) {
            String tableName = tables.getString("TABLE_NAME");
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(tableName);
            this.dbNode.add(tableNode);
            ResultSet columnNames = metadata.getColumns(null, null, tableName, null);
            while (columnNames.next()) {
                tableNode.add(new DefaultMutableTreeNode(columnNames.getString("COLUMN_NAME")));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.database || source == this.userIDInput || source == this.passwordInput) {
            this.url = this.database.getText();
            this.userID = this.userIDInput.getText();
            char[] pw = this.passwordInput.getPassword();
            if (pw != null) {
                this.password = new String(pw);
            }
            if (this.url == null || this.url.length() == 0) {
                this.status.setText("Please specify a database URL ");
                return;
            }
            this.openConnection();
            this.password = null;
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.dbTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        boolean tableSelected = false;
        String columnsParam = null;
        String tableParam = null;
        String message = null;
        int j = 0;
        while (j < paths.length) {
            switch (paths[j].getPathCount()) {
                case 2: {
                    tableParam = (String)((DefaultMutableTreeNode)paths[j].getPathComponent(1)).getUserObject();
                    columnsParam = "*";
                    tableSelected = true;
                    message = "Complete " + tableParam + " table displayed";
                    break;
                }
                case 3: {
                    String table = (String)((DefaultMutableTreeNode)paths[j].getPathComponent(1)).getUserObject();
                    if (tableParam == null) {
                        tableParam = table;
                    } else if (tableParam != table) break;
                    String column = (String)((DefaultMutableTreeNode)paths[j].getPathComponent(2)).getUserObject();
                    columnsParam = columnsParam == null ? column : columnsParam + "," + column;
                    message = columnsParam + " displayed from " + tableParam + " table.";
                }
            }
            if (tableSelected) break;
            ++j;
        }
        try {
            this.tableModel.setResultSet(this.statement.executeQuery("SELECT " + columnsParam + " FROM " + tableParam));
            this.tablePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.darkGray), tableParam, 2, 0));
        }
        catch (SQLException sqle) {
            message = "Selection event Error\n" + sqle.getMessage();
            System.err.println(message);
        }
        if (message != null) {
            this.status.setText(message);
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            DatabaseBrowse.this.dispose();
            System.exit(0);
        }
    }
}

