/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jp.turbosql.modules.sketcher.app.Constants;

class StatusBar
extends JPanel
implements Constants {
    private StatusPane colorPane = new StatusPane("BLUE");
    private StatusPane typePane = new StatusPane("LINE");

    public StatusBar() {
        this.setLayout(new FlowLayout(0, 10, 3));
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.setColorPane(Constants.DEFAULT_ELEMENT_COLOR);
        this.setTypePane(101);
        this.add(this.colorPane);
        this.add(this.typePane);
    }

    public void setColorPane(Color color) {
        String text = color.equals(Color.red) ? "RED" : (color.equals(Color.yellow) ? "YELLOW" : (color.equals(Color.green) ? "GREEN" : (color.equals(Color.blue) ? "BLUE" : "CUSTOM COLOR")));
        this.colorPane.setForeground(color);
        this.colorPane.setText(text);
    }

    public void setTypePane(int elementType) {
        String text;
        switch (elementType) {
            case 101: {
                text = "LINE";
                break;
            }
            case 102: {
                text = "RECTANGLE";
                break;
            }
            case 103: {
                text = "CIRCLE";
                break;
            }
            case 104: {
                text = "CURVE";
                break;
            }
            case 105: {
                text = "TEXT";
                break;
            }
            default: {
                text = "ERROR";
            }
        }
        this.typePane.setText(text);
    }

    class StatusPane
    extends JLabel {
        private Font paneFont = new Font("Serif", 0, 10);

        public StatusPane(String text) {
            this.setBackground(Color.lightGray);
            this.setForeground(Color.black);
            this.setFont(this.paneFont);
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createBevelBorder(1));
            this.setPreferredSize(new Dimension(100, 20));
            this.setText(text);
        }
    }
}

