/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jp.turbosql.modules.sketcher.app.Constants;
import jp.turbosql.modules.sketcher.app.ExtensionFilter;
import jp.turbosql.modules.sketcher.app.FontDialog;
import jp.turbosql.modules.sketcher.app.SketchModel;
import jp.turbosql.modules.sketcher.app.Sketcher;
import jp.turbosql.modules.sketcher.app.StatusBar;

public class SketchFrame2
extends JInternalFrame
implements Constants,
ActionListener,
Observer {
    private String p_path = "/root/java/sketcher/";
    private JMenuBar menuBar = new JMenuBar();
    private Color elementColor = Constants.DEFAULT_ELEMENT_COLOR;
    private int elementType = 101;
    private Font font = Constants.DEFAULT_FONT;
    private FileAction newAction;
    private FileAction openAction;
    private FileAction closeAction;
    private FileAction saveAction;
    private FileAction saveAsAction;
    private FileAction printAction;
    private TypeAction lineAction;
    private TypeAction rectangleAction;
    private TypeAction circleAction;
    private TypeAction curveAction;
    private TypeAction textAction;
    private ColorAction redAction;
    private ColorAction yellowAction;
    private ColorAction greenAction;
    private ColorAction blueAction;
    private JToolBar toolBar = new JToolBar();
    private Sketcher theApp;
    private StatusBar statusBar = new StatusBar();
    private JMenuItem aboutItem;
    private JMenuItem fontItem;
    private FontDialog fontDlg;
    private JPopupMenu popup = new JPopupMenu("General");
    private JMenuItem customColorItem;
    private String frameTitle;
    private String filename = "Sketch.ske";
    private File modelFile;
    private boolean sketchChanged = false;
    private JFileChooser files;

    public SketchFrame2(String title, Sketcher theApp) {
        this.theApp = theApp;
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu elementMenu = new JMenu("Elements");
        JMenu optionsMenu = new JMenu("Options");
        JMenu helpMenu = new JMenu("Help");
        fileMenu.setMnemonic('F');
        elementMenu.setMnemonic('E');
        optionsMenu.setMnemonic('O');
        helpMenu.setMnemonic('H');
        this.fontDlg = new FontDialog(this);
        this.newAction = new FileAction("New", "Create new sketch");
        this.addMenuItem(fileMenu, this.newAction, KeyStroke.getKeyStroke(78, 2));
        this.openAction = new FileAction("Open", "Open existing sketch");
        this.addMenuItem(fileMenu, this.openAction, KeyStroke.getKeyStroke(79, 2));
        this.closeAction = new FileAction("Close", "Close sketch");
        this.addMenuItem(fileMenu, this.closeAction);
        fileMenu.addSeparator();
        this.saveAction = new FileAction("Save", "Save sketch");
        this.addMenuItem(fileMenu, this.saveAction, KeyStroke.getKeyStroke(83, 2));
        this.saveAsAction = new FileAction("Save As...", "Save as new file");
        this.addMenuItem(fileMenu, this.saveAsAction);
        fileMenu.addSeparator();
        this.printAction = new FileAction("Print", "Print sketch");
        this.addMenuItem(fileMenu, this.printAction, KeyStroke.getKeyStroke(80, 2));
        fileMenu.addSeparator();
        this.closeAction = new FileAction("Exit", "Exit Sketcher");
        this.addMenuItem(fileMenu, this.closeAction, KeyStroke.getKeyStroke(88, 2));
        this.lineAction = new TypeAction("Line", 101, "Draw lines");
        this.addMenuItem(elementMenu, this.lineAction);
        this.rectangleAction = new TypeAction("Rectangle", 102, "Draw rectangle");
        this.addMenuItem(elementMenu, this.rectangleAction);
        this.circleAction = new TypeAction("Circle", 103, "Draw circle");
        this.addMenuItem(elementMenu, this.circleAction);
        this.curveAction = new TypeAction("Curve", 104, "Draw curves");
        this.addMenuItem(elementMenu, this.curveAction);
        this.textAction = new TypeAction("Text", 105, "Draw text");
        this.addMenuItem(elementMenu, this.textAction, null);
        elementMenu.addSeparator();
        JMenu colorMenu = new JMenu("Color");
        elementMenu.add(colorMenu);
        this.redAction = new ColorAction("Red", Color.red, "Draw in red");
        this.addMenuItem(colorMenu, this.redAction);
        this.yellowAction = new ColorAction("Yellow", Color.yellow, "Draw in yellow");
        this.addMenuItem(colorMenu, this.yellowAction);
        this.greenAction = new ColorAction("Green", Color.green, "Draw in green");
        this.addMenuItem(colorMenu, this.greenAction);
        this.blueAction = new ColorAction("Blue", Color.blue, "Draw in blue");
        this.addMenuItem(colorMenu, this.blueAction);
        this.menuBar.add(fileMenu);
        this.menuBar.add(elementMenu);
        this.toolBar.addSeparator();
        this.addToolBarButton(this.newAction);
        this.addToolBarButton(this.openAction);
        this.addToolBarButton(this.saveAction);
        this.addToolBarButton(this.printAction);
        this.toolBar.addSeparator();
        this.addToolBarButton(this.lineAction);
        this.addToolBarButton(this.rectangleAction);
        this.addToolBarButton(this.circleAction);
        this.addToolBarButton(this.curveAction);
        this.addToolBarButton(this.textAction);
        this.toolBar.addSeparator();
        this.addToolBarButton(this.redAction);
        this.addToolBarButton(this.yellowAction);
        this.addToolBarButton(this.greenAction);
        this.addToolBarButton(this.blueAction);
        this.toolBar.addSeparator();
        this.toolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.darkGray), BorderFactory.createEmptyBorder(2, 2, 4, 4)));
        this.toolBar.setFloatable(false);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.fontItem = new JMenuItem("Choose font...");
        this.fontItem.addActionListener(this);
        optionsMenu.add(this.fontItem);
        this.menuBar.add(optionsMenu);
        this.aboutItem = new JMenuItem("About");
        this.aboutItem.addActionListener(this);
        helpMenu.add(this.aboutItem);
        this.menuBar.add(helpMenu);
        this.popup.add(this.lineAction);
        this.popup.add(this.rectangleAction);
        this.popup.add(this.circleAction);
        this.popup.add(this.curveAction);
        this.popup.add(this.textAction);
        this.popup.addSeparator();
        this.popup.add(this.redAction);
        this.popup.add(this.yellowAction);
        this.popup.add(this.greenAction);
        this.popup.add(this.blueAction);
        this.customColorItem = this.popup.add("Custom Color...");
        this.customColorItem.addActionListener(this);
        this.getContentPane().add((Component)this.statusBar, "South");
        this.frameTitle = title + ": ";
        this.setTitle(this.frameTitle + this.filename);
        if (!Constants.DEFAULT_DIRECTORY.exists() && !Constants.DEFAULT_DIRECTORY.mkdirs()) {
            JOptionPane.showMessageDialog(this, "Error creating default directory", "Directory Creation Error", 0);
        }
        this.files = new JFileChooser(Constants.DEFAULT_DIRECTORY);
    }

    private JButton addToolBarButton(Action action) {
        JButton button = this.toolBar.add(action);
        button.setToolTipText((String)action.getValue("ShortDescription"));
        button.setBorder(BorderFactory.createRaisedBevelBorder());
        button.setText(null);
        return button;
    }

    private JMenuItem addMenuItem(JMenu menu, Action action) {
        JMenuItem item = menu.add(action);
        item.setIcon(null);
        return item;
    }

    private JMenuItem addMenuItem(JMenu menu, Action action, KeyStroke keystroke) {
        JMenuItem item = this.addMenuItem(menu, action);
        item.setAccelerator(keystroke);
        return item;
    }

    public Color getElementColor() {
        return this.elementColor;
    }

    public int getElementType() {
        return this.elementType;
    }

    public Font getCurrentFont() {
        return this.font;
    }

    public void setCurrentFont(Font font) {
        this.font = font;
    }

    public JPopupMenu getPopup() {
        return this.popup;
    }

    private File showDialog(String dialogTitle, String approveButtonText, String approveButtonTooltip, char approveButtonMnemonic, File file) {
        this.files.setDialogTitle(dialogTitle);
        this.files.setApproveButtonText(approveButtonText);
        this.files.setApproveButtonToolTipText(approveButtonTooltip);
        this.files.setApproveButtonMnemonic(approveButtonMnemonic);
        this.files.setFileSelectionMode(0);
        this.files.rescanCurrentDirectory();
        this.files.setSelectedFile(file);
        ExtensionFilter sketchFilter = new ExtensionFilter(".ske", "Sketch filse (*.ske)");
        this.files.addChoosableFileFilter(sketchFilter);
        this.files.setFileFilter(sketchFilter);
        int result = this.files.showDialog(this, null);
        return result == 0 ? this.files.getSelectedFile() : null;
    }

    private void saveOperation() {
        if (!this.sketchChanged) {
            return;
        }
        if (this.modelFile != null) {
            this.saveSketch(this.modelFile);
        } else {
            File file = this.showDialog("Save Sketch", "Save", "Save the sketch", 's', new File(this.files.getCurrentDirectory(), this.filename));
            if (file == null) {
                return;
            }
            if (file.exists() && 1 == JOptionPane.showConfirmDialog(this, file.getName() + " exists. Overwrite?", "Confirm Save As", 0, 2)) {
                return;
            }
            this.saveSketch(file);
        }
    }

    private void saveSketch(File outFile) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            out.writeObject(this.theApp.getModel());
            out.flush();
            out.close();
        }
        catch (IOException e) {
            System.out.println(e);
            JOptionPane.showMessageDialog(this, "Error writing a sketch file.", "File Output Error", 0);
            return;
        }
        if (outFile != this.modelFile) {
            this.modelFile = outFile;
            this.filename = this.modelFile.getName();
            this.setTitle(this.frameTitle + this.modelFile.getPath());
        }
        this.sketchChanged = false;
    }

    public void checkForSave() {
        if (this.sketchChanged && 0 == JOptionPane.showConfirmDialog(this, "Current file has changed. Save current file?", "Confirm Save Current File", 0, 2)) {
            this.saveOperation();
        }
    }

    public void openSketch(File inFile) {
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            this.theApp.insertModel((SketchModel)in.readObject());
            in.close();
            this.modelFile = inFile;
            this.filename = this.modelFile.getName();
            this.setTitle(this.frameTitle + this.modelFile.getPath());
            this.sketchChanged = false;
        }
        catch (Exception e) {
            System.out.println(e);
            JOptionPane.showMessageDialog(this, "Error reading a sketch file.", "File Input Error", 0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Color color;
        if (e.getSource() == this.aboutItem) {
            JOptionPane.showMessageDialog((Component)e.getSource(), "Created by \u30d4\u30c0\u30af\u30a6 2002", "About Sketcher", 1);
        } else if (e.getSource() == this.fontItem) {
            Rectangle bounds = this.getBounds();
            this.fontDlg.setLocation(bounds.x + bounds.width / 3, bounds.y + bounds.height / 3);
            this.fontDlg.setVisible(true);
        } else if (e.getSource() == this.customColorItem && (color = JColorChooser.showDialog(this, "Select Custom Color", this.elementColor)) != null) {
            this.elementColor = color;
            this.statusBar.setColorPane(color);
        }
    }

    public void update(Observable o, Object obj) {
        this.sketchChanged = true;
    }

    public class AboutDialog
    extends JDialog
    implements ActionListener {
        public AboutDialog(Frame parent, String title, String message) {
            super(parent, title, true);
            if (parent != null) {
                Dimension parentSize = parent.getSize();
                Point p = parent.getLocation();
                this.setLocation(p.x + parentSize.width / 4, p.y + parentSize.height / 4);
            }
            JPanel messagePane = new JPanel();
            messagePane.add(new JLabel(message));
            this.getContentPane().add(messagePane);
            JPanel buttonPane = new JPanel();
            JButton button = new JButton("OK");
            buttonPane.add(button);
            button.addActionListener(this);
            this.getContentPane().add((Component)buttonPane, "South");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setVisible(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            this.dispose();
        }
    }

    class ColorAction
    extends AbstractAction {
        private Color color;

        public ColorAction(String name, Color color) {
            super(name);
            this.color = color;
            String iconFileName = SketchFrame2.this.p_path + "images/gem.gif";
            if (new File(iconFileName).exists()) {
                this.putValue("SmallIcon", new ImageIcon(iconFileName));
            }
        }

        public ColorAction(String name, Color color, String tooltip) {
            this(name, color);
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SketchFrame2.this.elementColor = this.color;
            SketchFrame2.this.statusBar.setColorPane(this.color);
        }
    }

    class TypeAction
    extends AbstractAction {
        private int typeID;

        TypeAction(String name, int typeID) {
            super(name);
            this.typeID = typeID;
            String iconFileName = SketchFrame2.this.p_path + "images/g_greenon.gif";
            if (new File(iconFileName).exists()) {
                this.putValue("SmallIcon", new ImageIcon(iconFileName));
            }
        }

        TypeAction(String name, int typeID, String tooltip) {
            this(name, typeID);
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SketchFrame2.this.elementType = this.typeID;
            SketchFrame2.this.statusBar.setTypePane(this.typeID);
        }
    }

    class FileAction
    extends AbstractAction {
        FileAction(String name) {
            super(name);
            String iconFileName = SketchFrame2.this.p_path + "images/open.gif";
            if (new File(iconFileName).exists()) {
                this.putValue("SmallIcon", new ImageIcon(iconFileName));
            }
        }

        FileAction(String name, String tooltip) {
            this(name);
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String name = (String)this.getValue("Name");
            if (name.equals(SketchFrame2.this.saveAction.getValue("Name"))) {
                SketchFrame2.this.saveOperation();
            } else {
                if (name.equals(SketchFrame2.this.saveAsAction.getValue("Name"))) {
                    File file = SketchFrame2.this.showDialog("Save Sketch As", "Save", "Save the sketch", 's', SketchFrame2.this.modelFile == null ? new File(SketchFrame2.this.files.getCurrentDirectory(), SketchFrame2.this.filename) : SketchFrame2.this.modelFile);
                    if (file != null) {
                        if (file.exists() && !file.equals(SketchFrame2.this.modelFile) && 1 == JOptionPane.showConfirmDialog(SketchFrame2.this, file.getName() + " exists. Overwrite?", "Confirm Save As", 0, 2)) {
                            return;
                        }
                        SketchFrame2.this.saveSketch(file);
                    }
                    return;
                }
                if (name.equals(SketchFrame2.this.openAction.getValue("Name"))) {
                    SketchFrame2.this.checkForSave();
                    File file = SketchFrame2.this.showDialog("Open Sketch File", "Open", "Read a sketch from file", 'o', null);
                    if (file != null) {
                        SketchFrame2.this.openSketch(file);
                    }
                } else if (name.equals(SketchFrame2.this.newAction.getValue("Name"))) {
                    SketchFrame2.this.checkForSave();
                    SketchFrame2.this.theApp.insertModel(new SketchModel());
                    SketchFrame2.this.modelFile = null;
                    SketchFrame2.this.filename = "Sketch.ske";
                    SketchFrame2.this.setTitle(SketchFrame2.this.frameTitle + SketchFrame2.this.files.getCurrentDirectory() + "\\" + SketchFrame2.this.filename);
                    SketchFrame2.this.sketchChanged = false;
                } else if (!name.equals(SketchFrame2.this.printAction.getValue("Name")) && name.equals(SketchFrame2.this.closeAction.getValue("Name"))) {
                    SketchFrame2.this.checkForSave();
                    System.exit(0);
                }
            }
        }
    }
}

