/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.sketcher.app;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public abstract class Element
implements Serializable {
    protected Color color;
    protected boolean highlighted = false;
    static final Point origin = new Point();
    protected Point position;
    protected double angle = 0.0;

    public abstract java.awt.Rectangle getBounds();

    public abstract void modify(Point var1, Point var2);

    public abstract void draw(Graphics2D var1);

    public Element(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public Point getPosition() {
        return this.position;
    }

    public void rotate(double angle) {
        this.angle += angle;
    }

    protected void draw(Graphics2D g2D, Shape element) {
        g2D.setPaint(this.highlighted ? Color.magenta : this.color);
        AffineTransform old = g2D.getTransform();
        g2D.translate(this.position.x, this.position.y);
        g2D.rotate(this.angle);
        g2D.draw(element);
        g2D.setTransform(old);
    }

    protected java.awt.Rectangle getBounds(java.awt.Rectangle bounds) {
        AffineTransform at = AffineTransform.getTranslateInstance(this.position.x, this.position.y);
        at.rotate(this.angle);
        return at.createTransformedShape(bounds).getBounds();
    }

    public void move(int deltax, int deltay) {
        this.position.x += deltax;
        this.position.y += deltay;
    }

    public static class Text
    extends Element {
        private Font font;
        private String text;
        Point position;
        java.awt.Rectangle bounds = null;

        public Text(Font font, String text, Point position, Color color, java.awt.Rectangle bounds) {
            super(color);
            this.font = font;
            this.position = position;
            this.position.y -= (int)bounds.getHeight();
            this.text = text;
            this.bounds = new java.awt.Rectangle(Element.origin.x, Element.origin.y, bounds.width, bounds.height);
            ((Element)this).position = position;
        }

        public void draw(Graphics2D g2D) {
            g2D.setPaint(this.highlighted ? Color.magenta : this.color);
            Font oldFont = g2D.getFont();
            g2D.setFont(this.font);
            AffineTransform old = g2D.getTransform();
            g2D.translate(this.position.x, this.position.y);
            g2D.rotate(this.angle);
            g2D.drawString(this.text, Element.origin.x, Element.origin.y + (int)this.bounds.getHeight());
            g2D.setTransform(old);
            g2D.setFont(oldFont);
        }

        public java.awt.Rectangle getBounds() {
            return this.getBounds(this.bounds);
        }

        public void modify(Point start, Point last) {
        }
    }

    public static class Curve
    extends Element {
        private GeneralPath curve = new GeneralPath();

        public Curve(Point start, Point next, Color color) {
            super(color);
            this.position = start;
            this.curve.moveTo(Element.origin.x, Element.origin.y);
            this.curve.lineTo(next.x - this.position.x, next.y - this.position.y);
        }

        public java.awt.Rectangle getBounds() {
            return this.getBounds(this.curve.getBounds());
        }

        public Shape getShape() {
            return this.curve;
        }

        public void modify(Point start, Point next) {
            this.curve.lineTo(next.x - start.x, next.y - start.y);
        }

        public void draw(Graphics2D g2D) {
            this.draw(g2D, this.curve);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            PathIterator iterator = this.curve.getPathIterator(new AffineTransform());
            Vector<Float> coords = new Vector<Float>();
            int maxCoordCount = 6;
            float[] temp = new float[maxCoordCount];
            int result = iterator.currentSegment(temp);
            if (result != 0) {
                System.out.println("No starting moveTo");
                return;
            }
            iterator.next();
            while (!iterator.isDone()) {
                result = iterator.currentSegment(temp);
                if (result != 1) {
                    System.out.println("Invalid segment type");
                    return;
                }
                coords.add(new Float(temp[0]));
                coords.add(new Float(temp[1]));
                iterator.next();
            }
            out.writeObject(coords);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Vector coords = (Vector)in.readObject();
            this.curve = new GeneralPath();
            this.curve.moveTo(0.0f, 0.0f);
            int i = 0;
            while (i < coords.size()) {
                float x = ((Float)coords.get(i)).floatValue();
                float y = ((Float)coords.get(i + 1)).floatValue();
                this.curve.lineTo(x, y);
                i += 2;
            }
        }
    }

    public static class Circle
    extends Element {
        private Ellipse2D.Double circle;

        public Circle(Point center, Point circum, Color color) {
            super(color);
            double radius = center.distance(circum);
            this.position = new Point(center.x - (int)radius, center.y - (int)radius);
            this.circle = new Ellipse2D.Double(Element.origin.x, Element.origin.y, 2.0 * radius, 2.0 * radius);
        }

        public java.awt.Rectangle getBounds() {
            return this.getBounds(this.circle.getBounds());
        }

        public Shape getShape() {
            return this.circle;
        }

        public void modify(Point center, Point circum) {
            double radius = center.distance(circum);
            this.position.x = center.x - (int)radius;
            this.position.y = center.y - (int)radius;
            this.circle.width = this.circle.height = 2.0 * radius;
        }

        public void draw(Graphics2D g2D) {
            this.draw(g2D, this.circle);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeDouble(this.circle.width);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            double width = in.readDouble();
            this.circle = new Ellipse2D.Double(0.0, 0.0, width, width);
        }
    }

    public static class Rectangle
    extends Element {
        private Rectangle2D.Double rectangle;

        public Rectangle(Point start, Point end, Color color) {
            super(color);
            this.position = new Point(Math.min(start.x, end.x), Math.min(start.y, end.y));
            this.rectangle = new Rectangle2D.Double(Element.origin.x, Element.origin.y, Math.abs(start.x - end.x), Math.abs(start.y - end.y));
        }

        public java.awt.Rectangle getBounds() {
            return this.getBounds(this.rectangle.getBounds());
        }

        public Shape getShape() {
            return this.rectangle;
        }

        public void modify(Point start, Point last) {
            this.position.x = Math.min(start.x, last.x);
            this.position.y = Math.min(start.y, last.y);
            this.rectangle.width = Math.abs(start.x - last.x);
            this.rectangle.height = Math.abs(start.y - last.y);
        }

        public void draw(Graphics2D g2D) {
            this.draw(g2D, this.rectangle);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeDouble(this.rectangle.width);
            out.writeDouble(this.rectangle.height);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            double width = in.readDouble();
            double height = in.readDouble();
            this.rectangle = new Rectangle2D.Double(0.0, 0.0, width, height);
        }
    }

    public static class Line
    extends Element {
        private Line2D.Double line;

        public Line(Point start, Point end, Color color) {
            super(color);
            this.position = start;
            this.line = new Line2D.Double(origin, new Point(end.x - this.position.x, end.y - this.position.y));
        }

        public java.awt.Rectangle getBounds() {
            return this.getBounds(this.line.getBounds());
        }

        public Shape getShape() {
            return this.line;
        }

        public void modify(Point start, Point last) {
            this.line.x2 = last.x - this.position.x;
            this.line.y2 = last.y - this.position.y;
        }

        public void draw(Graphics2D g2D) {
            this.draw(g2D, this.line);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeDouble(this.line.x2);
            out.writeDouble(this.line.y2);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            double x2 = in.readDouble();
            double y2 = in.readDouble();
            this.line = new Line2D.Double(0.0, 0.0, x2, y2);
        }
    }
}

