/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.core;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import uk.org.retep.xml.core.XMLRef;

public class XMLWriter
extends PrintWriter {
    private LinkedList stateStack = new LinkedList();
    private static final String nest = "          ";
    private boolean tag;
    private boolean body;
    private String name;
    private XMLRef xref;
    private Hashtable props;

    public XMLWriter(Writer writer) {
        super(writer);
        this.init(null);
    }

    public XMLWriter(OutputStream outputStream) {
        super(outputStream);
        this.init(null);
    }

    public XMLWriter(Writer writer, boolean bl) {
        super(writer, bl);
        this.init(null);
    }

    public XMLWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
        this.init(null);
    }

    public XMLWriter(Writer writer, String string) {
        super(writer);
        this.init(string);
    }

    public XMLWriter(OutputStream outputStream, String string) {
        super(outputStream);
        this.init(string);
    }

    public XMLWriter(Writer writer, String string, boolean bl) {
        super(writer, bl);
        this.init(string);
    }

    public XMLWriter(OutputStream outputStream, String string, boolean bl) {
        super(outputStream, bl);
        this.init(string);
    }

    public void init() {
        this.init(null);
    }

    public void init(String string) {
        Date date = new Date();
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (string != null) {
            this.addComment(string);
        }
    }

    public void close() {
        while (this.stateStack.size() > 0) {
            this.closeTag();
        }
        if (this.xref != null) {
            this.xref.close();
        }
        if (this.props != null) {
            this.props.clear();
        }
        super.close();
    }

    public void startTag(String string) {
        if (this.isTag()) {
            this.setTag(false);
            this.setBody(true);
            this.println('>');
        }
        this.stateStack.addLast(new state(this.name, this.isTag(), this.isBody()));
        this.setName(string);
        this.setTag(true);
        this.setBody(false);
        this.indent();
        this.print("<");
        this.print(this.name);
    }

    public void indent() {
        this.indent(this.stateStack.size() - 1);
    }

    public void indent(int n) {
        while (n > nest.length()) {
            this.print(nest);
            n -= nest.length();
        }
        if (n > 0) {
            this.print(nest.substring(0, n));
        }
    }

    public void addAttribute(String string, String string2) {
        if (this.isTag()) {
            this.print(' ');
            this.print(string);
            this.print("=\"");
            this.print(string2);
            this.print('\"');
        }
    }

    public void addContent(String string) {
        if (this.isTag() || this.isBody()) {
            if (this.isTag()) {
                this.print('>');
            }
            this.setTag(false);
            this.setBody(true);
            if (string != null) {
                this.print(string);
            }
        }
    }

    public void closeTag() {
        if (this.isTag()) {
            this.println(" />");
        } else if (this.isBody()) {
            this.print("</");
            this.print(this.getName());
            this.println('>');
        }
        state state2 = (state)this.stateStack.removeLast();
        this.setName(state2.name);
        this.setTag(state2.tag);
        this.setBody(state2.body);
        this.indent();
    }

    public void setTag(boolean bl) {
        this.tag = bl;
    }

    public boolean isTag() {
        return this.tag;
    }

    public void setBody(boolean bl) {
        this.body = bl;
    }

    public boolean isBody() {
        return this.body;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addComment(String string) {
        this.addContent(null);
        this.println();
        this.indent();
        this.print("<!-- ");
        this.print(string);
        this.println(" -->");
        this.indent();
    }

    public XMLRef getXMLRef() {
        if (this.xref == null) {
            this.xref = new XMLRef(this);
        }
        return this.xref;
    }

    public void writeTag(String string, String string2) {
        this.startTag(string);
        this.addContent(string2);
        this.closeTag();
    }

    public Object setProperty(String string, Object object) {
        if (this.props == null) {
            this.props = new Hashtable();
        }
        return this.props.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.props == null) {
            return null;
        }
        return this.props.get(string);
    }

    class state {
        public String name;
        public boolean tag;
        public boolean body;

        public state(String string, boolean bl, boolean bl2) {
            this.name = string;
            this.tag = bl;
            this.body = bl2;
        }
    }
}

