/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import uk.org.retep.xml.core.XMLWriter;

public class XMLSerialize {
    private static final XMLSerialize instance = new XMLSerialize();

    private XMLSerialize() {
    }

    public static XMLSerialize getInstance() {
        return instance;
    }

    public void serialize(Object object, OutputStream outputStream) throws IOException, IllegalAccessException {
        XMLWriter xMLWriter = new XMLWriter(outputStream);
        this.serialize(object, xMLWriter);
        xMLWriter.close();
    }

    public void serialize(Object object, Writer writer) throws IOException, IllegalAccessException {
        XMLWriter xMLWriter = new XMLWriter(writer);
        this.serialize(object, xMLWriter);
        xMLWriter.close();
    }

    public void serialize(Object object, XMLWriter xMLWriter) throws IOException, IllegalAccessException {
        if (object instanceof String) {
            xMLWriter.addContent(object.toString());
        } else if (object instanceof Serializable) {
            xMLWriter.startTag("OBJECT");
            xMLWriter.addAttribute("class", object.getClass().getName());
            Field[] fieldArray = object.getClass().getDeclaredFields();
            int n = 0;
            while (n < fieldArray.length) {
                Field field2 = fieldArray[n];
                Class<?> clazz = field2.getType();
                int n2 = field2.getModifiers();
                if (!Modifier.isTransient(n2) && !Modifier.isStatic(n2) && Modifier.isPublic(n2)) {
                    xMLWriter.startTag(field2.getName());
                    xMLWriter.addAttribute("type", clazz.getName());
                    System.out.println("name=" + field2.getName() + " type=" + clazz.getName());
                    this.serialize(field2.get(object), xMLWriter);
                    xMLWriter.closeTag();
                }
                ++n;
            }
            xMLWriter.closeTag();
        } else {
            xMLWriter.addContent(object.toString());
        }
    }
}

