/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing.util;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import uk.org.retep.util.DoubleVector;

public class DocumentPrinter
implements Printable,
Pageable {
    public static final double DEFAULTSCALE = 0.72;
    private JTextComponent component;
    private ViewFactory viewFactory;
    private View root;
    private PageFormat format;
    private double scale = 0.72;
    private int pageCount;
    private double printX;
    private double printY;
    private double printW;
    private double printH;
    private double paperW;
    private Rectangle drawRect;
    private static final double MARGIN_ADJUST = 0.97;
    private static final Font headerFont = new Font("Serif", 0, 10);
    private DoubleVector lengths = new DoubleVector();
    private DoubleVector offsets = new DoubleVector();
    private boolean pageNumbers;

    public DocumentPrinter(JTextComponent jTextComponent) {
        this(jTextComponent, new PageFormat());
    }

    public DocumentPrinter(JTextComponent jTextComponent, PageFormat pageFormat) {
        this.format = pageFormat;
        this.printX = this.format.getImageableX() / this.scale;
        this.printY = this.format.getImageableY() / this.scale;
        this.printW = this.format.getImageableWidth() / this.scale;
        this.printH = this.format.getImageableHeight() / this.scale;
        this.paperW = this.format.getWidth() / this.scale;
        Document document = jTextComponent.getDocument();
        Element element = document.getDefaultRootElement();
        EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
        this.viewFactory = editorKit.getViewFactory();
        this.root = this.viewFactory.create(element);
        this.root.setParent(new View(this.root.getElement()){

            public ViewFactory getViewFactory() {
                return DocumentPrinter.this.viewFactory;
            }

            public Container getContainer() {
                return DocumentPrinter.this.component;
            }

            public void paint(Graphics graphics, Shape shape) {
            }

            public float getPreferredSpan(int n) {
                return 0.0f;
            }

            public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
                return 0;
            }

            public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
                return shape;
            }
        });
        this.root.setSize((float)(this.printW - 10.0), (float)(this.printH - 10.0));
        double d = this.root.getPreferredSpan(1);
        this.drawRect = new Rectangle(0, 0, (int)this.printW, (int)d);
        if (d > this.printH) {
            this.paginate(this.root, this.drawRect, 0.0);
        }
        this.pageCount = this.lengths.size() + 1;
    }

    private double breakPage(double d, double d2) {
        double d3 = d2 - d - this.printY;
        d = d2 - this.printY;
        this.lengths.add(d3);
        this.offsets.add(d);
        return d;
    }

    /*
     * Exception decompiling
     */
    private double paginate(View var1_1, Rectangle2D var2_2, double var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= this.pageCount) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(this.format.getImageableX(), this.format.getImageableY());
        graphics2D.scale(this.scale, this.scale);
        if (this.isPageNumbers()) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(new Rectangle(0, (int)(-this.printY), (int)this.printW, (int)this.printY));
            String string = "- " + (n + 1) + " / " + this.pageCount + " -";
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = headerFont.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = headerFont.getLineMetrics(string, fontRenderContext);
            graphics2D.setFont(headerFont);
            graphics2D.setColor(Color.black);
            graphics2D.drawString(string, (int)((this.printW - rectangle2D.getWidth()) / 2.0), (int)(-(this.printY - rectangle2D.getHeight()) / 2.0 + (double)lineMetrics.getAscent()));
            graphics2D.setClip(shape);
        }
        graphics2D.translate(0.0, n > 0 ? -this.offsets.getIndex(n - 1) : 0.0);
        this.root.paint(graphics2D, this.drawRect);
        return 0;
    }

    public int getNumberOfPages() {
        return this.pageCount * 0;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n == this.pageCount - 1) {
            return this.format;
        }
        double d = this.lengths.getIndex(n);
        PageFormat pageFormat = (PageFormat)this.format.clone();
        Paper paper = pageFormat.getPaper();
        if (pageFormat.getOrientation() == 1) {
            paper.setImageableArea(this.printX * this.scale, this.printY * this.scale, this.printW * this.scale, d * this.scale);
        } else {
            paper.setImageableArea(this.printY * this.scale, this.printX * this.scale, d * this.scale, this.printW * this.scale);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    public void setPageNumbers(boolean bl) {
        this.pageNumbers = bl;
    }

    public boolean isPageNumbers() {
        return this.pageNumbers;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }
}

