/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreePopupMenu
extends JPopupMenu {
    private int x;
    private int y;
    private JTree tree;

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.x = n;
        this.y = n2;
    }

    public void show(Component component, int n, int n2) {
        System.out.println("show: " + component.getClass().getName() + " " + n + "," + n2);
        if (!(component instanceof JTree)) {
            throw new IllegalArgumentException("TreePopupMenu can only be used with JTree, not " + component.getClass().getName());
        }
        this.tree = (JTree)component;
        super.show(component, n, n2);
    }

    public boolean isInvoked() {
        return this.tree != null;
    }

    public TreePath getPath() {
        if (this.isInvoked()) {
            Insets insets = this.tree.getInsets();
            System.out.println("x=" + this.x + " y=" + this.y + " row=" + this.tree.getClosestRowForLocation(this.x, this.y));
            return this.tree.getClosestPathForLocation(this.x, this.y);
        }
        return null;
    }

    public TreeNode[] getNodePath() {
        TreePath treePath = this.getPath();
        if (treePath != null) {
            TreeNode[] treeNodeArray = new TreeNode[treePath.getPathCount()];
            System.arraycopy(treePath.getPath(), 0, treeNodeArray, 0, treePath.getPathCount());
            return treeNodeArray;
        }
        return null;
    }

    public TreeNode getNode() {
        TreePath treePath = this.getPath();
        return treePath == null ? null : (TreeNode)treePath.getLastPathComponent();
    }

    public void setItemsEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        if (componentArray != null) {
            int n = 0;
            while (n < componentArray.length) {
                ((JMenuItem)componentArray[n]).setEnabled(bl);
                ++n;
            }
        }
    }
}

