/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.swing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class ClockLabel
extends JLabel
implements Runnable,
Serializable {
    private boolean flashing = false;
    private boolean running = true;
    private boolean clock24 = true;
    private boolean seconds = false;
    private Thread thread = new Thread(this);
    private SimpleDateFormat sdf = new SimpleDateFormat(CLOCK24[0]);
    private Date now = new Date();
    private static final String[] CLOCK24 = new String[]{"HH:mm", "HH mm", "HH:mm:ss", "HH mm ss"};
    private static final String[] CLOCK12 = new String[]{"hh:mm", "hh mm", "hh:mm:ss", "hh mm ss"};

    public ClockLabel() {
        super("00:00");
        this.thread.start();
    }

    public void setFlashing(boolean bl) {
        this.flashing = bl;
    }

    public void setRunning(boolean bl) {
        if (bl && !this.running) {
            this.running = bl;
            this.thread = new Thread();
            this.thread.start();
        }
        this.running = bl;
    }

    public void setClock24(boolean bl) {
        this.clock24 = bl;
    }

    public void setBorder(Border border) {
        super.setBorder(border);
    }

    public void setSeconds(boolean bl) {
        this.seconds = bl;
    }

    public boolean isFlashing() {
        return this.flashing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isClock24() {
        return this.clock24;
    }

    public Border getBorder() {
        return super.getBorder();
    }

    public boolean isSeconds() {
        return this.seconds;
    }

    public void run() {
        int n = 0;
        while (this.isRunning()) {
            int n2 = this.isSeconds() ? 2 : 0;
            this.now.setTime(System.currentTimeMillis());
            this.sdf.applyPattern(this.isClock24() ? CLOCK24[n + n2] : CLOCK12[n + n2]);
            this.setText(this.sdf.format(this.now));
            n = this.isFlashing() ? 1 - n : 0;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

