/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.beanbuilder.comp;

import java.util.Iterator;
import uk.org.retep.beanbuilder.data.BeanBase;
import uk.org.retep.beanbuilder.data.EJB;
import uk.org.retep.beanbuilder.data.EntityBean;
import uk.org.retep.beanbuilder.data.Field;
import uk.org.retep.beanbuilder.data.Project;
import uk.org.retep.beanbuilder.data.SessionBean;
import uk.org.retep.xml.core.XMLWriter;

public abstract class EJBJAR {
    private static final int ENTITY = 0;
    private static final int SESSION = 1;

    public static void encodeProject(XMLWriter xMLWriter, Project project) {
        EJB eJB;
        BeanBase beanBase;
        boolean bl = false;
        xMLWriter.startTag("ejb-jar");
        xMLWriter.writeTag("display-name", project.getDescription());
        xMLWriter.startTag("enterprise-beans");
        Iterator iterator = project.getBeans();
        while (iterator.hasNext()) {
            beanBase = project.getBean((String)iterator.next());
            eJB = null;
            EntityBean entityBean = null;
            SessionBean sessionBean = null;
            int n = -1;
            if (beanBase instanceof EntityBean) {
                xMLWriter.startTag("entity");
                n = 0;
                eJB = (EJB)beanBase;
                entityBean = (EntityBean)beanBase;
            } else if (beanBase instanceof SessionBean) {
                xMLWriter.startTag("session");
                n = 1;
                eJB = (EJB)beanBase;
                sessionBean = (SessionBean)beanBase;
            }
            if (n == 0 || n == 1) {
                xMLWriter.writeTag("description", beanBase.getDescription());
                xMLWriter.writeTag("ejb-name", beanBase.getName());
                xMLWriter.writeTag("home", eJB.getHomeName());
                xMLWriter.writeTag("remote", eJB.getClassName());
                xMLWriter.writeTag("ejb-class", eJB.getRemoteName());
            }
            if (n == 0) {
                bl = true;
                xMLWriter.writeTag("persistence-type", entityBean.getPersistenceType() == 0 ? "Container" : "Bean");
                xMLWriter.writeTag("prim-key-class", entityBean.getPrimaryKey().getType());
                xMLWriter.writeTag("reentrant", entityBean.isReentrant() ? "True" : "False");
                Iterator iterator2 = entityBean.getFields();
                while (iterator2.hasNext()) {
                    Field field2 = eJB.getField((String)iterator2.next());
                    xMLWriter.startTag("cmp-field");
                    xMLWriter.writeTag("field-name", field2.getName());
                    xMLWriter.closeTag();
                }
                xMLWriter.writeTag("primkey-field", entityBean.getPrimaryKey().getName());
            }
            xMLWriter.closeTag();
        }
        xMLWriter.closeTag();
        xMLWriter.startTag("assembly-descriptor");
        iterator = project.getBeans();
        while (iterator.hasNext()) {
            beanBase = project.getBean((String)iterator.next());
            if (!(beanBase instanceof EntityBean)) continue;
            eJB = (EntityBean)beanBase;
            xMLWriter.startTag("container-transaction");
            xMLWriter.startTag("method");
            xMLWriter.writeTag("ejb-name", eJB.getName());
            xMLWriter.writeTag("method-name", "*");
            xMLWriter.closeTag();
            xMLWriter.writeTag("trans-attribute", "Required");
            xMLWriter.closeTag();
        }
        xMLWriter.closeTag();
        xMLWriter.closeTag();
    }
}

