/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import uk.org.retep.app.Constants;
import uk.org.retep.app.Workspace;
import uk.org.retep.help.Help;
import uk.org.retep.swing.ExceptionDialog;
import uk.org.retep.swing.FileChooser;
import uk.org.retep.swing.ImageLibrary;
import uk.org.retep.swing.ListSelectionDialog;
import uk.org.retep.swing.SplashScreen;
import uk.org.retep.swing.TreePopupMenu;
import uk.org.retep.swing.model.list.VectorListModel;
import uk.org.retep.tools.ToolData;
import uk.org.retep.tools.ToolManager;
import uk.org.retep.xml.core.XMLWriter;

public class Desktop
extends JFrame
implements TreeSelectionListener {
    public static final String[] USEAGE = new String[]{"retepTools command line options:", " -e            Do not show exceptions in dialogs, but print a stack trace", "               instead. Useful for debugging new tools.", " -h            Display this text.", " -w workspace  Open an alternate workspace."};
    private static Desktop INSTANCE = null;
    private File useWorkspace;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    JLabel statusBar = new JLabel();
    BorderLayout borderLayout1 = new BorderLayout();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem mi_Open = new JMenuItem();
    JMenuItem mi_savews = new JMenuItem();
    JMenuItem mi_loadws = new JMenuItem();
    JMenu jMenu1 = new JMenu();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem8 = new JMenuItem();
    JMenuItem jMenuItem9 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();
    JInternalFrame WSProperties = null;
    JMenuItem mi_Close = new JMenuItem();
    JMenuItem mi_New = new JMenuItem();
    JMenuItem mi_Help = new JMenuItem();
    JMenu menu_view = new JMenu();
    JMenuItem m_view_workspace = new JMenuItem();
    JSplitPane jSplitPane1 = new JSplitPane();
    JDesktopPane desktop = new JDesktopPane();
    JTree toolTree = new JTree();
    JScrollPane jScrollPane1 = new JScrollPane();
    TreePopupMenu toolPopup = new TreePopupMenu();
    JMenuItem tpu_close = new JMenuItem();
    JMenuItem tpu_Open = new JMenuItem();
    private JMenuItem tpu_new = new JMenuItem();
    private JMenuItem mi_help_licence = new JMenuItem();
    private Help helpFrame;

    public static Desktop getInstance() {
        return INSTANCE;
    }

    public Desktop() {
        this(new String[0]);
    }

    public Desktop(String[] stringArray) {
        INSTANCE = this;
        ToolManager.getInstance().setDesktop(this.desktop);
        boolean bl = true;
        this.useWorkspace = Constants.DEFAULT_WORKSPACE;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.startsWith("-")) {
                if (stringArray[n2].equals("-e")) {
                    bl = false;
                } else if (stringArray[n2].equals("-h")) {
                    this.useage();
                } else if (stringArray[n2].equals("-w") && n2 < n - 1) {
                    this.useWorkspace = new File(stringArray[n2 + 1]);
                    ++n2;
                } else {
                    System.err.println("Unknown option " + string + ": Use -h for help");
                    System.exit(10);
                }
            }
            ++n2;
        }
        if (bl) {
            ExceptionDialog.setFrame(this);
        }
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void useage() {
        int n = 0;
        while (n < USEAGE.length) {
            System.err.println(USEAGE[n]);
            ++n;
        }
        System.exit(0);
    }

    public void run() {
        ToolManager toolManager = ToolManager.getInstance();
        this.toolTree.setRootVisible(false);
        this.toolTree.setModel(toolManager.refreshTree());
        this.toolTree.getSelectionModel().addTreeSelectionListener(this);
        Workspace.getInstance().openWorkspace(this.useWorkspace, true);
        SplashScreen.hideSplash();
        ((Frame)this).setIconImage(ImageLibrary.getImage("images/development/Application16.gif"));
        ((Component)this).setVisible(true);
    }

    private void jbInit() throws Exception {
        ((Frame)this).setIconImage(ImageLibrary.getImage("images/development/Application16.gif"));
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(638, 497));
        this.setTitle("RetepTools");
        this.statusBar.setText(" ");
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.jMenuFileExit_actionPerformed(actionEvent);
            }
        });
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setText("About");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.jMenuHelpAbout_actionPerformed(actionEvent);
            }
        });
        this.mi_Open.setText("Open");
        this.mi_Open.setAccelerator(KeyStroke.getKeyStroke(79, 2, false));
        this.mi_Open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.openFile(actionEvent);
            }
        });
        this.jMenuItem2.setEnabled(false);
        this.jMenuItem2.setText("Print");
        this.jMenuItem1.setEnabled(false);
        this.jMenuItem1.setText("PDF");
        this.mi_loadws.setText("Load Workspace");
        this.mi_loadws.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.mi_loadws_actionPerformed(actionEvent);
            }
        });
        this.mi_savews.setText("Save Workspace");
        this.mi_savews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.mi_savews_actionPerformed(actionEvent);
            }
        });
        this.jMenu1.setText("Tools");
        this.jMenu2.setText("Generate");
        this.jMenuItem8.setEnabled(false);
        this.jMenuItem8.setText("Jar file");
        this.jMenuItem9.setEnabled(false);
        this.jMenuItem9.setText("Backup tool");
        this.jMenuItem3.setText("Properties");
        this.jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.jMenuItem3_actionPerformed(actionEvent);
            }
        });
        this.mi_Close.setText("Close");
        this.mi_Close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.mi_Close_actionPerformed(actionEvent);
            }
        });
        this.mi_New.setEnabled(false);
        this.mi_New.setText("New");
        this.mi_Help.setText("Index");
        this.menu_view.setText("View");
        this.m_view_workspace.setText("Workspace");
        this.toolTree.setMaximumSize(new Dimension(256, 64));
        this.toolTree.setMinimumSize(new Dimension(120, 0));
        this.toolTree.setPreferredSize(new Dimension(120, 64));
        this.toolTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Desktop.this.toolTree_mouseClicked(mouseEvent);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jSplitPane1.setRightComponent(this.desktop);
        this.tpu_close.setText("Close");
        this.tpu_close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.closeToolData(actionEvent);
            }
        });
        this.tpu_Open.setText("Open");
        this.tpu_Open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.openToolData(actionEvent);
            }
        });
        this.tpu_new.setText("New");
        this.tpu_new.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.newToolData(actionEvent);
            }
        });
        this.mi_help_licence.setText("Licence");
        this.mi_help_licence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Desktop.this.mi_help_licence_actionPerformed(actionEvent);
            }
        });
        this.jMenuFile.add(this.mi_New);
        this.jMenuFile.add(this.mi_Open);
        this.jMenuFile.add(this.mi_Close);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.mi_loadws);
        this.jMenuFile.add(this.mi_savews);
        this.jMenuFile.add(this.jMenuItem3);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuItem2);
        this.jMenuFile.add(this.jMenuItem1);
        this.jMenuFile.addSeparator();
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.mi_Help);
        this.jMenuHelp.add(this.mi_help_licence);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenuBar1.add(this.menu_view);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.statusBar, "South");
        this.contentPane.add((Component)this.jSplitPane1, "Center");
        this.jMenu1.add(this.jMenu2);
        this.jMenu2.add(this.jMenuItem8);
        this.jMenu2.add(this.jMenuItem9);
        this.menu_view.add(this.m_view_workspace);
        this.jScrollPane1.getViewport().add((Component)this.toolTree, null);
        this.toolPopup.add(this.tpu_new);
        this.toolPopup.add(this.tpu_Open);
        this.toolPopup.add(this.tpu_close);
    }

    private void jMenuFileExit_actionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void jMenuHelpAbout_actionPerformed(ActionEvent actionEvent) {
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void jMenuItem3_actionPerformed(ActionEvent actionEvent) {
        if (this.WSProperties == null) {
            // empty if block
        }
    }

    void mi_Close_actionPerformed(ActionEvent actionEvent) {
        new Thread(new Runnable(){

            public void run() {
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog((Frame)Desktop.this, true);
                ToolManager toolManager = ToolManager.getInstance();
                if (listSelectionDialog.show("Close Open Files", new VectorListModel(toolManager.getToolData()), "Close")) {
                    Object[] objectArray = listSelectionDialog.getSelectedValues();
                    int n = 0;
                    while (n < objectArray.length) {
                        toolManager.close((ToolData)objectArray[n]);
                        ++n;
                    }
                }
            }
        }).start();
    }

    private void mi_savews_actionPerformed(ActionEvent actionEvent) {
        Workspace workspace = Workspace.getInstance();
        FileChooser fileChooser = FileChooser.getInstance();
        fileChooser.setFile(workspace.getFile());
        ToolManager.getInstance().setFileFilter();
        if (fileChooser.showSingleSaveDialog(this) == 0) {
            workspace.setFile(fileChooser.getSelectedFile());
            try {
                XMLWriter xMLWriter = new XMLWriter(new FileOutputStream(workspace.getFile()));
                workspace.writeXML(xMLWriter);
                xMLWriter.close();
                workspace.setModified(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void openFile(ActionEvent actionEvent) {
        ToolManager toolManager = ToolManager.getInstance();
        FileChooser fileChooser = FileChooser.getInstance();
        fileChooser.setFile(null);
        toolManager.setFileFilter();
        if (fileChooser.showMultiOpenDialog(this) == 0) {
            File[] fileArray = fileChooser.getSelectedFiles();
            int n = 0;
            while (n < fileArray.length) {
                String string = toolManager.getTool(fileArray[n]);
                if (string != null) {
                    try {
                        ToolData toolData = toolManager.readFile(string, fileArray[n]);
                        if (toolData != null) {
                            toolManager.openTool(string, toolData);
                        }
                    }
                    catch (Exception exception) {
                        ExceptionDialog.show(exception);
                    }
                }
                ++n;
            }
        }
    }

    private void mi_loadws_actionPerformed(ActionEvent actionEvent) {
        Workspace workspace = Workspace.getInstance();
        FileChooser fileChooser = FileChooser.getInstance();
        fileChooser.setFile(workspace.getFile());
        ToolManager.getInstance().setFileFilter();
        if (fileChooser.showSingleOpenDialog(this) == 0) {
            Workspace.getInstance().openWorkspace(fileChooser.getSelectedFile(), false);
        }
    }

    private void closeToolData(ActionEvent actionEvent) {
        ToolManager toolManager = ToolManager.getInstance();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.toolTree.getLastSelectedPathComponent();
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.toolTree.getModel();
        TreeNode[] treeNodeArray = defaultTreeModel.getPathToRoot(defaultMutableTreeNode);
        if (treeNodeArray != null) {
            switch (treeNodeArray.length) {
                case 2: {
                    String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treeNodeArray[1]).getUserObject());
                    Iterator iterator = toolManager.getToolData(string);
                    while (iterator.hasNext()) {
                        toolManager.removeData(string, (String)iterator.next());
                    }
                    break;
                }
                case 3: {
                    String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treeNodeArray[1]).getUserObject());
                    String string2 = (String)((DefaultMutableTreeNode)treeNodeArray[2]).getUserObject();
                    toolManager.removeData(string, toolManager.getToolData(string, string2));
                    break;
                }
            }
        }
    }

    private void newToolData(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                TreeNode[] treeNodeArray = Desktop.this.toolPopup.getNodePath();
                if (treeNodeArray != null && treeNodeArray != null && treeNodeArray.length >= 2) {
                    ToolManager toolManager = ToolManager.getInstance();
                    String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treeNodeArray[1]).getUserObject());
                    System.out.println("tool=" + string);
                    try {
                        toolManager.openTool(string);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.show(exception);
                    }
                }
            }
        });
        thread.start();
    }

    private void openToolData(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)Desktop.this.toolTree.getLastSelectedPathComponent();
                DefaultTreeModel defaultTreeModel = (DefaultTreeModel)Desktop.this.toolTree.getModel();
                TreeNode[] treeNodeArray = defaultTreeModel.getPathToRoot(defaultMutableTreeNode);
                if (treeNodeArray != null && treeNodeArray.length >= 2) {
                    ToolManager toolManager = ToolManager.getInstance();
                    String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treeNodeArray[1]).getUserObject());
                    FileChooser fileChooser = FileChooser.getInstance();
                    fileChooser.setFile(null);
                    toolManager.setFileFilter(string);
                    if (fileChooser.showMultiOpenDialog(Desktop.this) == 0) {
                        File[] fileArray = fileChooser.getSelectedFiles();
                        int n = 0;
                        while (n < fileArray.length) {
                            try {
                                ToolData toolData = toolManager.readFile(string, fileArray[n]);
                                if (toolData != null) {
                                    toolManager.openTool(string, toolData);
                                }
                            }
                            catch (Exception exception) {
                                ExceptionDialog.show(exception);
                            }
                            ++n;
                        }
                    }
                }
            }
        });
        thread.start();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        if (treePath != null && treePath.getPathCount() == 3) {
            ToolManager toolManager = ToolManager.getInstance();
            String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treePath.getPathComponent(1)).getUserObject());
            String string2 = (String)((DefaultMutableTreeNode)treePath.getPathComponent(2)).getUserObject();
            ToolData toolData = toolManager.getToolData(string, string2);
            toolManager.openTool(string, toolData);
        }
    }

    void toolTree_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource().equals(this.toolTree) && (mouseEvent.getModifiers() & 4) == 4) {
            boolean bl;
            ToolManager toolManager = ToolManager.getInstance();
            TreePath treePath = this.toolTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            boolean bl2 = bl = treePath != null;
            if (bl) {
                int n = treePath.getPathCount();
                String string = toolManager.getToolByDisplayName((String)((DefaultMutableTreeNode)treePath.getPathComponent(1)).getUserObject());
                this.toolPopup.setLabel(string);
                this.tpu_close.setText(n >= 3 ? "Close" : "Close All");
            } else {
                this.toolPopup.setLabel("No Tool");
            }
            this.toolPopup.setItemsEnabled(bl);
            this.toolPopup.show(this.toolTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void showHelp(URL uRL) {
        if (this.helpFrame == null) {
            this.helpFrame = new Help();
            this.helpFrame.pack();
            this.desktop.add(this.helpFrame);
        }
        this.helpFrame.setVisible(true);
        this.helpFrame.display(uRL);
    }

    void mi_help_licence_actionPerformed(ActionEvent actionEvent) {
        this.showHelp(this.getClass().getResource("../help/licence.html"));
    }
}

