/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.xml.parser;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import uk.org.retep.xml.parser.TagListener;

public class TagHandler
extends HandlerBase {
    private int level = 0;
    private List contents = new ArrayList();
    private List tags = new ArrayList();
    private List args = new ArrayList();
    private CharArrayWriter content;
    private HashSet tagListeners = new HashSet();

    public void addTagListener(TagListener tagListener) {
        this.tagListeners.add(tagListener);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.content.write(cArray, n, n2);
    }

    public void endElement(String string) throws SAXException {
        if (this.level < 1) {
            throw new SAXException("Already at top level?");
        }
        --this.level;
        Iterator iterator2 = this.tagListeners.iterator();
        while (iterator2.hasNext()) {
            ((TagListener)iterator2.next()).tagContent(this.content);
        }
        this.content.reset();
        this.content = (CharArrayWriter)this.contents.get(this.level);
    }

    public Parser getParser() throws SAXException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            String string = System.getProperty("javax.xml.parsers.validation", "false");
            if (string.equalsIgnoreCase("true")) {
                sAXParserFactory.setValidating(true);
            }
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            Parser parser = sAXParser.getParser();
            parser.setDocumentHandler(this);
            return parser;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.toString());
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.getParser().parse(string);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        this.getParser().parse(inputSource);
    }

    public void removeTagListener(TagListener tagListener) {
        this.tagListeners.remove(tagListener);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.contents.size() <= this.level) {
            this.contents.add(new CharArrayWriter());
            this.tags.add(string);
            this.args.add(new HashMap());
        }
        this.content = (CharArrayWriter)this.contents.get(this.level);
        this.content.reset();
        this.tags.set(this.level, string);
        HashMap hashMap = (HashMap)this.args.get(this.level);
        hashMap.clear();
        int n = attributeList.getLength() - 1;
        while (n > -1) {
            hashMap.put(attributeList.getName(n), attributeList.getValue(n));
            --n;
        }
        Iterator iterator2 = this.tagListeners.iterator();
        while (iterator2.hasNext()) {
            ((TagListener)iterator2.next()).tagStart(this.level, string, hashMap);
        }
        ++this.level;
    }
}

