/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.proped;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import uk.org.retep.tools.Tool;
import uk.org.retep.util.ExceptionDialog;
import uk.org.retep.util.misc.PropertiesIO;
import uk.org.retep.util.models.PropertiesTableModel;

public class PropertyEditor
extends JPanel
implements Tool {
    BorderLayout borderLayout1 = new BorderLayout();
    String filename;
    File file;
    JScrollPane jScrollPane1 = new JScrollPane();
    JTable contentTable = new JTable();
    PropertiesTableModel model = new PropertiesTableModel();
    boolean standaloneMode;
    private static final String TITLE_PREFIX = "Retep PropertyEditor";
    JPopupMenu popupMenu = new JPopupMenu();
    JMenuItem newPopupItem = new JMenuItem();
    JMenuItem dupPopupItem = new JMenuItem();
    JMenuItem delPopupItem = new JMenuItem();
    JMenuBar menuBar = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItem4 = new JMenuItem();
    JMenuItem jMenuItem5 = new JMenuItem();
    JMenuItem jMenuItem6 = new JMenuItem();
    JMenuItem jMenuItem7 = new JMenuItem();
    JMenuItem jMenuItem8 = new JMenuItem();
    JMenuItem closeMenuItem = new JMenuItem();
    Point popupPoint = new Point();
    JMenu jMenu2 = new JMenu();
    JMenuItem jMenuItem1 = new JMenuItem();
    JMenuItem jMenuItem2 = new JMenuItem();
    JMenuItem jMenuItem3 = new JMenuItem();

    public PropertyEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void closeMenuItem_actionPerformed(ActionEvent actionEvent) {
        if (this.standaloneMode) {
            System.exit(0);
        } else {
            this.filename = "";
            this.file = null;
            this.model.setProperties(new Properties());
        }
    }

    void contentTable_mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupPoint.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this.popupMenu.show(this.contentTable, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void contentTable_mouseReleased(MouseEvent mouseEvent) {
        this.contentTable_mouseClicked(mouseEvent);
    }

    void delPopupItem_actionPerformed(ActionEvent actionEvent) {
        int n = this.contentTable.rowAtPoint(this.popupPoint);
        this.model.remove(this.model.getValueAt(n, 0));
    }

    void dupPopupItem_actionPerformed(ActionEvent actionEvent) {
        int n = this.contentTable.rowAtPoint(this.popupPoint);
        String string = (String)this.model.getValueAt(n, 0);
        Object object = this.model.get(string);
        int n2 = 1;
        while (this.model.containsKey(String.valueOf(string) + n2)) {
            ++n2;
        }
        string = String.valueOf(string) + n2;
        this.model.put(string, object);
        this.contentTable.clearSelection();
    }

    public JMenu getMenu() {
        return this.jMenu1;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public String getTitle() {
        if (this.filename == null) {
            return TITLE_PREFIX;
        }
        return "Retep PropertyEditor: " + this.filename;
    }

    public boolean isStandalone() {
        return this.standaloneMode;
    }

    void jMenuItem4_actionPerformed(ActionEvent actionEvent) {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showOpenDialog(this) != 0) break block2;
            try {
                this.openFile(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                ExceptionDialog.displayException(iOException);
            }
        }
    }

    void jMenuItem5_actionPerformed(ActionEvent actionEvent) {
        if (this.filename == null) {
            this.jMenuItem6_actionPerformed(actionEvent);
        } else {
            try {
                this.saveFile(this.file);
            }
            catch (IOException iOException) {
                ExceptionDialog.displayException(iOException);
            }
        }
    }

    void jMenuItem6_actionPerformed(ActionEvent actionEvent) {
        block2: {
            JFileChooser jFileChooser = new JFileChooser();
            if (jFileChooser.showSaveDialog(this) != 0) break block2;
            try {
                this.saveFile(jFileChooser.getSelectedFile());
            }
            catch (IOException iOException) {
                ExceptionDialog.displayException(iOException);
            }
        }
    }

    void jMenuItem7_actionPerformed(ActionEvent actionEvent) {
        if (this.file != null) {
            try {
                this.openFile(this.file);
            }
            catch (IOException iOException) {
                ExceptionDialog.displayException(iOException);
            }
        } else {
            this.jMenuItem4_actionPerformed(actionEvent);
        }
    }

    void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.contentTable.setToolTipText("");
        this.contentTable.setAutoResizeMode(3);
        this.contentTable.setModel(this.model);
        this.contentTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                PropertyEditor.this.contentTable_mouseClicked(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PropertyEditor.this.contentTable_mouseReleased(mouseEvent);
            }
        });
        this.newPopupItem.setText("New");
        this.newPopupItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.newPopupItem_actionPerformed(actionEvent);
            }
        });
        this.dupPopupItem.setText("Duplicate");
        this.dupPopupItem.setAccelerator(KeyStroke.getKeyStroke(67, 2, false));
        this.dupPopupItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.dupPopupItem_actionPerformed(actionEvent);
            }
        });
        this.delPopupItem.setText("Delete");
        this.delPopupItem.setAccelerator(KeyStroke.getKeyStroke(68, 2, false));
        this.delPopupItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.delPopupItem_actionPerformed(actionEvent);
            }
        });
        this.jMenu1.setText("File");
        this.jMenuItem4.setText("Open");
        this.jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.jMenuItem4_actionPerformed(actionEvent);
            }
        });
        this.jMenuItem5.setText("Save");
        this.jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.jMenuItem5_actionPerformed(actionEvent);
            }
        });
        this.jMenuItem6.setText("Save As");
        this.jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.jMenuItem6_actionPerformed(actionEvent);
            }
        });
        this.jMenuItem7.setText("Revert");
        this.jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.jMenuItem7_actionPerformed(actionEvent);
            }
        });
        this.jMenuItem8.setText("Print");
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.closeMenuItem_actionPerformed(actionEvent);
            }
        });
        this.jMenu2.setText("Edit");
        this.jMenuItem1.setText("New");
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(78, 2, false));
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertyEditor.this.newPopupItem_actionPerformed(actionEvent);
            }
        });
        this.jMenuItem2.setText("Duplicate");
        this.jMenuItem3.setText("Delete");
        this.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.contentTable, null);
        this.popupMenu.add(this.newPopupItem);
        this.popupMenu.add(this.dupPopupItem);
        this.popupMenu.add(this.delPopupItem);
        this.menuBar.add(this.jMenu1);
        this.menuBar.add(this.jMenu2);
        this.jMenu1.add(this.jMenuItem4);
        this.jMenu1.add(this.jMenuItem5);
        this.jMenu1.add(this.jMenuItem6);
        this.jMenu1.add(this.jMenuItem7);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.jMenuItem8);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.closeMenuItem);
        this.jMenu2.add(this.jMenuItem1);
        this.jMenu2.add(this.jMenuItem2);
        this.jMenu2.add(this.jMenuItem3);
    }

    void newPopupItem_actionPerformed(ActionEvent actionEvent) {
        int n = this.contentTable.rowAtPoint(this.popupPoint);
        String string = (String)this.model.getValueAt(n, 0);
        if (string == null) {
            string = "new-key";
        }
        int n2 = 1;
        while (this.model.containsKey(String.valueOf(string) + n2)) {
            ++n2;
        }
        string = String.valueOf(string) + n2;
        this.model.put(string, "");
        this.contentTable.clearSelection();
    }

    public void openFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        fileInputStream.close();
        this.model.setProperties(properties);
        this.file = file;
        this.filename = file.getAbsolutePath();
    }

    public void openFile(String string) throws IOException {
        this.openFile(new File(string));
    }

    public void saveFile(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        PropertiesIO.save(this.model.getProperties(), fileOutputStream, '=', "Written by Retep PropertyEditor");
        fileOutputStream.close();
        this.filename = file.getAbsolutePath();
        this.file = file;
    }

    public void setStandaloneMode(boolean bl) {
        this.standaloneMode = bl;
        if (bl) {
            this.closeMenuItem.setText("Exit");
        } else {
            this.closeMenuItem.setText("Close");
        }
    }
}

