/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.util.models;

import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import uk.org.retep.util.Logger;
import uk.org.retep.util.misc.PropertiesIO;

public class PropertiesTableModel
extends AbstractTableModel {
    protected TreeMap properties;
    protected Properties origProperties;
    protected Object[] keys;
    private static final String[] cols = new String[]{"Property", "Value"};

    public PropertiesTableModel() {
        this(new Properties());
    }

    public PropertiesTableModel(Properties properties) {
        this.setProperties(properties);
    }

    public boolean contains(Object object) {
        return ((Hashtable)this.origProperties).contains(object);
    }

    public boolean containsKey(Object object) {
        return ((Hashtable)this.origProperties).containsKey(object);
    }

    public boolean containsValue(Object object) {
        return ((Hashtable)this.origProperties).containsValue(object);
    }

    public Object get(Object object) {
        return ((Hashtable)this.origProperties).get(object);
    }

    public int getColumnCount() {
        return cols.length;
    }

    public String getColumnName(int n) {
        return cols[n];
    }

    public synchronized int getKeyRow(Object object) {
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Properties getProperties() {
        return this.origProperties;
    }

    public int getRowCount() {
        return this.keys.length;
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.keys.length || n2 < 0 || n2 >= cols.length) {
            return null;
        }
        Object object = this.keys[n];
        switch (n2) {
            case 0: {
                return object;
            }
            case 1: {
                return this.properties.get(object);
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public synchronized void put(Object object, Object object2) {
        this.properties.put(object, object2);
        ((Hashtable)this.origProperties).put(object, object2);
        this.refresh();
    }

    public void refresh() {
        this.keys = this.properties.keySet().toArray();
        this.fireTableDataChanged();
    }

    public synchronized void remove(Object object) {
        this.properties.remove(object);
        ((Hashtable)this.origProperties).remove(object);
        this.refresh();
    }

    public void setProperties(Properties properties) {
        this.origProperties = properties;
        this.properties = PropertiesIO.getTreeMap(properties);
        this.refresh();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n >= this.keys.length || n2 < 0 || n2 >= cols.length) {
            return;
        }
        switch (n2) {
            case 0: {
                if (!this.properties.containsKey(object)) {
                    Object object2 = this.get(this.keys[n]);
                    this.remove(this.keys[n]);
                    this.put(object, object2);
                }
                this.refresh();
                break;
            }
            case 1: {
                this.put(this.keys[n], object);
                break;
            }
            default: {
                Logger.log(1, "PropertiesTableModel: Column range", n2);
            }
        }
    }
}

