/*
 * Decompiled with CFR 0.152.
 */
package uk.org.retep.dtu;

import java.util.Iterator;
import uk.org.retep.dtu.DEnvironment;
import uk.org.retep.dtu.DModule;
import uk.org.retep.dtu.DNode;
import uk.org.retep.dtu.DTransform;
import uk.org.retep.util.Logger;

public class DProcessor {
    protected DProcessor(DModule dModule, long l) {
        ThreadGroup threadGroup = new ThreadGroup(String.valueOf(dModule.getDisplayName()) + " DProcessor");
        DEnvironment dEnvironment = new DEnvironment();
        Iterator iterator2 = dModule.iterator();
        while (iterator2.hasNext()) {
            DNode dNode = (DNode)iterator2.next();
            if (dNode.getFromTransforms() != 0) continue;
            proc proc2 = new proc(threadGroup, dModule, dNode, dEnvironment);
            proc2.start();
        }
        boolean bl = true;
        try {
            int n = 1;
            while (n > 0) {
                int n2 = threadGroup.activeCount();
                Thread[] threadArray = new Thread[n2];
                n = threadGroup.enumerate(threadArray, false);
                while (n > 0) {
                    threadArray[--n].join(l);
                }
                Logger.log(2, "All threads appear to have died, retesting");
            }
        }
        catch (InterruptedException interruptedException) {
            Logger.log(1, "DProcessor, exception caught while waiting for threads to die", interruptedException);
        }
        Logger.log(2, "DProcessor cleanup");
        Logger.log(2, "DProcessor finished");
    }

    public static DProcessor run(DModule dModule) {
        return DProcessor.run(dModule, 3600000L);
    }

    public static DProcessor run(DModule dModule, long l) {
        return new DProcessor(dModule, l);
    }

    class proc
    implements Runnable {
        protected DModule module;
        protected DNode pc;
        protected DEnvironment env;
        protected DTransform trans;
        protected int status;
        protected Thread thread;

        protected proc(ThreadGroup threadGroup, DModule dModule, DNode dNode, DEnvironment dEnvironment) {
            this.thread = threadGroup == null ? new Thread(this) : new Thread(threadGroup, this);
            this.module = dModule;
            this.pc = dNode;
            this.env = dEnvironment;
        }

        protected proc(DModule dModule, DNode dNode, DEnvironment dEnvironment, DTransform dTransform, int n) {
            this(null, dModule, dNode, dEnvironment);
            this.trans = dTransform;
            this.status = n;
        }

        public void run() {
            if (this.trans != null) {
                this.transform(this.trans, false, this.status);
                this.trans = null;
            }
            while (this.pc != null) {
                int n = this.pc.run(this.env);
                int n2 = this.pc.getToTransforms();
                boolean bl = false;
                int n3 = 0;
                while (n3 < n2) {
                    bl = this.transform(this.pc.getTransform(n3), bl, n);
                    ++n3;
                }
                if (!bl) {
                    this.pc = null;
                }
                Thread.yield();
            }
        }

        public void start() {
            this.thread.start();
        }

        public boolean transform(DTransform dTransform, boolean bl, int n) {
            if (!dTransform.willRun(n, this.env)) {
                return false;
            }
            if (bl) {
                proc proc2 = new proc(this.module, this.pc, this.env, dTransform, n);
                return true;
            }
            if (dTransform.run(this.env)) {
                this.pc = dTransform.getTo();
                return true;
            }
            return false;
        }
    }
}

