/*
 * Decompiled with CFR 0.152.
 */
package jp.turbosql.modules.db.app.dialogs;

public class RelationalTableColumnRowDataObject {
    private boolean primaryKey;
    private boolean allow_nulls;
    private static String[] columnNames = new String[]{"PK", "Column Name", "Data Type", "Length", "Allow Nulls"};
    private static Object[] columnTypeArray = new Object[]{Boolean.FALSE, new String(""), new String(""), new Integer(0), Boolean.FALSE};
    private static String[] supportedDataTypes = new String[]{"serial", "serial8", "bool", "char", "date", "float4", "float8", "int2", "int4", "int8", "text", "time", "timestampz", "varchar"};
    private static String[] unsupportedDataTypes = new String[]{"SET", "abstime", "aclitem", "bit", "box", "bpchar", "bytea", "cid", "cidr", "circle", "inet", "int2vector", "interval", "line", "lseg", "macaddr", "money", "name", "numeric", "oid", "oidvector", "path", "point", "polygon", "refcursor", "regproc", "reltime", "smgr", "tid", "timestamp", "timez", "tinterval", "unknown", "varbit", "xid"};
    private Boolean relationalColumnPrimaryKey;
    private String relationalColumnName;
    private String relationalColumnType;
    private Integer relationalColumnLength;
    private Boolean relationalColumnAllowNulls;
    private String relationalColumnDefaultValue;
    private String relationalColumnComment;
    private String relationalColumnNumericPrecision;
    private Boolean defaultRelationalColumnPrimaryKey = Boolean.FALSE;
    private String defaultRelationalColumnName = null;
    private String defaultRelationalColumnType = null;
    private Integer defaultRelationalColumnLength = null;
    private Boolean defaultRelationalColumnAllowNulls = Boolean.FALSE;
    private String defaultRelationalColumnDefaultValue = "";
    private String defaultRelationalColumnComment = "";
    private String defaultRelationalColumnNumericPrecision = "";
    private boolean[] isEditable = new boolean[]{true, true, true, true, true};
    private boolean[] isPropertyEditable = new boolean[]{true, true, false};
    private boolean dataChanged = false;

    public RelationalTableColumnRowDataObject() {
        this.relationalColumnPrimaryKey = this.defaultRelationalColumnPrimaryKey;
        this.relationalColumnName = this.defaultRelationalColumnName;
        this.relationalColumnType = this.defaultRelationalColumnType;
        this.relationalColumnLength = this.defaultRelationalColumnLength;
        this.relationalColumnAllowNulls = this.defaultRelationalColumnAllowNulls;
        this.relationalColumnDefaultValue = this.defaultRelationalColumnDefaultValue;
        this.relationalColumnComment = this.defaultRelationalColumnComment;
        this.relationalColumnNumericPrecision = this.defaultRelationalColumnNumericPrecision;
    }

    public boolean isChanged() {
        if (!this.dataChanged) {
            return false;
        }
        boolean temp_dataChanged = false;
        if (!this.relationalColumnPrimaryKey.equals(this.defaultRelationalColumnPrimaryKey)) {
            temp_dataChanged = true;
        } else if (this.relationalColumnName != this.defaultRelationalColumnName) {
            temp_dataChanged = true;
        } else if (this.relationalColumnType != this.defaultRelationalColumnType) {
            temp_dataChanged = true;
        } else if (this.relationalColumnLength != this.defaultRelationalColumnLength) {
            temp_dataChanged = true;
        } else if (!this.relationalColumnAllowNulls.equals(this.defaultRelationalColumnAllowNulls)) {
            temp_dataChanged = true;
        } else if (!this.relationalColumnDefaultValue.equals(this.defaultRelationalColumnDefaultValue)) {
            temp_dataChanged = true;
        } else if (!this.relationalColumnComment.equals(this.defaultRelationalColumnComment)) {
            temp_dataChanged = true;
        } else if (!this.relationalColumnNumericPrecision.equals(this.defaultRelationalColumnNumericPrecision)) {
            temp_dataChanged = true;
        }
        return temp_dataChanged;
    }

    public boolean isCellEditable(int column) {
        return this.isEditable[column];
    }

    public boolean isPropertyCellEditable(int column) {
        return this.isPropertyEditable[column];
    }

    public Object getValueAt(int column) {
        if (column == 0) {
            return this.relationalColumnPrimaryKey;
        }
        if (column == 1) {
            return this.relationalColumnName;
        }
        if (column == 2) {
            return this.relationalColumnType;
        }
        if (column == 3) {
            return this.relationalColumnLength;
        }
        if (column == 4) {
            return this.relationalColumnAllowNulls;
        }
        return null;
    }

    public void setValueAt(Object value, int column) {
        this.dataChanged = true;
        if (column == 0) {
            Boolean bl = this.relationalColumnPrimaryKey = value == null ? null : (Boolean)value;
            if (this.relationalColumnPrimaryKey != null) {
                if (this.relationalColumnPrimaryKey.equals(Boolean.TRUE)) {
                    this.relationalColumnAllowNulls = Boolean.FALSE;
                    this.isEditable[4] = false;
                } else {
                    this.isEditable[4] = true;
                }
            } else {
                this.isEditable[4] = true;
            }
        } else if (column == 1) {
            this.relationalColumnName = value == null ? null : (String)value;
        } else if (column == 2) {
            String string = this.relationalColumnType = value == null ? null : (String)value;
            if (this.relationalColumnType != null) {
                if (this.relationalColumnType.equals("serial")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(4);
                } else if (this.relationalColumnType.equals("serial8")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("bool")) {
                    this.isEditable[0] = false;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnPrimaryKey = Boolean.FALSE;
                    this.relationalColumnLength = new Integer(1);
                } else if (this.relationalColumnType.equals("char")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = true;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(10);
                } else if (this.relationalColumnType.equals("date")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("float4")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(4);
                } else if (this.relationalColumnType.equals("float8")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("int2")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(2);
                } else if (this.relationalColumnType.equals("int4")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(4);
                } else if (this.relationalColumnType.equals("int8")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("text")) {
                    this.isEditable[0] = false;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnPrimaryKey = Boolean.FALSE;
                    this.relationalColumnLength = new Integer(16);
                } else if (this.relationalColumnType.equals("time")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("timestampz")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = false;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(8);
                } else if (this.relationalColumnType.equals("varchar")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = true;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = new Integer(255);
                } else if (this.relationalColumnType.equals("numeric")) {
                    this.isEditable[0] = true;
                    this.isEditable[3] = true;
                    this.isPropertyEditable[2] = true;
                    this.relationalColumnLength = new Integer(255);
                } else {
                    this.isEditable[0] = true;
                    this.isEditable[3] = true;
                    this.isPropertyEditable[2] = false;
                    this.relationalColumnLength = null;
                }
            }
        } else if (column == 3) {
            this.relationalColumnLength = value == null ? null : (Integer)value;
        } else if (column == 4) {
            this.relationalColumnAllowNulls = value == null ? null : (Boolean)value;
        }
    }

    public static String[] getColumnNames() {
        return columnNames;
    }

    public static Object[] getColumnTypeArray() {
        return columnTypeArray;
    }

    public static String[] getSupportedDataTypes() {
        return supportedDataTypes;
    }

    public static String[] getUnsupportedDataTypes() {
        return unsupportedDataTypes;
    }

    public Object getPropertyValueAt(int propertyIndex) {
        if (propertyIndex == 0) {
            return this.relationalColumnDefaultValue;
        }
        if (propertyIndex == 1) {
            return this.relationalColumnComment;
        }
        if (propertyIndex == 2) {
            return this.relationalColumnNumericPrecision;
        }
        return null;
    }

    public void setPropertyValueAt(Object value, int propertyIndex) {
        if (propertyIndex == 0) {
            this.relationalColumnDefaultValue = value == null ? null : (String)value;
        } else if (propertyIndex == 1) {
            this.relationalColumnComment = value == null ? null : (String)value;
        } else if (propertyIndex == 2) {
            this.relationalColumnNumericPrecision = value == null ? null : (String)value;
        }
    }

    public boolean isLengthEditable() {
        return this.isEditable[3];
    }
}

