/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.fastpath;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.core.Notification;
import org.postgresql.core.PGStream;
import org.postgresql.fastpath.FastpathArg;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Fastpath {
    protected Hashtable func = new Hashtable();
    protected BaseConnection conn;
    protected PGStream stream;

    public Fastpath(BaseConnection conn, PGStream stream) {
        this.conn = conn;
        this.stream = stream;
    }

    public void addFunction(String name, int fnid) {
        this.func.put(name, new Integer(fnid));
    }

    public void addFunctions(ResultSet rs) throws SQLException {
        while (rs.next()) {
            this.func.put(rs.getString(1), new Integer(rs.getInt(2)));
        }
    }

    public Object fastpath(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (this.conn.haveMinimumServerVersion("7.4")) {
            return this.fastpathV3(fnid, resulttype, args);
        }
        return this.fastpathV2(fnid, resulttype, args);
    }

    public Object fastpath(String name, boolean resulttype, FastpathArg[] args) throws SQLException {
        if (Driver.logDebug) {
            Driver.debug("Fastpath: calling " + name);
        }
        return this.fastpath(this.getID(name), resulttype, args);
    }

    private Object fastpathV2(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        PGStream pGStream = this.stream;
        synchronized (pGStream) {
            try {
                this.stream.SendInteger(70, 1);
                this.stream.SendInteger(0, 1);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(args.length, 4);
                int i = 0;
                while (i < args.length) {
                    args[i].send(this.stream);
                    ++i;
                }
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new PSQLException("postgresql.fp.send", PSQLState.COMMUNICATION_ERROR, new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            StringBuffer errorMessage = null;
            boolean l_endQuery = false;
            block13: while (!l_endQuery) {
                int c = this.stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.stream.ReceiveInteger(4);
                        String msg = this.stream.ReceiveString(this.conn.getEncoding());
                        break;
                    }
                    case 69: {
                        if (errorMessage == null) {
                            errorMessage = new StringBuffer();
                        }
                        errorMessage.append(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 78: {
                        this.conn.addWarning(this.stream.ReceiveString(this.conn.getEncoding()));
                        break;
                    }
                    case 86: {
                        int l_nextChar = this.stream.ReceiveChar();
                        if (l_nextChar != 71) continue block13;
                        int sz = this.stream.ReceiveIntegerR(4);
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(sz));
                        } else {
                            byte[] buf = new byte[sz];
                            this.stream.Receive(buf, 0, sz);
                            result = buf;
                        }
                        int l_endChar = this.stream.ReceiveChar();
                        break;
                    }
                    case 90: {
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.fp.protocol", PSQLState.COMMUNICATION_ERROR, new Character((char)c));
                    }
                }
            }
            if (errorMessage != null) {
                throw new PSQLException("postgresql.fp.error", PSQLState.COMMUNICATION_ERROR, errorMessage.toString());
            }
            Integer n = result;
            Object var6_18 = null;
            return n;
        }
    }

    private Object fastpathV3(int fnid, boolean resulttype, FastpathArg[] args) throws SQLException {
        PGStream pGStream = this.stream;
        synchronized (pGStream) {
            try {
                int l_msgLen = 0;
                l_msgLen += 16;
                int i = 0;
                while (i < args.length) {
                    l_msgLen += args[i].sendSize();
                    ++i;
                }
                this.stream.SendChar(70);
                this.stream.SendInteger(l_msgLen, 4);
                this.stream.SendInteger(fnid, 4);
                this.stream.SendInteger(1, 2);
                this.stream.SendInteger(1, 2);
                this.stream.SendInteger(args.length, 2);
                int i2 = 0;
                while (i2 < args.length) {
                    args[i2].send(this.stream);
                    ++i2;
                }
                this.stream.SendInteger(1, 2);
                this.stream.flush();
            }
            catch (IOException ioe) {
                throw new PSQLException("postgresql.fp.send", PSQLState.COMMUNICATION_ERROR, new Integer(fnid), (Object)ioe);
            }
            Object result = null;
            PSQLException error = null;
            boolean l_endQuery = false;
            block14: while (!l_endQuery) {
                int c = this.stream.ReceiveChar();
                switch (c) {
                    case 65: {
                        int pid = this.stream.ReceiveInteger(4);
                        String msg = this.stream.ReceiveString(this.conn.getEncoding());
                        this.conn.addNotification(new Notification(msg, pid));
                        break;
                    }
                    case 69: {
                        int l_elen = this.stream.ReceiveIntegerR(4);
                        String totalMessage = this.conn.getEncoding().decode(this.stream.Receive(l_elen - 4));
                        PSQLException l_error = PSQLException.parseServerError(totalMessage);
                        if (error != null) {
                            error.setNextException(l_error);
                            break;
                        }
                        error = l_error;
                        break;
                    }
                    case 78: {
                        int l_nlen = this.stream.ReceiveIntegerR(4);
                        this.conn.addWarning(this.conn.getEncoding().decode(this.stream.Receive(l_nlen - 4)));
                        break;
                    }
                    case 86: {
                        int l_msgLen = this.stream.ReceiveIntegerR(4);
                        int l_valueLen = this.stream.ReceiveIntegerR(4);
                        if (l_valueLen == -1) continue block14;
                        if (l_valueLen == 0) {
                            result = new byte[]{};
                            break;
                        }
                        if (resulttype) {
                            result = new Integer(this.stream.ReceiveIntegerR(l_valueLen));
                            break;
                        }
                        byte[] buf = new byte[l_valueLen];
                        this.stream.Receive(buf, 0, l_valueLen);
                        result = buf;
                        break;
                    }
                    case 90: {
                        if (this.stream.ReceiveIntegerR(4) != 5) {
                            throw new PSQLException("postgresql.con.setup", PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                        }
                        char l_tStatus = (char)this.stream.ReceiveChar();
                        l_endQuery = true;
                        break;
                    }
                    default: {
                        throw new PSQLException("postgresql.fp.protocol", PSQLState.COMMUNICATION_ERROR, new Character((char)c));
                    }
                }
            }
            if (error != null) {
                throw error;
            }
            byte[] byArray = result;
            Object var6_23 = null;
            return byArray;
        }
    }

    public byte[] getData(String name, FastpathArg[] args) throws SQLException {
        return (byte[])this.fastpath(name, false, args);
    }

    public int getID(String name) throws SQLException {
        Integer id = (Integer)this.func.get(name);
        if (id == null) {
            throw new PSQLException("postgresql.fp.unknown", PSQLState.UNEXPECTED_ERROR, name);
        }
        return id;
    }

    public int getInteger(String name, FastpathArg[] args) throws SQLException {
        Integer i = (Integer)this.fastpath(name, true, args);
        if (i == null) {
            throw new PSQLException("postgresql.fp.expint", (Object)name);
        }
        return i;
    }
}

