package org.nihonsoft.turbosql.swing;

import java.awt.Font;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class DefaultTSQLTheme extends MetalTheme
{
    private final ColorUIResource primary1 = new ColorUIResource(255, 102, 51);
    private final ColorUIResource primary2 = new ColorUIResource(255, 153, 102);
    private final ColorUIResource primary3 = new ColorUIResource(255, 204, 153);
    
    private final ColorUIResource secondary1 = new ColorUIResource(102, 102, 102);
    private final ColorUIResource secondary2 = new ColorUIResource(153, 153, 153);
    private final ColorUIResource secondary3 = new ColorUIResource(204, 204, 204);
    
    private final FontUIResource controlFont = new FontUIResource("Dialog", Font.BOLD, 12);
    private final FontUIResource systemFont =  new FontUIResource("Dialog", Font.PLAIN, 12);
    private final FontUIResource userFont =  new FontUIResource("Dialog", Font.PLAIN, 12);
    private final FontUIResource smallFont= new FontUIResource("Dialog", Font.PLAIN, 10);
    
    public DefaultTSQLTheme()
    {
        super();
    } // public DefaultTSQLTheme()
    
    public String getName()
    {
        return "TSQL BASIC Metal Theme";
    } // public String getName()
    
    protected javax.swing.plaf.ColorUIResource getPrimary1()
    {
        return primary1;
    } // protected javax.swing.plaf.ColorUIResource getPrimary1()
    
    protected javax.swing.plaf.ColorUIResource getPrimary2()
    {
        return primary2;
    } // protected javax.swing.plaf.ColorUIResource getPrimary2()
    
    protected javax.swing.plaf.ColorUIResource getPrimary3()
    {
        return primary3;
    } // protected javax.swing.plaf.ColorUIResource getPrimary3()
    
    protected javax.swing.plaf.ColorUIResource getSecondary1()
    {
        return secondary1;
    } // protected javax.swing.plaf.ColorUIResource getSecondary1()
    
    protected javax.swing.plaf.ColorUIResource getSecondary2()
    {
        return secondary2;
    } // protected javax.swing.plaf.ColorUIResource getSecondary2()
    
    protected javax.swing.plaf.ColorUIResource getSecondary3()
    {
        return secondary3;
    } // protected javax.swing.plaf.ColorUIResource getSecondary3()
    
    public javax.swing.plaf.FontUIResource getControlTextFont()
    {
        return controlFont;
    } // public javax.swing.plaf.FontUIResource getControlTextFont()
    
    public javax.swing.plaf.FontUIResource getMenuTextFont()
    {
        return controlFont;
    } // public javax.swing.plaf.FontUIResource getMenuTextFont()
    
    public javax.swing.plaf.FontUIResource getSubTextFont()
    {
        return smallFont;
    } // public javax.swing.plaf.FontUIResource getSubTextFont()
    
    public javax.swing.plaf.FontUIResource getSystemTextFont()
    {
        return systemFont;
    } // public javax.swing.plaf.FontUIResource getSystemTextFont()
    
    public javax.swing.plaf.FontUIResource getUserTextFont()
    {
        return userFont;
    } // public javax.swing.plaf.FontUIResource getUserTextFont()
    
    public javax.swing.plaf.FontUIResource getWindowTitleFont()
    {
        return controlFont;
    } // public javax.swing.plaf.FontUIResource getWindowTitleFont()
    
} // public class DefaultTSQLTheme extends MetalTheme