package org.nihonsoft.turbosql.modules.pg.ide;

import org.openide.TopManager;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

/** Manages the lifecycle of the turbosqlpg module.
 *
 * @author fchoong
 */
// modified 2002-01-29 15:12.0
// Changed from tutorial to turbosqlpg
public class IDEModuleInstaller extends ModuleInstall {

    /**
     * Do the "one-off" functions, then called restored().
     */
    public void installed() 
    {
        // create the Workspace:
        TopManager tm = TopManager.getDefault();
        WindowManager wm = tm.getWindowManager();
        Workspace newWs = wm.createWorkspace("turbosql PG", "turbosql PG"); //NOI18N
        
        // to make the Workspace visible, get an array of the 
        // existing Workspaces, add our new Workspace, then 
        // set the Workspaces with the new array:
        Workspace oldArray[] = wm.getWorkspaces();
        Workspace newArray[] = new Workspace[oldArray.length + 1];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        newArray[oldArray.length] = newWs;
        wm.setWorkspaces(newArray);
        
        // now call restored, which we are not currently overriding:
        restored ();
    }

    /**
     * Remove the "turbosql PG" Workspace we installed.
     */
    public void uninstalled() 
    {
        // get a TopManager, then the WindowManager:
        TopManager tm = TopManager.getDefault();
        WindowManager wm = tm.getWindowManager();
        
        // remove the workspace from the list.  be smart
        // if it's not there, mostly because we're creating
        // a new smaller array if it is:
        Workspace oldArray[] = wm.getWorkspaces();
        int j = -1;
        for (int i=0; i<oldArray.length; i++)
        {
            if (oldArray[i].getName().equals("turbosql PG")) //NOI18N
            {
                j = i;
            }
        }
        if (j > -1)
        {
            Workspace newArray[] = new Workspace[oldArray.length - 1];
            int newCtr = 0;
            for (int i=0; i<oldArray.length; i++)
            {
                if (i != j)
                {
                    newArray[newCtr++] = oldArray[i];
                }
            }
            wm.setWorkspaces(newArray);
        }
    }

}

