package org.nihonsoft.turbosql.modules.pg.ide;

import org.openide.TopManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

/*
 * turbosql component.
 *
 * Copyright (c) 2002, 2003, 2004
 *      Nihonsoft LLC.  All rights reserved.
 *
 * See the file "license.txt" for information on usage and redistribution
 * of this file.
 */

public class ExplorerAction extends CallableSystemAction
{

    /** Creates new ExplorerAction */
    public ExplorerAction() {
    }

    public String getName() 
    {
        return "Goto turbosql PG - !"; //NOI18N
    }

    public HelpCtx getHelpCtx()
    {
        return HelpCtx.DEFAULT_HELP;
    }

    protected String iconResource()
    {
        return "/org/nihonsoft/turbosql/modules/pg/ide/images/explore16.gif"; //NOI18N
    }
    
    /**
     * This method will do nothing more than pop an explorer
     * for now.  more to come later!
     */
    public void performAction () 
    {
        // almost always need one of these:
        TopManager tm = TopManager.getDefault();

        // modified 2002-01-29 15:12.0
        // Changed from tutorial to turbosql PG
        // switch to the turbosql PG workspace 
        // before popping the explorer:
        WindowManager wm = tm.getWindowManager();
        Workspace turbosqlpg = wm.findWorkspace("turbosql PG"); //NOI18N
        
        // if it does not exist, we will create the workspace on the fly.
        if (turbosqlpg == null)
        {
            // create the Workspace:
            Workspace newWs = wm.createWorkspace("turbosql PG", "turbosql PG"); //NOI18N
        
            // to make the Workspace visible, get an array of the 
            // existing Workspaces, add our new Workspace, then 
            // set the Workspaces with the new array:
            Workspace oldArray[] = wm.getWorkspaces();
            Workspace newArray[] = new Workspace[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = newWs;
            wm.setWorkspaces(newArray);
            turbosqlpg = newWs;
        }
        
        turbosqlpg.activate();
        
        // get a node to explore (see OpenAPI javadocs), then call
        // convenience method in TopManager.NodeOperation to explore:
        //Node nodeToExplore = tm.getPlaces().nodes().repository();
        //tm.getNodeOperation().explore(nodeToExplore);
        
        //DemoWindow dWin = new DemoWindow();
        //Sketcher dWin = new Sketcher();
        //dWin.open();
        MainTopComponent mainTC = new MainTopComponent();
        mainTC.open();
    }
}

