#include "bootpack.h"

struct CHUNK_STACK *stack_alloc(void)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	return (struct CHUNK_STACK *) memman_alloc_4k(memman, sizeof(struct CHUNK_STACK));
}

void stack_init(struct CHUNK_STACK *stack)
{
	stack->sp = 0;
}

void stack_push(struct CHUNK_STACK *stack, char *chunk)
{
	stack->sp++;
	if(stack->sp == 512) stack->sp = 511;
	memcpy(stack->string[1], stack->string[0], 1024*512-512);
	strcpy(stack->string[0],chunk);
}

char *stack_pop(struct CHUNK_STACK *stack)
{
	char pop[1024];
	strcpy(pop,stack->string[0]);
	if(stack->sp != 0) {
		stack->sp--;
		memcpy(stack->string[0], stack->string[1], 1024*512-512);
	}
	return pop;
}

void stack_free(struct CHUNK_STACK *stack)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	memman_free_4k(memman, (int) stack, sizeof(struct CHUNK_STACK));
}
